//@line 36 "/usr/src/mozilla/firefox/browser/components/preferences/../../../../mozilla/browser/components/preferences/advanced.js"

var gAdvancedPane = {
  _inited: false,
  init: function ()
  {
    this._inited = true;
    var advancedPrefs = document.getElementById("advancedPrefs");
    var preference = document.getElementById("browser.preferences.advanced.selectedTabIndex");
    if (preference.value === null)
      return;
    advancedPrefs.selectedIndex = preference.value;
  },
  
  tabSelectionChanged: function ()
  {
    if (!this._inited)
      return;
    var advancedPrefs = document.getElementById("advancedPrefs");
    var preference = document.getElementById("browser.preferences.advanced.selectedTabIndex");
    preference.valueFromPreferences = advancedPrefs.selectedIndex;
  },
  
  updateButtons: function (aButtonID, aPreferenceID)
  {
    var button = document.getElementById(aButtonID);
    var preference = document.getElementById(aPreferenceID);
    // This is actually before the value changes, so the value is not as you expect. 
    button.disabled = preference.value == true;
    return undefined;
  },

  showCertificates: function ()
  {
    document.documentElement.openWindow("mozilla:certmanager",
                                        "chrome://pippki/content/certManager.xul",
                                        "width=600,height=400", null);
  },
  
  showCRLs: function ()
  {
    document.documentElement.openWindow("Mozilla:CRLManager", 
                                        "chrome://pippki/content/crlManager.xul",
                                        "width=600,height=400", null);
  },
  
  showOCSP: function ()
  {
    document.documentElement.openSubDialog("chrome://mozapps/content/preferences/ocsp.xul",
                                           "", null);
  },
  
  showSecurityDevices: function ()
  {
    document.documentElement.openWindow("mozilla:devicemanager",
                                        "chrome://pippki/content/device_manager.xul",
                                        "width=600,height=400", null);
  },
  
  updateAppUpdateUI: function ()
  {
    var preference = document.getElementById("app.update.enabled");
    document.getElementById("enableAutoInstall").disabled = !preference.value;

    var aus = 
        Components.classes["@mozilla.org/updates/update-service;1"].
        getService(Components.interfaces.nsIApplicationUpdateService);
    var checkNowButton = document.getElementById("checkNowButton");
    checkNowButton.disabled = !aus.canUpdate;

    this.updateAutoPref();
    return undefined;
  },
  
  updateAutoPref: function () 
  {
    var preference = document.getElementById("app.update.auto");
    var updateEnabledPref = document.getElementById("app.update.enabled");
    var autoInstallOptions = document.getElementById("autoInstallOptions");
    autoInstallOptions.disabled = !preference.value || !updateEnabledPref.value;
    return undefined;
  },
  
  checkForAddonUpdates: function ()
  {
    var updateTypes = 
        Components.classes["@mozilla.org/supports-PRUint8;1"].
        createInstance(Components.interfaces.nsISupportsPRUint8);
    updateTypes.data = Components.interfaces.nsIUpdateItem.TYPE_ADDON;
    var showMismatch = 
        Components.classes["@mozilla.org/supports-PRBool;1"].
        createInstance(Components.interfaces.nsISupportsPRBool);
    showMismatch.data = false;
    var ary = 
        Components.classes["@mozilla.org/supports-array;1"].
        createInstance(Components.interfaces.nsISupportsArray);
    ary.AppendElement(updateTypes);
    ary.AppendElement(showMismatch);

    var features = "chrome,centerscreen,dialog,titlebar";
    const URI_EXTENSION_UPDATE_DIALOG = 
      "chrome://mozapps/content/extensions/update.xul";
    var ww = 
        Components.classes["@mozilla.org/embedcomp/window-watcher;1"].
        getService(Components.interfaces.nsIWindowWatcher);
    ww.openWindow(window, URI_EXTENSION_UPDATE_DIALOG, "", features, ary);  
  },
  
  checkForUpdates: function ()
  {
    var prompter = Components.classes["@mozilla.org/updates/update-prompt;1"]
                             .createInstance(Components.interfaces.nsIUpdatePrompt);
    prompter.checkForUpdates();
  },
  
  showAutoInstallOptions: function () 
  {
    document.documentElement.openSubDialog("chrome://mozapps/content/preferences/update.xul",
                                           "", null);  
  },
  
  showUpdates: function ()
  {
    var prompter = Components.classes["@mozilla.org/updates/update-prompt;1"]
                             .createInstance(Components.interfaces.nsIUpdatePrompt);
    prompter.showUpdateHistory(window);
  },
  
  showLanguages: function ()
  {
    document.documentElement.openSubDialog("chrome://browser/content/preferences/languages.xul",
                                           "", null);  
  }
};

