/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.nio;

import gnu.java.nio.CharBufferImpl;
import gnu.java.nio.DoubleBufferImpl;
import gnu.java.nio.FloatBufferImpl;
import gnu.java.nio.IntBufferImpl;
import gnu.java.nio.LongBufferImpl;
import gnu.java.nio.ShortBufferImpl;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ByteBufferImpl
extends ByteBuffer {
    private byte[] backing_buffer;
    private int array_offset;
    private boolean ro;

    public ByteBufferImpl(int n, int n2, int n3) {
        this.cap = n;
        this.limit(n3);
        this.position(n2);
        this.backing_buffer = new byte[n];
    }

    public ByteBufferImpl(byte[] byArray, int n, int n2) {
        this.cap = byArray.length;
        this.limit(n2);
        this.position(n);
        this.backing_buffer = byArray;
    }

    public ByteBufferImpl(ByteBufferImpl byteBufferImpl) {
        this.cap = byteBufferImpl.capacity();
        this.limit(byteBufferImpl.limit());
        this.position(byteBufferImpl.position());
        this.ro = byteBufferImpl.ro;
        this.backing_buffer = byteBufferImpl.backing_buffer;
    }

    void inc_pos(int n) {
        this.position(this.position() + n);
    }

    private static native byte[] nio_cast(byte[] var0);

    private static native byte[] nio_cast(char[] var0);

    private static native byte[] nio_cast(short[] var0);

    private static native byte[] nio_cast(long[] var0);

    private static native byte[] nio_cast(int[] var0);

    private static native byte[] nio_cast(float[] var0);

    private static native byte[] nio_cast(double[] var0);

    ByteBufferImpl(byte[] byArray) {
        this.backing_buffer = byArray != null ? ByteBufferImpl.nio_cast(byArray) : null;
    }

    private static native byte nio_get_Byte(ByteBufferImpl var0, int var1, int var2);

    private static native void nio_put_Byte(ByteBufferImpl var0, int var1, int var2, byte var3);

    public ByteBuffer asByteBuffer() {
        ByteBufferImpl byteBufferImpl = new ByteBufferImpl(this.backing_buffer);
        byteBufferImpl.limit(this.limit() * 1 / 1);
        return byteBufferImpl;
    }

    ByteBufferImpl(char[] cArray) {
        this.backing_buffer = cArray != null ? ByteBufferImpl.nio_cast(cArray) : null;
    }

    private static native char nio_get_Char(ByteBufferImpl var0, int var1, int var2);

    private static native void nio_put_Char(ByteBufferImpl var0, int var1, int var2, char var3);

    @Override
    public CharBuffer asCharBuffer() {
        CharBufferImpl charBufferImpl = new CharBufferImpl(this.backing_buffer);
        charBufferImpl.limit(this.limit() * 2 / 1);
        return charBufferImpl;
    }

    ByteBufferImpl(short[] sArray) {
        this.backing_buffer = sArray != null ? ByteBufferImpl.nio_cast(sArray) : null;
    }

    private static native short nio_get_Short(ByteBufferImpl var0, int var1, int var2);

    private static native void nio_put_Short(ByteBufferImpl var0, int var1, int var2, short var3);

    @Override
    public ShortBuffer asShortBuffer() {
        ShortBufferImpl shortBufferImpl = new ShortBufferImpl(this.backing_buffer);
        shortBufferImpl.limit(this.limit() * 2 / 1);
        return shortBufferImpl;
    }

    ByteBufferImpl(int[] nArray) {
        this.backing_buffer = nArray != null ? ByteBufferImpl.nio_cast(nArray) : null;
    }

    private static native int nio_get_Int(ByteBufferImpl var0, int var1, int var2);

    private static native void nio_put_Int(ByteBufferImpl var0, int var1, int var2, int var3);

    @Override
    public IntBuffer asIntBuffer() {
        IntBufferImpl intBufferImpl = new IntBufferImpl(this.backing_buffer);
        intBufferImpl.limit(this.limit() * 4 / 1);
        return intBufferImpl;
    }

    ByteBufferImpl(long[] lArray) {
        this.backing_buffer = lArray != null ? ByteBufferImpl.nio_cast(lArray) : null;
    }

    private static native long nio_get_Long(ByteBufferImpl var0, int var1, int var2);

    private static native void nio_put_Long(ByteBufferImpl var0, int var1, int var2, long var3);

    @Override
    public LongBuffer asLongBuffer() {
        LongBufferImpl longBufferImpl = new LongBufferImpl(this.backing_buffer);
        longBufferImpl.limit(this.limit() * 8 / 1);
        return longBufferImpl;
    }

    ByteBufferImpl(float[] fArray) {
        this.backing_buffer = fArray != null ? ByteBufferImpl.nio_cast(fArray) : null;
    }

    private static native float nio_get_Float(ByteBufferImpl var0, int var1, int var2);

    private static native void nio_put_Float(ByteBufferImpl var0, int var1, int var2, float var3);

    @Override
    public FloatBuffer asFloatBuffer() {
        FloatBufferImpl floatBufferImpl = new FloatBufferImpl(this.backing_buffer);
        floatBufferImpl.limit(this.limit() * 4 / 1);
        return floatBufferImpl;
    }

    ByteBufferImpl(double[] dArray) {
        this.backing_buffer = dArray != null ? ByteBufferImpl.nio_cast(dArray) : null;
    }

    private static native double nio_get_Double(ByteBufferImpl var0, int var1, int var2);

    private static native void nio_put_Double(ByteBufferImpl var0, int var1, int var2, double var3);

    @Override
    public DoubleBuffer asDoubleBuffer() {
        DoubleBufferImpl doubleBufferImpl = new DoubleBufferImpl(this.backing_buffer);
        doubleBufferImpl.limit(this.limit() * 8 / 1);
        return doubleBufferImpl;
    }

    @Override
    public boolean isReadOnly() {
        return this.ro;
    }

    @Override
    public ByteBuffer slice() {
        ByteBufferImpl byteBufferImpl = new ByteBufferImpl(this);
        byteBufferImpl.array_offset = this.position();
        return byteBufferImpl;
    }

    @Override
    public ByteBuffer duplicate() {
        return new ByteBufferImpl(this);
    }

    @Override
    public ByteBuffer asReadOnlyBuffer() {
        ByteBufferImpl byteBufferImpl = new ByteBufferImpl(this);
        byteBufferImpl.ro = true;
        return byteBufferImpl;
    }

    @Override
    public ByteBuffer compact() {
        return this;
    }

    @Override
    public boolean isDirect() {
        return this.backing_buffer != null;
    }

    @Override
    public final byte get() {
        byte by = this.backing_buffer[this.position()];
        this.position(this.position() + 1);
        return by;
    }

    @Override
    public final ByteBuffer put(byte by) {
        this.backing_buffer[this.position()] = by;
        this.position(this.position() + 1);
        return this;
    }

    @Override
    public final byte get(int n) {
        return this.backing_buffer[n];
    }

    @Override
    public final ByteBuffer put(int n, byte by) {
        this.backing_buffer[n] = by;
        return this;
    }

    @Override
    public final char getChar() {
        char c = ByteBufferImpl.nio_get_Char(this, this.position(), this.limit());
        this.inc_pos(2);
        return c;
    }

    @Override
    public final ByteBuffer putChar(char c) {
        ByteBufferImpl.nio_put_Char(this, this.position(), this.limit(), c);
        this.inc_pos(2);
        return this;
    }

    @Override
    public final char getChar(int n) {
        char c = ByteBufferImpl.nio_get_Char(this, n, this.limit());
        return c;
    }

    @Override
    public final ByteBuffer putChar(int n, char c) {
        ByteBufferImpl.nio_put_Char(this, n, this.limit(), c);
        return this;
    }

    @Override
    public final short getShort() {
        short s = ByteBufferImpl.nio_get_Short(this, this.position(), this.limit());
        this.inc_pos(2);
        return s;
    }

    @Override
    public final ByteBuffer putShort(short s) {
        ByteBufferImpl.nio_put_Short(this, this.position(), this.limit(), s);
        this.inc_pos(2);
        return this;
    }

    @Override
    public final short getShort(int n) {
        short s = ByteBufferImpl.nio_get_Short(this, n, this.limit());
        return s;
    }

    @Override
    public final ByteBuffer putShort(int n, short s) {
        ByteBufferImpl.nio_put_Short(this, n, this.limit(), s);
        return this;
    }

    @Override
    public final int getInt() {
        int n = ByteBufferImpl.nio_get_Int(this, this.position(), this.limit());
        this.inc_pos(4);
        return n;
    }

    @Override
    public final ByteBuffer putInt(int n) {
        ByteBufferImpl.nio_put_Int(this, this.position(), this.limit(), n);
        this.inc_pos(4);
        return this;
    }

    @Override
    public final int getInt(int n) {
        int n2 = ByteBufferImpl.nio_get_Int(this, n, this.limit());
        return n2;
    }

    @Override
    public final ByteBuffer putInt(int n, int n2) {
        ByteBufferImpl.nio_put_Int(this, n, this.limit(), n2);
        return this;
    }

    @Override
    public final long getLong() {
        long l = ByteBufferImpl.nio_get_Long(this, this.position(), this.limit());
        this.inc_pos(8);
        return l;
    }

    @Override
    public final ByteBuffer putLong(long l) {
        ByteBufferImpl.nio_put_Long(this, this.position(), this.limit(), l);
        this.inc_pos(8);
        return this;
    }

    @Override
    public final long getLong(int n) {
        long l = ByteBufferImpl.nio_get_Long(this, n, this.limit());
        return l;
    }

    @Override
    public final ByteBuffer putLong(int n, long l) {
        ByteBufferImpl.nio_put_Long(this, n, this.limit(), l);
        return this;
    }

    @Override
    public final float getFloat() {
        float f = ByteBufferImpl.nio_get_Float(this, this.position(), this.limit());
        this.inc_pos(4);
        return f;
    }

    @Override
    public final ByteBuffer putFloat(float f) {
        ByteBufferImpl.nio_put_Float(this, this.position(), this.limit(), f);
        this.inc_pos(4);
        return this;
    }

    @Override
    public final float getFloat(int n) {
        float f = ByteBufferImpl.nio_get_Float(this, n, this.limit());
        return f;
    }

    @Override
    public final ByteBuffer putFloat(int n, float f) {
        ByteBufferImpl.nio_put_Float(this, n, this.limit(), f);
        return this;
    }

    @Override
    public final double getDouble() {
        double d = ByteBufferImpl.nio_get_Double(this, this.position(), this.limit());
        this.inc_pos(8);
        return d;
    }

    @Override
    public final ByteBuffer putDouble(double d) {
        ByteBufferImpl.nio_put_Double(this, this.position(), this.limit(), d);
        this.inc_pos(8);
        return this;
    }

    @Override
    public final double getDouble(int n) {
        double d = ByteBufferImpl.nio_get_Double(this, n, this.limit());
        return d;
    }

    @Override
    public final ByteBuffer putDouble(int n, double d) {
        ByteBufferImpl.nio_put_Double(this, n, this.limit(), d);
        return this;
    }
}

