/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.nio;

import gnu.java.nio.ByteBufferImpl;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.CharBuffer;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CharBufferImpl
extends CharBuffer {
    private boolean ro;
    private ByteOrder endian;

    public CharBufferImpl(int n, int n2, int n3) {
        this.Block$();
        this.backing_buffer = new char[n];
        this.cap = n;
        this.limit(n3);
        this.position(n2);
    }

    public CharBufferImpl(char[] cArray, int n, int n2) {
        this.Block$();
        this.backing_buffer = cArray;
        this.cap = cArray.length;
        this.limit(n2);
        this.position(n);
    }

    public CharBufferImpl(CharBufferImpl charBufferImpl) {
        this.Block$();
        this.backing_buffer = charBufferImpl.backing_buffer;
        this.ro = charBufferImpl.ro;
        this.limit(charBufferImpl.limit());
        this.position(charBufferImpl.position());
    }

    void inc_pos(int n) {
        this.position(this.position() + n);
    }

    private static native char[] nio_cast(byte[] var0);

    CharBufferImpl(byte[] byArray) {
        this.Block$();
        this.backing_buffer = byArray != null ? CharBufferImpl.nio_cast(byArray) : null;
    }

    private static native byte nio_get_Byte(CharBufferImpl var0, int var1, int var2);

    private static native void nio_put_Byte(CharBufferImpl var0, int var1, int var2, byte var3);

    public ByteBuffer asByteBuffer() {
        ByteBufferImpl byteBufferImpl = new ByteBufferImpl(this.backing_buffer);
        byteBufferImpl.limit(this.limit() * 1 / 2);
        return byteBufferImpl;
    }

    @Override
    public boolean isReadOnly() {
        return this.ro;
    }

    @Override
    public CharBuffer slice() {
        CharBufferImpl charBufferImpl = new CharBufferImpl(this);
        charBufferImpl.array_offset = this.position();
        return charBufferImpl;
    }

    @Override
    public CharBuffer duplicate() {
        return new CharBufferImpl(this);
    }

    @Override
    public CharBuffer asReadOnlyBuffer() {
        CharBufferImpl charBufferImpl = new CharBufferImpl(this);
        charBufferImpl.ro = true;
        return charBufferImpl;
    }

    @Override
    public CharBuffer compact() {
        return this;
    }

    @Override
    public boolean isDirect() {
        return this.backing_buffer != null;
    }

    @Override
    public final CharSequence subSequence(int n, int n2) {
        if (n < 0 || n2 > this.length() || n > n2) {
            throw new IndexOutOfBoundsException();
        }
        return new CharBufferImpl(this.array(), this.position() + n, this.position() + n2);
    }

    @Override
    public final char get() {
        char c = this.backing_buffer[this.position()];
        this.position(this.position() + 1);
        return c;
    }

    @Override
    public final CharBuffer put(char c) {
        this.backing_buffer[this.position()] = c;
        this.position(this.position() + 1);
        return this;
    }

    @Override
    public final char get(int n) {
        return this.backing_buffer[n];
    }

    @Override
    public final CharBuffer put(int n, char c) {
        this.backing_buffer[n] = c;
        return this;
    }

    @Override
    public final ByteOrder order() {
        return this.endian;
    }

    private /* synthetic */ void Block$() {
        this.endian = ByteOrder.BIG_ENDIAN;
    }
}

