/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.nio;

import gnu.java.nio.ByteBufferImpl;
import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DoubleBufferImpl
extends DoubleBuffer {
    private int array_offset;
    private boolean ro;

    public DoubleBufferImpl(int n, int n2, int n3) {
        this.backing_buffer = new double[n];
        this.cap = n;
        this.limit(n3);
        this.position(n2);
    }

    public DoubleBufferImpl(double[] dArray, int n, int n2) {
        this.backing_buffer = dArray;
        this.cap = dArray.length;
        this.limit(n2);
        this.position(n);
    }

    public DoubleBufferImpl(DoubleBufferImpl doubleBufferImpl) {
        this.backing_buffer = doubleBufferImpl.backing_buffer;
        this.ro = doubleBufferImpl.ro;
        this.limit(doubleBufferImpl.limit());
        this.position(doubleBufferImpl.position());
    }

    void inc_pos(int n) {
        this.position(this.position() + n);
    }

    DoubleBufferImpl(byte[] byArray) {
        this.backing_buffer = byArray != null ? DoubleBufferImpl.nio_cast(byArray) : null;
    }

    private static native byte nio_get_Byte(DoubleBufferImpl var0, int var1, int var2);

    private static native void nio_put_Byte(DoubleBufferImpl var0, int var1, int var2, byte var3);

    public ByteBuffer asByteBuffer() {
        ByteBufferImpl byteBufferImpl = new ByteBufferImpl(this.backing_buffer);
        byteBufferImpl.limit(this.limit() * 1 / 8);
        return byteBufferImpl;
    }

    private static native double[] nio_cast(byte[] var0);

    @Override
    public boolean isReadOnly() {
        return this.ro;
    }

    @Override
    public DoubleBuffer slice() {
        DoubleBufferImpl doubleBufferImpl = new DoubleBufferImpl(this);
        doubleBufferImpl.array_offset = this.position();
        return doubleBufferImpl;
    }

    @Override
    public DoubleBuffer duplicate() {
        return new DoubleBufferImpl(this);
    }

    @Override
    public DoubleBuffer asReadOnlyBuffer() {
        DoubleBufferImpl doubleBufferImpl = new DoubleBufferImpl(this);
        doubleBufferImpl.ro = true;
        return doubleBufferImpl;
    }

    @Override
    public DoubleBuffer compact() {
        return this;
    }

    @Override
    public boolean isDirect() {
        return this.backing_buffer != null;
    }

    @Override
    public final double get() {
        double d = this.backing_buffer[this.position()];
        this.position(this.position() + 1);
        return d;
    }

    @Override
    public final DoubleBuffer put(double d) {
        this.backing_buffer[this.position()] = d;
        this.position(this.position() + 1);
        return this;
    }

    @Override
    public final double get(int n) {
        return this.backing_buffer[n];
    }

    @Override
    public final DoubleBuffer put(int n, double d) {
        this.backing_buffer[n] = d;
        return this;
    }
}

