/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.nio;

import gnu.java.nio.MappedByteFileBuffer;
import java.io.EOFException;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileChannelImpl
extends FileChannel {
    public long address;
    public int length;
    public int fd;
    public MappedByteBuffer buf;
    public Object file_obj;

    private native long lengthInternal(int var1) throws IOException;

    public FileChannelImpl(int n, Object object) {
        this.fd = n;
        this.file_obj = object;
    }

    @Override
    public long size() throws IOException {
        return this.lengthInternal(this.fd);
    }

    @Override
    protected void implCloseChannel() throws IOException {
        if (this.address != 0L) {
            FileChannelImpl.nio_unmmap_file(this.fd, this.address, this.length);
        }
        this.fd = 0;
        if (this.file_obj instanceof RandomAccessFile) {
            RandomAccessFile randomAccessFile = (RandomAccessFile)this.file_obj;
            randomAccessFile.close();
            return;
        }
        if (this.file_obj instanceof FileInputStream) {
            FileInputStream fileInputStream = (FileInputStream)this.file_obj;
            fileInputStream.close();
            return;
        }
        if (this.file_obj instanceof FileOutputStream) {
            FileOutputStream fileOutputStream = (FileOutputStream)this.file_obj;
            fileOutputStream.close();
        }
    }

    @Override
    public int read(ByteBuffer byteBuffer) throws IOException {
        boolean bl = false;
        int n = (int)this.size();
        if (this.buf == null) {
            throw new EOFException("file not mapped");
        }
        int n2 = 0;
        while (n2 < n) {
            byteBuffer.put(this.buf.get());
            ++n2;
        }
        return n;
    }

    @Override
    public long read(ByteBuffer[] byteBufferArray, int n, int n2) throws IOException {
        long l = 0L;
        int n3 = n;
        while (n3 < n + n2) {
            l += (long)this.write(byteBufferArray[n3]);
            ++n3;
        }
        return l;
    }

    public int read(ByteBuffer byteBuffer, long l) throws IOException {
        return 0;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public int write(ByteBuffer var1_1) throws IOException {
        var2_2 = 0;
        if (this.buf != null) ** GOTO lbl7
        throw new EOFException("file not mapped");
lbl-1000:
        // 1 sources

        {
            this.buf.put(var1_1.get());
            ++var2_2;
lbl7:
            // 2 sources

            ** while (var1_1.hasRemaining())
        }
lbl8:
        // 1 sources

        return var2_2;
    }

    @Override
    public long write(ByteBuffer[] byteBufferArray, int n, int n2) throws IOException {
        long l = 0L;
        int n3 = n;
        while (n3 < n + n2) {
            l += (long)this.write(byteBufferArray[n3]);
            ++n3;
        }
        return l;
    }

    public int write(ByteBuffer byteBuffer, long l) throws IOException {
        return 0;
    }

    @Override
    public MappedByteBuffer map(FileChannel.MapMode mapMode, long l, long l2) throws IOException {
        return null;
    }

    static MappedByteBuffer create_direct_mapped_buffer(long l, long l2) {
        FileChannelImpl fileChannelImpl = new FileChannelImpl(-1, null);
        fileChannelImpl.address = l;
        fileChannelImpl.length = (int)l2;
        fileChannelImpl.buf = new MappedByteFileBuffer(fileChannelImpl);
        return fileChannelImpl.buf;
    }

    @Override
    public long write(ByteBuffer[] byteBufferArray) throws IOException {
        return this.write(byteBufferArray, 0, byteBufferArray.length);
    }

    @Override
    public void force(boolean bl) {
        FileChannelImpl.nio_msync(this.fd, this.address, this.length);
    }

    static native long nio_mmap_file(int var0, long var1, int var3, int var4);

    static native void nio_unmmap_file(int var0, long var1, int var3);

    static native void nio_msync(int var0, long var1, int var3);

    public FileLock lock(long l, long l2, boolean bl) throws IOException {
        return null;
    }

    public FileLock tryLock(long l, long l2, boolean bl) throws IOException {
        return null;
    }

    public long position() throws IOException {
        return 0L;
    }

    public FileChannel position(long l) throws IOException {
        return this;
    }

    public long transferTo(long l, long l2, WritableByteChannel writableByteChannel) throws IOException {
        return 0L;
    }

    public long transferFrom(ReadableByteChannel readableByteChannel, long l, long l2) throws IOException {
        return 0L;
    }

    public FileChannel truncate(long l) throws IOException {
        return null;
    }
}

