/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.nio;

import gnu.java.nio.ByteBufferImpl;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FloatBufferImpl
extends FloatBuffer {
    private int array_offset;
    private boolean ro;

    public FloatBufferImpl(int n, int n2, int n3) {
        this.backing_buffer = new float[n];
        this.cap = n;
        this.limit(n3);
        this.position(n2);
    }

    public FloatBufferImpl(float[] fArray, int n, int n2) {
        this.backing_buffer = fArray;
        this.cap = fArray.length;
        this.limit(n2);
        this.position(n);
    }

    public FloatBufferImpl(FloatBufferImpl floatBufferImpl) {
        this.backing_buffer = floatBufferImpl.backing_buffer;
        this.ro = floatBufferImpl.ro;
        this.limit(floatBufferImpl.limit());
        this.position(floatBufferImpl.position());
    }

    void inc_pos(int n) {
        this.position(this.position() + n);
    }

    private static native float[] nio_cast(byte[] var0);

    FloatBufferImpl(byte[] byArray) {
        this.backing_buffer = byArray != null ? FloatBufferImpl.nio_cast(byArray) : null;
    }

    private static native byte nio_get_Byte(FloatBufferImpl var0, int var1, int var2);

    private static native void nio_put_Byte(FloatBufferImpl var0, int var1, int var2, byte var3);

    public ByteBuffer asByteBuffer() {
        ByteBufferImpl byteBufferImpl = new ByteBufferImpl(this.backing_buffer);
        byteBufferImpl.limit(this.limit() * 1 / 4);
        return byteBufferImpl;
    }

    @Override
    public boolean isReadOnly() {
        return this.ro;
    }

    @Override
    public FloatBuffer slice() {
        FloatBufferImpl floatBufferImpl = new FloatBufferImpl(this);
        floatBufferImpl.array_offset = this.position();
        return floatBufferImpl;
    }

    @Override
    public FloatBuffer duplicate() {
        return new FloatBufferImpl(this);
    }

    @Override
    public FloatBuffer asReadOnlyBuffer() {
        FloatBufferImpl floatBufferImpl = new FloatBufferImpl(this);
        floatBufferImpl.ro = true;
        return floatBufferImpl;
    }

    @Override
    public FloatBuffer compact() {
        return this;
    }

    @Override
    public boolean isDirect() {
        return this.backing_buffer != null;
    }

    @Override
    public final float get() {
        float f = this.backing_buffer[this.position()];
        this.position(this.position() + 1);
        return f;
    }

    @Override
    public final FloatBuffer put(float f) {
        this.backing_buffer[this.position()] = f;
        this.position(this.position() + 1);
        return this;
    }

    @Override
    public final float get(int n) {
        return this.backing_buffer[n];
    }

    @Override
    public final FloatBuffer put(int n, float f) {
        this.backing_buffer[n] = f;
        return this;
    }
}

