/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.nio;

import gnu.java.nio.ByteBufferImpl;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class IntBufferImpl
extends IntBuffer {
    private int array_offset;
    private boolean ro;

    public IntBufferImpl(int n, int n2, int n3) {
        this.backing_buffer = new int[n];
        this.cap = n;
        this.limit(n3);
        this.position(n2);
    }

    public IntBufferImpl(int[] nArray, int n, int n2) {
        this.backing_buffer = nArray;
        this.cap = nArray.length;
        this.limit(n2);
        this.position(n);
    }

    public IntBufferImpl(IntBufferImpl intBufferImpl) {
        this.backing_buffer = intBufferImpl.backing_buffer;
        this.ro = intBufferImpl.ro;
        this.limit(intBufferImpl.limit());
        this.position(intBufferImpl.position());
    }

    void inc_pos(int n) {
        this.position(this.position() + n);
    }

    private static native int[] nio_cast(byte[] var0);

    IntBufferImpl(byte[] byArray) {
        this.backing_buffer = byArray != null ? IntBufferImpl.nio_cast(byArray) : null;
    }

    private static native byte nio_get_Byte(IntBufferImpl var0, int var1, int var2);

    private static native void nio_put_Byte(IntBufferImpl var0, int var1, int var2, byte var3);

    public ByteBuffer asByteBuffer() {
        ByteBufferImpl byteBufferImpl = new ByteBufferImpl(this.backing_buffer);
        byteBufferImpl.limit(this.limit() * 1 / 4);
        return byteBufferImpl;
    }

    @Override
    public boolean isReadOnly() {
        return this.ro;
    }

    @Override
    public IntBuffer slice() {
        IntBufferImpl intBufferImpl = new IntBufferImpl(this);
        intBufferImpl.array_offset = this.position();
        return intBufferImpl;
    }

    @Override
    public IntBuffer duplicate() {
        return new IntBufferImpl(this);
    }

    @Override
    public IntBuffer asReadOnlyBuffer() {
        IntBufferImpl intBufferImpl = new IntBufferImpl(this);
        intBufferImpl.ro = true;
        return intBufferImpl;
    }

    @Override
    public IntBuffer compact() {
        return this;
    }

    @Override
    public boolean isDirect() {
        return this.backing_buffer != null;
    }

    @Override
    public final int get() {
        int n = this.backing_buffer[this.position()];
        this.position(this.position() + 1);
        return n;
    }

    @Override
    public final IntBuffer put(int n) {
        this.backing_buffer[this.position()] = n;
        this.position(this.position() + 1);
        return this;
    }

    @Override
    public final int get(int n) {
        return this.backing_buffer[n];
    }

    @Override
    public final IntBuffer put(int n, int n2) {
        this.backing_buffer[n] = n2;
        return this;
    }
}

