/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.nio;

import gnu.java.nio.ByteBufferImpl;
import java.nio.ByteBuffer;
import java.nio.LongBuffer;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LongBufferImpl
extends LongBuffer {
    private int array_offset;
    private boolean ro;

    public LongBufferImpl(int n, int n2, int n3) {
        this.backing_buffer = new long[n];
        this.cap = n;
        this.limit(n3);
        this.position(n2);
    }

    public LongBufferImpl(long[] lArray, int n, int n2) {
        this.backing_buffer = lArray;
        this.cap = lArray.length;
        this.limit(n2);
        this.position(n);
    }

    public LongBufferImpl(LongBufferImpl longBufferImpl) {
        this.backing_buffer = longBufferImpl.backing_buffer;
        this.ro = longBufferImpl.ro;
        this.limit(longBufferImpl.limit());
        this.position(longBufferImpl.position());
    }

    void inc_pos(int n) {
        this.position(this.position() + n);
    }

    private static native long[] nio_cast(byte[] var0);

    LongBufferImpl(byte[] byArray) {
        this.backing_buffer = byArray != null ? LongBufferImpl.nio_cast(byArray) : null;
    }

    private static native byte nio_get_Byte(LongBufferImpl var0, int var1, int var2);

    private static native void nio_put_Byte(LongBufferImpl var0, int var1, int var2, byte var3);

    public ByteBuffer asByteBuffer() {
        ByteBufferImpl byteBufferImpl = new ByteBufferImpl(this.backing_buffer);
        byteBufferImpl.limit(this.limit() * 1 / 8);
        return byteBufferImpl;
    }

    @Override
    public boolean isReadOnly() {
        return this.ro;
    }

    @Override
    public LongBuffer slice() {
        LongBufferImpl longBufferImpl = new LongBufferImpl(this);
        longBufferImpl.array_offset = this.position();
        return longBufferImpl;
    }

    @Override
    public LongBuffer duplicate() {
        return new LongBufferImpl(this);
    }

    @Override
    public LongBuffer asReadOnlyBuffer() {
        LongBufferImpl longBufferImpl = new LongBufferImpl(this);
        longBufferImpl.ro = true;
        return longBufferImpl;
    }

    @Override
    public LongBuffer compact() {
        return this;
    }

    @Override
    public boolean isDirect() {
        return this.backing_buffer != null;
    }

    @Override
    public final long get() {
        long l = this.backing_buffer[this.position()];
        this.position(this.position() + 1);
        return l;
    }

    @Override
    public final LongBuffer put(long l) {
        this.backing_buffer[this.position()] = l;
        this.position(this.position() + 1);
        return this;
    }

    @Override
    public final long get(int n) {
        return this.backing_buffer[n];
    }

    @Override
    public final LongBuffer put(int n, long l) {
        this.backing_buffer[n] = l;
        return this;
    }
}

