/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.nio;

import gnu.java.nio.FileChannelImpl;
import gnu.java.nio.MappedCharFileBuffer;
import gnu.java.nio.MappedDoubleFileBuffer;
import gnu.java.nio.MappedFloatFileBuffer;
import gnu.java.nio.MappedIntFileBuffer;
import gnu.java.nio.MappedLongFileBuffer;
import gnu.java.nio.MappedShortFileBuffer;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.MappedByteBuffer;
import java.nio.ShortBuffer;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MappedByteFileBuffer
extends MappedByteBuffer {
    public long address;
    boolean ro;
    boolean direct;
    public FileChannelImpl ch;

    public MappedByteFileBuffer(FileChannelImpl fileChannelImpl) {
        this.ch = fileChannelImpl;
        this.address = fileChannelImpl.address;
        try {
            long l = fileChannelImpl.size() / 1L;
            this.limit((int)l);
            return;
        }
        catch (IOException iOException) {
            System.err.println("failed to get size of file-channel's file");
            return;
        }
    }

    public MappedByteFileBuffer(MappedByteFileBuffer mappedByteFileBuffer) {
        this.ro = mappedByteFileBuffer.ro;
        this.ch = mappedByteFileBuffer.ch;
        this.address = mappedByteFileBuffer.address;
        this.limit(mappedByteFileBuffer.limit());
    }

    @Override
    public boolean isReadOnly() {
        return this.ro;
    }

    public static native byte nio_read_Byte_file_channel(FileChannelImpl var0, int var1, int var2, long var3);

    public static native void nio_write_Byte_file_channel(FileChannelImpl var0, int var1, int var2, byte var3, long var4);

    public static native short nio_read_Short_file_channel(FileChannelImpl var0, int var1, int var2, long var3);

    public static native void nio_write_Short_file_channel(FileChannelImpl var0, int var1, int var2, short var3, long var4);

    public static native char nio_read_Char_file_channel(FileChannelImpl var0, int var1, int var2, long var3);

    public static native void nio_write_Char_file_channel(FileChannelImpl var0, int var1, int var2, char var3, long var4);

    public static native int nio_read_Int_file_channel(FileChannelImpl var0, int var1, int var2, long var3);

    public static native void nio_write_Int_file_channel(FileChannelImpl var0, int var1, int var2, int var3, long var4);

    public static native long nio_read_Long_file_channel(FileChannelImpl var0, int var1, int var2, long var3);

    public static native void nio_write_Long_file_channel(FileChannelImpl var0, int var1, int var2, long var3, long var5);

    public static native float nio_read_Float_file_channel(FileChannelImpl var0, int var1, int var2, long var3);

    public static native void nio_write_Float_file_channel(FileChannelImpl var0, int var1, int var2, float var3, long var4);

    public static native double nio_read_Double_file_channel(FileChannelImpl var0, int var1, int var2, long var3);

    public static native void nio_write_Double_file_channel(FileChannelImpl var0, int var1, int var2, double var3, long var5);

    @Override
    public final byte get() {
        byte by = MappedByteFileBuffer.nio_read_Byte_file_channel(this.ch, this.position(), this.limit(), this.address);
        this.position(this.position() + 1);
        return by;
    }

    @Override
    public final ByteBuffer put(byte by) {
        MappedByteFileBuffer.nio_write_Byte_file_channel(this.ch, this.position(), this.limit(), by, this.address);
        this.position(this.position() + 1);
        return this;
    }

    @Override
    public final byte get(int n) {
        byte by = MappedByteFileBuffer.nio_read_Byte_file_channel(this.ch, n, this.limit(), this.address);
        return by;
    }

    @Override
    public final ByteBuffer put(int n, byte by) {
        MappedByteFileBuffer.nio_write_Byte_file_channel(this.ch, n, this.limit(), by, this.address);
        return this;
    }

    @Override
    public final ByteBuffer compact() {
        return this;
    }

    @Override
    public final boolean isDirect() {
        return this.direct;
    }

    @Override
    public final ByteBuffer slice() {
        MappedByteFileBuffer mappedByteFileBuffer = new MappedByteFileBuffer(this);
        return mappedByteFileBuffer;
    }

    @Override
    public ByteBuffer duplicate() {
        return new MappedByteFileBuffer(this);
    }

    @Override
    public ByteBuffer asReadOnlyBuffer() {
        MappedByteFileBuffer mappedByteFileBuffer = new MappedByteFileBuffer(this);
        mappedByteFileBuffer.ro = true;
        return mappedByteFileBuffer;
    }

    public final ByteBuffer asByteBuffer() {
        MappedByteFileBuffer mappedByteFileBuffer = new MappedByteFileBuffer(this.ch);
        mappedByteFileBuffer.limit(this.limit() * 1 / 1);
        return mappedByteFileBuffer;
    }

    public final byte getByte() {
        byte by = MappedByteFileBuffer.nio_read_Byte_file_channel(this.ch, this.position(), this.limit(), this.address);
        this.position(this.position() + 1);
        return by;
    }

    public final ByteBuffer putByte(byte by) {
        MappedByteFileBuffer.nio_write_Byte_file_channel(this.ch, this.position(), this.limit(), by, this.address);
        this.position(this.position() + 1);
        return this;
    }

    public final byte getByte(int n) {
        byte by = MappedByteFileBuffer.nio_read_Byte_file_channel(this.ch, n, this.limit(), this.address);
        return by;
    }

    public final ByteBuffer putByte(int n, byte by) {
        MappedByteFileBuffer.nio_write_Byte_file_channel(this.ch, n, this.limit(), by, this.address);
        return this;
    }

    @Override
    public final CharBuffer asCharBuffer() {
        MappedCharFileBuffer mappedCharFileBuffer = new MappedCharFileBuffer(this.ch);
        mappedCharFileBuffer.limit(this.limit() * 1 / 2);
        return mappedCharFileBuffer;
    }

    @Override
    public final char getChar() {
        char c = MappedByteFileBuffer.nio_read_Char_file_channel(this.ch, this.position(), this.limit(), this.address);
        this.position(this.position() + 1);
        return c;
    }

    @Override
    public final ByteBuffer putChar(char c) {
        MappedByteFileBuffer.nio_write_Char_file_channel(this.ch, this.position(), this.limit(), c, this.address);
        this.position(this.position() + 1);
        return this;
    }

    @Override
    public final char getChar(int n) {
        char c = MappedByteFileBuffer.nio_read_Char_file_channel(this.ch, n, this.limit(), this.address);
        return c;
    }

    @Override
    public final ByteBuffer putChar(int n, char c) {
        MappedByteFileBuffer.nio_write_Char_file_channel(this.ch, n, this.limit(), c, this.address);
        return this;
    }

    @Override
    public final ShortBuffer asShortBuffer() {
        MappedShortFileBuffer mappedShortFileBuffer = new MappedShortFileBuffer(this.ch);
        mappedShortFileBuffer.limit(this.limit() * 1 / 2);
        return mappedShortFileBuffer;
    }

    @Override
    public final short getShort() {
        short s = MappedByteFileBuffer.nio_read_Short_file_channel(this.ch, this.position(), this.limit(), this.address);
        this.position(this.position() + 1);
        return s;
    }

    @Override
    public final ByteBuffer putShort(short s) {
        MappedByteFileBuffer.nio_write_Short_file_channel(this.ch, this.position(), this.limit(), s, this.address);
        this.position(this.position() + 1);
        return this;
    }

    @Override
    public final short getShort(int n) {
        short s = MappedByteFileBuffer.nio_read_Short_file_channel(this.ch, n, this.limit(), this.address);
        return s;
    }

    @Override
    public final ByteBuffer putShort(int n, short s) {
        MappedByteFileBuffer.nio_write_Short_file_channel(this.ch, n, this.limit(), s, this.address);
        return this;
    }

    @Override
    public final IntBuffer asIntBuffer() {
        MappedIntFileBuffer mappedIntFileBuffer = new MappedIntFileBuffer(this.ch);
        mappedIntFileBuffer.limit(this.limit() * 1 / 4);
        return mappedIntFileBuffer;
    }

    @Override
    public final int getInt() {
        int n = MappedByteFileBuffer.nio_read_Int_file_channel(this.ch, this.position(), this.limit(), this.address);
        this.position(this.position() + 1);
        return n;
    }

    @Override
    public final ByteBuffer putInt(int n) {
        MappedByteFileBuffer.nio_write_Int_file_channel(this.ch, this.position(), this.limit(), n, this.address);
        this.position(this.position() + 1);
        return this;
    }

    @Override
    public final int getInt(int n) {
        int n2 = MappedByteFileBuffer.nio_read_Int_file_channel(this.ch, n, this.limit(), this.address);
        return n2;
    }

    @Override
    public final ByteBuffer putInt(int n, int n2) {
        MappedByteFileBuffer.nio_write_Int_file_channel(this.ch, n, this.limit(), n2, this.address);
        return this;
    }

    @Override
    public final LongBuffer asLongBuffer() {
        MappedLongFileBuffer mappedLongFileBuffer = new MappedLongFileBuffer(this.ch);
        mappedLongFileBuffer.limit(this.limit() * 1 / 8);
        return mappedLongFileBuffer;
    }

    @Override
    public final long getLong() {
        long l = MappedByteFileBuffer.nio_read_Long_file_channel(this.ch, this.position(), this.limit(), this.address);
        this.position(this.position() + 1);
        return l;
    }

    @Override
    public final ByteBuffer putLong(long l) {
        MappedByteFileBuffer.nio_write_Long_file_channel(this.ch, this.position(), this.limit(), l, this.address);
        this.position(this.position() + 1);
        return this;
    }

    @Override
    public final long getLong(int n) {
        long l = MappedByteFileBuffer.nio_read_Long_file_channel(this.ch, n, this.limit(), this.address);
        return l;
    }

    @Override
    public final ByteBuffer putLong(int n, long l) {
        MappedByteFileBuffer.nio_write_Long_file_channel(this.ch, n, this.limit(), l, this.address);
        return this;
    }

    @Override
    public final FloatBuffer asFloatBuffer() {
        MappedFloatFileBuffer mappedFloatFileBuffer = new MappedFloatFileBuffer(this.ch);
        mappedFloatFileBuffer.limit(this.limit() * 1 / 4);
        return mappedFloatFileBuffer;
    }

    @Override
    public final float getFloat() {
        float f = MappedByteFileBuffer.nio_read_Float_file_channel(this.ch, this.position(), this.limit(), this.address);
        this.position(this.position() + 1);
        return f;
    }

    @Override
    public final ByteBuffer putFloat(float f) {
        MappedByteFileBuffer.nio_write_Float_file_channel(this.ch, this.position(), this.limit(), f, this.address);
        this.position(this.position() + 1);
        return this;
    }

    @Override
    public final float getFloat(int n) {
        float f = MappedByteFileBuffer.nio_read_Float_file_channel(this.ch, n, this.limit(), this.address);
        return f;
    }

    @Override
    public final ByteBuffer putFloat(int n, float f) {
        MappedByteFileBuffer.nio_write_Float_file_channel(this.ch, n, this.limit(), f, this.address);
        return this;
    }

    @Override
    public final DoubleBuffer asDoubleBuffer() {
        MappedDoubleFileBuffer mappedDoubleFileBuffer = new MappedDoubleFileBuffer(this.ch);
        mappedDoubleFileBuffer.limit(this.limit() * 1 / 8);
        return mappedDoubleFileBuffer;
    }

    @Override
    public final double getDouble() {
        double d = MappedByteFileBuffer.nio_read_Double_file_channel(this.ch, this.position(), this.limit(), this.address);
        this.position(this.position() + 1);
        return d;
    }

    @Override
    public final ByteBuffer putDouble(double d) {
        MappedByteFileBuffer.nio_write_Double_file_channel(this.ch, this.position(), this.limit(), d, this.address);
        this.position(this.position() + 1);
        return this;
    }

    @Override
    public final double getDouble(int n) {
        double d = MappedByteFileBuffer.nio_read_Double_file_channel(this.ch, n, this.limit(), this.address);
        return d;
    }

    @Override
    public final ByteBuffer putDouble(int n, double d) {
        MappedByteFileBuffer.nio_write_Double_file_channel(this.ch, n, this.limit(), d, this.address);
        return this;
    }
}

