/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.nio;

import gnu.java.nio.FileChannelImpl;
import gnu.java.nio.MappedByteFileBuffer;
import gnu.java.nio.MappedDoubleFileBuffer;
import gnu.java.nio.MappedFloatFileBuffer;
import gnu.java.nio.MappedIntFileBuffer;
import gnu.java.nio.MappedLongFileBuffer;
import gnu.java.nio.MappedShortFileBuffer;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MappedCharFileBuffer
extends CharBuffer {
    public long address;
    boolean ro;
    boolean direct;
    public FileChannelImpl ch;
    private ByteOrder endian;

    public MappedCharFileBuffer(FileChannelImpl fileChannelImpl) {
        this.Block$();
        this.ch = fileChannelImpl;
        this.address = fileChannelImpl.address;
        try {
            long l = fileChannelImpl.size() / 2L;
            this.limit((int)l);
            return;
        }
        catch (IOException iOException) {
            System.err.println("failed to get size of file-channel's file");
            return;
        }
    }

    public MappedCharFileBuffer(MappedCharFileBuffer mappedCharFileBuffer) {
        this.Block$();
        this.ro = mappedCharFileBuffer.ro;
        this.ch = mappedCharFileBuffer.ch;
        this.address = mappedCharFileBuffer.address;
        this.limit(mappedCharFileBuffer.limit());
    }

    @Override
    public final ByteOrder order() {
        return this.endian;
    }

    @Override
    public boolean isReadOnly() {
        return this.ro;
    }

    @Override
    public final char get() {
        char c = MappedByteFileBuffer.nio_read_Char_file_channel(this.ch, this.position(), this.limit(), this.address);
        this.position(this.position() + 2);
        return c;
    }

    @Override
    public final CharBuffer put(char c) {
        MappedByteFileBuffer.nio_write_Char_file_channel(this.ch, this.position(), this.limit(), c, this.address);
        this.position(this.position() + 2);
        return this;
    }

    @Override
    public final char get(int n) {
        char c = MappedByteFileBuffer.nio_read_Char_file_channel(this.ch, n, this.limit(), this.address);
        return c;
    }

    @Override
    public final CharBuffer put(int n, char c) {
        MappedByteFileBuffer.nio_write_Char_file_channel(this.ch, n, this.limit(), c, this.address);
        return this;
    }

    @Override
    public final CharBuffer compact() {
        return this;
    }

    @Override
    public final boolean isDirect() {
        return this.direct;
    }

    @Override
    public final CharSequence subSequence(int n, int n2) {
        return null;
    }

    @Override
    public final CharBuffer slice() {
        MappedCharFileBuffer mappedCharFileBuffer = new MappedCharFileBuffer(this);
        return mappedCharFileBuffer;
    }

    @Override
    public CharBuffer duplicate() {
        return new MappedCharFileBuffer(this);
    }

    @Override
    public CharBuffer asReadOnlyBuffer() {
        MappedCharFileBuffer mappedCharFileBuffer = new MappedCharFileBuffer(this);
        mappedCharFileBuffer.ro = true;
        return mappedCharFileBuffer;
    }

    public final ByteBuffer asByteBuffer() {
        MappedByteFileBuffer mappedByteFileBuffer = new MappedByteFileBuffer(this.ch);
        mappedByteFileBuffer.limit(this.limit() * 2 / 1);
        return mappedByteFileBuffer;
    }

    public final byte getByte() {
        byte by = MappedByteFileBuffer.nio_read_Byte_file_channel(this.ch, this.position(), this.limit(), this.address);
        this.position(this.position() + 2);
        return by;
    }

    public final CharBuffer putByte(byte by) {
        MappedByteFileBuffer.nio_write_Byte_file_channel(this.ch, this.position(), this.limit(), by, this.address);
        this.position(this.position() + 2);
        return this;
    }

    public final byte getByte(int n) {
        byte by = MappedByteFileBuffer.nio_read_Byte_file_channel(this.ch, n, this.limit(), this.address);
        return by;
    }

    public final CharBuffer putByte(int n, byte by) {
        MappedByteFileBuffer.nio_write_Byte_file_channel(this.ch, n, this.limit(), by, this.address);
        return this;
    }

    public final CharBuffer asCharBuffer() {
        MappedCharFileBuffer mappedCharFileBuffer = new MappedCharFileBuffer(this.ch);
        mappedCharFileBuffer.limit(this.limit() * 2 / 2);
        return mappedCharFileBuffer;
    }

    public final char getChar() {
        char c = MappedByteFileBuffer.nio_read_Char_file_channel(this.ch, this.position(), this.limit(), this.address);
        this.position(this.position() + 2);
        return c;
    }

    public final CharBuffer putChar(char c) {
        MappedByteFileBuffer.nio_write_Char_file_channel(this.ch, this.position(), this.limit(), c, this.address);
        this.position(this.position() + 2);
        return this;
    }

    public final char getChar(int n) {
        char c = MappedByteFileBuffer.nio_read_Char_file_channel(this.ch, n, this.limit(), this.address);
        return c;
    }

    public final CharBuffer putChar(int n, char c) {
        MappedByteFileBuffer.nio_write_Char_file_channel(this.ch, n, this.limit(), c, this.address);
        return this;
    }

    public final ShortBuffer asShortBuffer() {
        MappedShortFileBuffer mappedShortFileBuffer = new MappedShortFileBuffer(this.ch);
        mappedShortFileBuffer.limit(this.limit() * 2 / 2);
        return mappedShortFileBuffer;
    }

    public final short getShort() {
        short s = MappedByteFileBuffer.nio_read_Short_file_channel(this.ch, this.position(), this.limit(), this.address);
        this.position(this.position() + 2);
        return s;
    }

    public final CharBuffer putShort(short s) {
        MappedByteFileBuffer.nio_write_Short_file_channel(this.ch, this.position(), this.limit(), s, this.address);
        this.position(this.position() + 2);
        return this;
    }

    public final short getShort(int n) {
        short s = MappedByteFileBuffer.nio_read_Short_file_channel(this.ch, n, this.limit(), this.address);
        return s;
    }

    public final CharBuffer putShort(int n, short s) {
        MappedByteFileBuffer.nio_write_Short_file_channel(this.ch, n, this.limit(), s, this.address);
        return this;
    }

    public final IntBuffer asIntBuffer() {
        MappedIntFileBuffer mappedIntFileBuffer = new MappedIntFileBuffer(this.ch);
        mappedIntFileBuffer.limit(this.limit() * 2 / 4);
        return mappedIntFileBuffer;
    }

    public final int getInt() {
        int n = MappedByteFileBuffer.nio_read_Int_file_channel(this.ch, this.position(), this.limit(), this.address);
        this.position(this.position() + 2);
        return n;
    }

    public final CharBuffer putInt(int n) {
        MappedByteFileBuffer.nio_write_Int_file_channel(this.ch, this.position(), this.limit(), n, this.address);
        this.position(this.position() + 2);
        return this;
    }

    public final int getInt(int n) {
        int n2 = MappedByteFileBuffer.nio_read_Int_file_channel(this.ch, n, this.limit(), this.address);
        return n2;
    }

    public final CharBuffer putInt(int n, int n2) {
        MappedByteFileBuffer.nio_write_Int_file_channel(this.ch, n, this.limit(), n2, this.address);
        return this;
    }

    public final LongBuffer asLongBuffer() {
        MappedLongFileBuffer mappedLongFileBuffer = new MappedLongFileBuffer(this.ch);
        mappedLongFileBuffer.limit(this.limit() * 2 / 8);
        return mappedLongFileBuffer;
    }

    public final long getLong() {
        long l = MappedByteFileBuffer.nio_read_Long_file_channel(this.ch, this.position(), this.limit(), this.address);
        this.position(this.position() + 2);
        return l;
    }

    public final CharBuffer putLong(long l) {
        MappedByteFileBuffer.nio_write_Long_file_channel(this.ch, this.position(), this.limit(), l, this.address);
        this.position(this.position() + 2);
        return this;
    }

    public final long getLong(int n) {
        long l = MappedByteFileBuffer.nio_read_Long_file_channel(this.ch, n, this.limit(), this.address);
        return l;
    }

    public final CharBuffer putLong(int n, long l) {
        MappedByteFileBuffer.nio_write_Long_file_channel(this.ch, n, this.limit(), l, this.address);
        return this;
    }

    public final FloatBuffer asFloatBuffer() {
        MappedFloatFileBuffer mappedFloatFileBuffer = new MappedFloatFileBuffer(this.ch);
        mappedFloatFileBuffer.limit(this.limit() * 2 / 4);
        return mappedFloatFileBuffer;
    }

    public final float getFloat() {
        float f = MappedByteFileBuffer.nio_read_Float_file_channel(this.ch, this.position(), this.limit(), this.address);
        this.position(this.position() + 2);
        return f;
    }

    public final CharBuffer putFloat(float f) {
        MappedByteFileBuffer.nio_write_Float_file_channel(this.ch, this.position(), this.limit(), f, this.address);
        this.position(this.position() + 2);
        return this;
    }

    public final float getFloat(int n) {
        float f = MappedByteFileBuffer.nio_read_Float_file_channel(this.ch, n, this.limit(), this.address);
        return f;
    }

    public final CharBuffer putFloat(int n, float f) {
        MappedByteFileBuffer.nio_write_Float_file_channel(this.ch, n, this.limit(), f, this.address);
        return this;
    }

    public final DoubleBuffer asDoubleBuffer() {
        MappedDoubleFileBuffer mappedDoubleFileBuffer = new MappedDoubleFileBuffer(this.ch);
        mappedDoubleFileBuffer.limit(this.limit() * 2 / 8);
        return mappedDoubleFileBuffer;
    }

    public final double getDouble() {
        double d = MappedByteFileBuffer.nio_read_Double_file_channel(this.ch, this.position(), this.limit(), this.address);
        this.position(this.position() + 2);
        return d;
    }

    public final CharBuffer putDouble(double d) {
        MappedByteFileBuffer.nio_write_Double_file_channel(this.ch, this.position(), this.limit(), d, this.address);
        this.position(this.position() + 2);
        return this;
    }

    public final double getDouble(int n) {
        double d = MappedByteFileBuffer.nio_read_Double_file_channel(this.ch, n, this.limit(), this.address);
        return d;
    }

    public final CharBuffer putDouble(int n, double d) {
        MappedByteFileBuffer.nio_write_Double_file_channel(this.ch, n, this.limit(), d, this.address);
        return this;
    }

    private /* synthetic */ void Block$() {
        this.endian = ByteOrder.BIG_ENDIAN;
    }
}

