/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.nio;

import gnu.java.nio.ByteBufferImpl;
import java.nio.ByteBuffer;
import java.nio.ShortBuffer;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ShortBufferImpl
extends ShortBuffer {
    private int array_offset;
    private boolean ro;

    public ShortBufferImpl(int n, int n2, int n3) {
        this.backing_buffer = new short[n];
        this.cap = n;
        this.limit(n3);
        this.position(n2);
    }

    public ShortBufferImpl(short[] sArray, int n, int n2) {
        this.backing_buffer = sArray;
        this.cap = sArray.length;
        this.limit(n2);
        this.position(n);
    }

    public ShortBufferImpl(ShortBufferImpl shortBufferImpl) {
        this.backing_buffer = shortBufferImpl.backing_buffer;
        this.ro = shortBufferImpl.ro;
        this.limit(shortBufferImpl.limit());
        this.position(shortBufferImpl.position());
    }

    void inc_pos(int n) {
        this.position(this.position() + n);
    }

    private static native short[] nio_cast(byte[] var0);

    ShortBufferImpl(byte[] byArray) {
        this.backing_buffer = byArray != null ? ShortBufferImpl.nio_cast(byArray) : null;
    }

    private static native byte nio_get_Byte(ShortBufferImpl var0, int var1, int var2);

    private static native void nio_put_Byte(ShortBufferImpl var0, int var1, int var2, byte var3);

    public ByteBuffer asByteBuffer() {
        ByteBufferImpl byteBufferImpl = new ByteBufferImpl(this.backing_buffer);
        byteBufferImpl.limit(this.limit() * 1 / 2);
        return byteBufferImpl;
    }

    @Override
    public boolean isReadOnly() {
        return this.ro;
    }

    @Override
    public ShortBuffer slice() {
        ShortBufferImpl shortBufferImpl = new ShortBufferImpl(this);
        shortBufferImpl.array_offset = this.position();
        return shortBufferImpl;
    }

    @Override
    public ShortBuffer duplicate() {
        return new ShortBufferImpl(this);
    }

    @Override
    public ShortBuffer asReadOnlyBuffer() {
        ShortBufferImpl shortBufferImpl = new ShortBufferImpl(this);
        shortBufferImpl.ro = true;
        return shortBufferImpl;
    }

    @Override
    public ShortBuffer compact() {
        return this;
    }

    @Override
    public boolean isDirect() {
        return this.backing_buffer != null;
    }

    @Override
    public final short get() {
        short s = this.backing_buffer[this.position()];
        this.position(this.position() + 1);
        return s;
    }

    @Override
    public final ShortBuffer put(short s) {
        this.backing_buffer[this.position()] = s;
        this.position(this.position() + 1);
        return this;
    }

    @Override
    public final short get(int n) {
        return this.backing_buffer[n];
    }

    @Override
    public final ShortBuffer put(int n, short s) {
        this.backing_buffer[n] = s;
        return this;
    }
}

