/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.nio;

import gnu.java.nio.ByteBufferImpl;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.AlreadyConnectedException;
import java.nio.channels.SocketChannel;
import java.nio.channels.spi.SelectorProvider;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SocketChannelImpl
extends SocketChannel {
    Socket sock_object;
    int fd;
    int local_port;
    boolean blocking;
    boolean connected;
    InetSocketAddress sa;

    static native int SocketCreate();

    static native int SocketConnect(int var0, InetAddress var1, int var2);

    static native int SocketBind(int var0, InetAddress var1, int var2);

    static native int SocketListen(int var0, int var1);

    static native int SocketAvailable(int var0);

    static native int SocketClose(int var0);

    static native int SocketRead(int var0, byte[] var1, int var2, int var3);

    static native int SocketWrite(int var0, byte[] var1, int var2, int var3);

    public SocketChannelImpl(SelectorProvider selectorProvider) {
        super(selectorProvider);
        this.Block$();
        this.fd = SocketChannelImpl.SocketCreate();
        if (this.fd == -1) {
            System.err.println(new StringBuffer().append("failed to create socket:").append(this.fd).toString());
        }
    }

    public void finalizer() {
        if (this.connected) {
            try {
                this.close();
                return;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    protected void implCloseSelectableChannel() {
        this.connected = false;
        SocketChannelImpl.SocketClose(this.fd);
        this.fd = SocketChannelImpl.SocketCreate();
    }

    @Override
    protected void implConfigureBlocking(boolean bl) {
        if (this.blocking == bl) {
            return;
        }
    }

    @Override
    public boolean connect(SocketAddress socketAddress) throws IOException {
        int n;
        if (this.connected) {
            throw new AlreadyConnectedException();
        }
        this.sa = (InetSocketAddress)socketAddress;
        InetAddress inetAddress = this.sa.getAddress();
        int n2 = SocketChannelImpl.SocketConnect(this.fd, inetAddress, n = this.sa.getPort());
        if (n2 < 0) {
            throw new IOException(new StringBuffer().append("Connection refused:").append(n2).append(", connect=").append(n2).toString());
        }
        this.local_port = n2;
        this.connected = true;
        return this.blocking;
    }

    @Override
    public boolean finishConnect() {
        return false;
    }

    @Override
    public boolean isConnected() {
        return this.connected;
    }

    @Override
    public boolean isConnectionPending() {
        return this.blocking;
    }

    @Override
    public Socket socket() {
        return this.sock_object;
    }

    @Override
    public int read(ByteBuffer byteBuffer) {
        int n = 0;
        int n2 = 1024;
        byte[] byArray = new byte[n2];
        n = SocketChannelImpl.SocketRead(this.fd, byArray, 0, n2);
        byteBuffer.put(byArray, 0, n);
        if (n == 0) {
            return -1;
        }
        return n;
    }

    @Override
    public long read(ByteBuffer[] byteBufferArray, int n, int n2) {
        long l = 0L;
        int n3 = n;
        while (n3 < n2) {
            l += (long)this.read(byteBufferArray[n3]);
            ++n3;
        }
        return l;
    }

    @Override
    public int write(ByteBuffer byteBuffer) {
        int n = 0;
        int n2 = byteBuffer.position();
        if (byteBuffer instanceof ByteBufferImpl) {
            ByteBufferImpl byteBufferImpl = (ByteBufferImpl)byteBuffer;
            byte[] byArray = byteBufferImpl.array();
            n = SocketChannelImpl.SocketWrite(this.fd, byArray, 0, n2);
        } else {
            byte[] byArray = new byte[n2];
            byteBuffer.get(byArray, 0, n2);
            n = SocketChannelImpl.SocketWrite(this.fd, byArray, 0, n2);
        }
        return n;
    }

    @Override
    public long write(ByteBuffer[] byteBufferArray, int n, int n2) {
        long l = 0L;
        int n3 = n;
        while (n3 < n2) {
            l += (long)this.write(byteBufferArray[n3]);
            ++n3;
        }
        return l;
    }

    private /* synthetic */ void Block$() {
        this.blocking = true;
        this.connected = false;
    }
}

