/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.util.prefs;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.prefs.InvalidPreferencesFormatException;
import java.util.prefs.Preferences;
import java.util.prefs.PreferencesFactory;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodeReader {
    private final BufferedReader br;
    private String line;
    private final PreferencesFactory factory;

    public NodeReader(Reader reader, PreferencesFactory preferencesFactory) {
        this.Block$();
        this.br = reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader);
        this.factory = preferencesFactory;
    }

    public NodeReader(InputStream inputStream, PreferencesFactory preferencesFactory) {
        this(new InputStreamReader(inputStream), preferencesFactory);
    }

    public void importPreferences() throws InvalidPreferencesFormatException, IOException {
        this.readPreferences();
    }

    private void readPreferences() throws InvalidPreferencesFormatException, IOException {
        this.skipTill("<preferences");
        this.readRoot();
        this.skipTill("</preferences>");
    }

    private void readRoot() throws InvalidPreferencesFormatException, IOException {
        Preferences preferences;
        this.skipTill("<root");
        this.skipTill("type=\"");
        String string = this.readTill("\"");
        if ("user".equals(string)) {
            preferences = this.factory.userRoot();
        } else if ("system".equals(string)) {
            preferences = this.factory.systemRoot();
        } else {
            throw new InvalidPreferencesFormatException(new StringBuffer().append("Unknown type: ").append(string).toString());
        }
        this.readMap(preferences);
        this.readNodes(preferences);
        this.skipTill("</root>");
    }

    private void readNodes(Preferences preferences) throws InvalidPreferencesFormatException, IOException {
        while ("node".equals(this.nextTag())) {
            this.skipTill("<node");
            this.skipTill("name=\"");
            String string = this.readTill("\"");
            Preferences preferences2 = preferences.node(string);
            System.out.println(new StringBuffer().append("Found subnode: ").append(preferences2.absolutePath()).toString());
            this.readMap(preferences2);
            this.readNodes(preferences2);
            this.skipTill("</node>");
        }
    }

    private void readMap(Preferences preferences) throws InvalidPreferencesFormatException, IOException {
        this.skipTill("<map");
        if (this.line.startsWith("/>")) {
            this.line = this.line.substring(2);
            return;
        }
        this.readEntries(preferences);
        this.skipTill("</map>");
    }

    private void readEntries(Preferences preferences) throws InvalidPreferencesFormatException, IOException {
        while ("entry".equals(this.nextTag())) {
            this.skipTill("<entry");
            this.skipTill("key=\"");
            String string = this.readTill("\"");
            this.skipTill("value=\"");
            String string2 = this.readTill("\"");
            System.out.println(new StringBuffer().append("Key: ").append(string).append(" Value: ").append(string2).toString());
            preferences.put(string, string2);
        }
    }

    private void skipTill(String string) throws InvalidPreferencesFormatException, IOException {
        int n;
        while (true) {
            if (this.line == null) {
                throw new InvalidPreferencesFormatException(new StringBuffer().append(string).append(" not found").toString());
            }
            n = this.line.indexOf(string);
            if (n != -1) break;
            this.line = this.br.readLine();
        }
        this.line = this.line.substring(n + string.length());
    }

    private String readTill(String string) throws InvalidPreferencesFormatException {
        int n = this.line.indexOf(string);
        if (n == -1) {
            throw new InvalidPreferencesFormatException(new StringBuffer().append(string).append(" not found").toString());
        }
        String string2 = this.line.substring(0, n);
        this.line = this.line.substring(n + string.length());
        return string2;
    }

    private String nextTag() throws InvalidPreferencesFormatException, IOException {
        int n;
        while (true) {
            if (this.line == null) {
                throw new InvalidPreferencesFormatException("unexpected EOF");
            }
            n = this.line.indexOf("<");
            if (n != -1) break;
            this.line = this.br.readLine();
        }
        int n2 = n + 1;
        while (n2 != this.line.length() && " \t\r\n".indexOf(this.line.charAt(n2)) == -1) {
            ++n2;
        }
        String string = this.line.substring(n + 1, n2);
        this.line = this.line.substring(n);
        return string;
    }

    private /* synthetic */ void Block$() {
        this.line = "";
    }
}

