/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.util.prefs;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.StringTokenizer;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodeWriter {
    private final Preferences prefs;
    private final BufferedWriter bw;
    private boolean subtree;

    public NodeWriter(Preferences preferences, Writer writer) {
        this.prefs = preferences;
        if (writer instanceof BufferedWriter) {
            this.bw = (BufferedWriter)writer;
            return;
        }
        this.bw = new BufferedWriter(writer);
    }

    public NodeWriter(Preferences preferences, OutputStream outputStream) {
        this(preferences, new OutputStreamWriter(outputStream));
    }

    public void writePrefsTree() throws BackingStoreException, IOException {
        this.subtree = true;
        this.writeHeader();
        this.writePreferences();
        this.bw.flush();
    }

    public void writePrefs() throws BackingStoreException, IOException {
        this.subtree = false;
        this.writeHeader();
        this.writePreferences();
        this.bw.flush();
    }

    private void writeHeader() throws BackingStoreException, IOException {
        this.bw.write("<?xml version=\"1.0\"?>");
        this.bw.newLine();
        this.bw.newLine();
        this.bw.write("<!-- GNU Classpath java.util.prefs Preferences ");
        if (this.prefs.isUserNode()) {
            this.bw.write("user");
        } else {
            this.bw.write("system");
        }
        if (this.prefs.parent() == null) {
            this.bw.write(" root");
        }
        if (this.subtree) {
            this.bw.write(" tree");
        } else {
            this.bw.write(" node");
        }
        if (this.prefs.parent() != null) {
            this.bw.newLine();
            this.bw.write("     '");
            this.bw.write(this.prefs.absolutePath());
            this.bw.write(39);
            this.bw.newLine();
        }
        this.bw.write(" -->");
        this.bw.newLine();
        this.bw.newLine();
    }

    private void writePreferences() throws BackingStoreException, IOException {
        this.bw.write("<preferences>");
        this.bw.newLine();
        this.writeRoot();
        this.bw.write("</preferences>");
        this.bw.newLine();
    }

    private void writeRoot() throws BackingStoreException, IOException {
        this.bw.write("  <root type=\"");
        if (this.prefs.isUserNode()) {
            this.bw.write("user");
        } else {
            this.bw.write("system");
        }
        this.bw.write("\"/>");
        this.writeRootMap();
        this.writeNode();
        this.bw.write("  </root>");
        this.bw.newLine();
    }

    private void writeRootMap() throws BackingStoreException, IOException {
        if (this.prefs.parent() == null && this.prefs.keys().length > 0) {
            this.bw.newLine();
            this.writeMap(this.prefs, 2);
            return;
        }
        this.bw.write("<map/>");
        this.bw.newLine();
    }

    private int writeParents() throws IOException {
        int n;
        String string = this.prefs.absolutePath();
        int n2 = string.lastIndexOf("/");
        if (n2 > 0) {
            string = string.substring(1, n2);
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            n = stringTokenizer.countTokens();
            System.out.println(new StringBuffer().append("path: ").append(string).toString());
            System.out.println(new StringBuffer().append("parents: ").append(n).toString());
            int n3 = 0;
            while (n3 < n) {
                String string2 = stringTokenizer.nextToken();
                this.indent(n3 + 2);
                this.bw.write(new StringBuffer().append("<node name=\"").append(string2).append("\">").toString());
                this.bw.write("<map/>");
                this.bw.write("</node>");
                this.bw.newLine();
                ++n3;
            }
        } else {
            n = 0;
        }
        return n;
    }

    private void writeCloseParents(int n) throws IOException {
        while (n > 0) {
            this.indent(n + 1);
            this.bw.write("</node>");
            this.bw.newLine();
            --n;
        }
    }

    private void writeNode() throws BackingStoreException, IOException {
        int n = this.writeParents();
        int n2 = this.prefs.parent() == null ? n + 1 : n + 2;
        this.writeNode(this.prefs, n2);
        this.writeCloseParents(n);
    }

    private void writeNode(Preferences preferences, int n) throws BackingStoreException, IOException {
        if (preferences.parent() != null) {
            this.indent(n);
            this.bw.write(new StringBuffer().append("<node name=\"").append(preferences.name()).append("\">").toString());
            if (preferences.keys().length > 0) {
                this.bw.newLine();
            }
            this.writeMap(preferences, n + 1);
        }
        if (this.subtree) {
            String[] stringArray = preferences.childrenNames();
            int n2 = 0;
            while (n2 < stringArray.length) {
                Preferences preferences2 = preferences.node(stringArray[n2]);
                this.writeNode(preferences2, n + 1);
                ++n2;
            }
        }
        if (preferences.parent() != null) {
            this.indent(n);
            this.bw.write("</node>");
            this.bw.newLine();
        }
    }

    private void writeMap(Preferences preferences, int n) throws BackingStoreException, IOException {
        StringBuffer stringBuffer = new StringBuffer(2 * n);
        int n2 = 0;
        while (n2 < n) {
            stringBuffer.append("  ");
            ++n2;
        }
        String string = stringBuffer.toString();
        if (preferences.keys().length > 0) {
            this.bw.write(string);
            this.bw.write("<map>");
            this.bw.newLine();
            this.writeEntries(preferences, new StringBuffer().append(string).append("  ").toString());
            this.bw.write(string);
            this.bw.write("</map>");
        } else {
            this.bw.write("<map/>");
        }
        this.bw.newLine();
    }

    private void writeEntries(Preferences preferences, String string) throws BackingStoreException, IOException {
        String[] stringArray = preferences.keys();
        int n = 0;
        while (n < stringArray.length) {
            String string2 = preferences.get(stringArray[n], null);
            if (string2 == null) {
                throw new BackingStoreException(new StringBuffer().append("null value for key '").append(stringArray[n]).append("'").toString());
            }
            this.bw.write(string);
            this.bw.write(new StringBuffer().append("<entry key=\"").append(stringArray[n]).append("\"").append(" value=\"").append(string2).append("\"/>").toString());
            this.bw.newLine();
            ++n;
        }
    }

    private void indent(int n) throws IOException {
        int n2 = 0;
        while (n2 < n) {
            this.bw.write("  ");
            ++n2;
        }
    }
}

