/*
 * Decompiled with CFR 0.152.
 */
package gnu.regexp;

import gnu.regexp.CharIndexed;
import gnu.regexp.REMatch;
import gnu.regexp.REToken;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
final class RETokenRange
extends REToken {
    private char lo;
    private char hi;
    private boolean insens;

    RETokenRange(int n, char c, char c2, boolean bl) {
        super(n);
        this.insens = bl;
        this.lo = this.insens ? Character.toLowerCase(c) : c;
        this.hi = bl ? Character.toLowerCase(c2) : c2;
    }

    @Override
    int getMinimumLength() {
        return 1;
    }

    @Override
    boolean match(CharIndexed charIndexed, REMatch rEMatch) {
        char c = charIndexed.charAt(rEMatch.index);
        if (c == '\uffff') {
            return false;
        }
        if (this.insens) {
            c = Character.toLowerCase(c);
        }
        if (c >= this.lo && c <= this.hi) {
            ++rEMatch.index;
            return this.next(charIndexed, rEMatch);
        }
        return false;
    }

    @Override
    void dump(StringBuffer stringBuffer) {
        stringBuffer.append(this.lo).append('-').append(this.hi);
    }
}

