/*
 * Decompiled with CFR 0.152.
 */
package gnu.xml.dom;

import gnu.xml.dom.DomEx;
import org.w3c.dom.Node;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventListener;
import org.w3c.dom.events.EventTarget;
import org.w3c.dom.events.MutationEvent;
import org.w3c.dom.traversal.NodeFilter;
import org.w3c.dom.traversal.NodeIterator;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DomIterator
implements NodeIterator,
EventListener {
    private Node reference;
    private boolean right;
    private boolean done;
    private final Node root;
    private final int whatToShow;
    private final NodeFilter filter;
    private final boolean expandEntityReferences;

    protected DomIterator(Node node, int n, NodeFilter nodeFilter, boolean bl) {
        if (!node.isSupported("MutationEvents", "2.0")) {
            throw new DomEx(9, "Iterator needs mutation events", node, 0);
        }
        this.root = node;
        this.whatToShow = n;
        this.filter = nodeFilter;
        this.expandEntityReferences = bl;
        this.reference = null;
        this.right = true;
        EventTarget eventTarget = (EventTarget)((Object)node);
        eventTarget.addEventListener("DOMNodeRemoved", this, false);
    }

    @Override
    public void detach() {
        EventTarget eventTarget = (EventTarget)((Object)this.root);
        eventTarget.removeEventListener("DOMNodeRemoved", this, false);
        this.done = true;
    }

    @Override
    public boolean getExpandEntityReferences() {
        return this.expandEntityReferences;
    }

    @Override
    public NodeFilter getFilter() {
        return this.filter;
    }

    @Override
    public Node getRoot() {
        return this.root;
    }

    @Override
    public int getWhatToShow() {
        return this.whatToShow;
    }

    @Override
    public Node nextNode() {
        if (this.done) {
            throw new DomEx(11);
        }
        this.right = true;
        return this.walk(true);
    }

    @Override
    public Node previousNode() {
        if (this.done) {
            throw new DomEx(11);
        }
        Node node = this.reference;
        this.right = false;
        this.walk(false);
        return node;
    }

    private boolean shouldShow(Node node) {
        if ((this.whatToShow & 1 << node.getNodeType() - 1) == 0) {
            return false;
        }
        if (this.filter == null) {
            return true;
        }
        return this.filter.acceptNode(node) == 1;
    }

    private Node walk(boolean bl) {
        Node node = this.reference;
        while ((node = this.successor(node, bl)) != null && !this.shouldShow(node)) {
        }
        if (node != null || !bl) {
            this.reference = node;
        }
        return node;
    }

    private boolean isLeaf(Node node) {
        boolean bl = node.hasChildNodes() ^ true;
        if (!bl && !this.expandEntityReferences) {
            bl = node.getNodeType() == 5;
        }
        return bl;
    }

    private Node successor(Node node, boolean bl) {
        Node node2;
        if (node == null) {
            if (bl) {
                return this.root;
            }
            return null;
        }
        if (bl && !this.isLeaf(node)) {
            return node.getFirstChild();
        }
        if (bl) {
            node2 = node.getNextSibling();
            if (node2 != null) {
                return node2;
            }
        } else {
            node2 = node.getPreviousSibling();
            if (node2 != null) {
                if (this.isLeaf(node2)) {
                    return node2;
                }
                node2 = node2.getLastChild();
                while (!this.isLeaf(node2)) {
                    node2 = node2.getLastChild();
                }
                return node2;
            }
        }
        node2 = node.getParentNode();
        if (!bl) {
            return node2;
        }
        Node node3 = null;
        while (node2 != null && node2 != this.root && (node3 = node2.getNextSibling()) == null) {
            node2 = node2.getParentNode();
        }
        if (node2 == this.root) {
            return null;
        }
        return node3;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void handleEvent(Event var1_1) {
        if (this.reference == null || !"DOMNodeRemoved".equals(var1_1.getType()) || var1_1.getEventPhase() != 3) {
            return;
        }
        var2_2 = (MutationEvent)var1_1;
        var4_3 = (Node)var2_2.getTarget();
        var3_4 = this.reference;
        while (var3_4 != null && var3_4 != this.root) {
            if (var3_4 == var4_3) break;
            var3_4 = var3_4.getParentNode();
        }
        if (var3_4 == var4_3) ** GOTO lbl18
        return;
lbl-1000:
        // 1 sources

        {
            var3_4 = var5_5;
            while (var3_4 != null && var3_4 != this.root) {
                if (var3_4 == var4_3) continue block1;
                var3_4 = var3_4.getParentNode();
            }
            return;
lbl18:
            // 2 sources

            ** while ((var5_5 = this.walk((boolean)(this.right ^ true))) != null)
        }
lbl19:
        // 1 sources

    }
}

