/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.AttributeValue;
import java.awt.ImageCapabilities;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BufferCapabilities
implements Cloneable {
    private final ImageCapabilities front;
    private final ImageCapabilities back;
    private final FlipContents flip;

    public BufferCapabilities(ImageCapabilities imageCapabilities, ImageCapabilities imageCapabilities2, FlipContents flipContents) {
        this.front = imageCapabilities;
        this.back = imageCapabilities2;
        this.flip = flipContents;
        if (imageCapabilities == null || imageCapabilities2 == null) {
            throw new IllegalArgumentException();
        }
    }

    public ImageCapabilities getFrontBufferCapabilities() {
        return this.front;
    }

    public ImageCapabilities getBackBufferCapabilities() {
        return this.back;
    }

    public boolean isPageFlipping() {
        return this.flip != null;
    }

    public FlipContents getFlipContents() {
        return this.flip;
    }

    public boolean isFullScreenRequired() {
        return true;
    }

    public boolean isMultiBufferAvailable() {
        return false;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw (Error)new InternalError().initCause(cloneNotSupportedException);
        }
    }

    /*
     * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class FlipContents
    extends AttributeValue {
        private static final String[] NAMES = new String[]{"undefined", "background", "prior", "copied"};
        public static final FlipContents UNDEFINED = new FlipContents(0);
        public static final FlipContents BACKGROUND = new FlipContents(1);
        public static final FlipContents PRIOR = new FlipContents(2);
        public static final FlipContents COPIED = new FlipContents(3);

        private FlipContents(int n) {
            super(n, NAMES);
        }
    }
}

