/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.AWTEvent;
import java.awt.AWTEventMulticaster;
import java.awt.ActionEvt;
import java.awt.ClassAnalyzer;
import java.awt.ClassProperties;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Defaults;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MenuShortcut;
import java.awt.ShortcutConsumer;
import java.awt.ShortcutHandler;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.MouseEvent;
import kaffe.awt.ImageDict;
import kaffe.awt.ImageSpec;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Button
extends Component
implements ShortcutConsumer {
    private static final long serialVersionUID = -8774683716313001058L;
    String label;
    ActionListener aListener;
    String aCmd;
    FontMetrics fm;
    ImageSpec imgs;
    MenuShortcut shortcut;
    int state;
    static int PUSHED = 1;
    static int HILIGHTED = 2;

    public Button() {
        this("");
    }

    public Button(String string) {
        this.cursor = Cursor.getPredefinedCursor(12);
        this.flags |= 0x10000;
        this.setFont(Defaults.BtnFont);
        this.setBackground(Defaults.BtnClr);
        this.setForeground(Defaults.BtnTxtClr);
        this.setLabel(string);
    }

    public void addActionListener(ActionListener actionListener) {
        this.aListener = AWTEventMulticaster.add(this.aListener, actionListener);
    }

    @Override
    public void addNotify() {
        super.addNotify();
        if (this.shortcut != null) {
            ShortcutHandler.addShortcut(this.shortcut, this.getToplevel(), this);
        }
        MenuShortcut menuShortcut = new MenuShortcut(this, 10, 0);
        MenuShortcut menuShortcut2 = new MenuShortcut(this, 32, 0);
        ShortcutHandler.addShortcut(menuShortcut, this, this);
        ShortcutHandler.addShortcut(menuShortcut2, this, this);
    }

    void animate() {
        Graphics graphics = this.getGraphics();
        this.state |= PUSHED;
        this.paint(graphics);
        Toolkit.tlkSync();
        try {
            Thread.sleep(100L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.state &= ~PUSHED;
        this.paint(graphics);
        Toolkit.tlkSync();
        graphics.dispose();
    }

    @Override
    void checkMouseAware() {
    }

    void drawImage(Graphics graphics) {
        Image image = this.imgs.getImage();
        int n = image.getWidth(this);
        int n2 = image.getHeight(this);
        int n3 = (this.state & PUSHED) > 0 ? 1 : 0;
        int n4 = (this.width - n) / 2 + n3;
        int n5 = (this.height - n2) / 2 + n3;
        graphics.drawImage(image, n4, n5, this);
    }

    void drawText(Graphics graphics) {
        Color color;
        Color color2 = null;
        int n = (this.width - this.fm.stringWidth(this.label)) / 2;
        int n2 = this.height - (this.height - this.fm.getHeight()) / 2 - this.fm.getDescent();
        if (!this.isEnabled()) {
            color2 = null;
            color = this.bgClr.darker();
        } else if ((this.state & PUSHED) > 0) {
            --n;
            --n2;
            color2 = Color.yellow;
            color = Color.red;
        } else if ((this.state & HILIGHTED) > 0) {
            color2 = Defaults.BtnTxtCarved ? this.bgClr.brighter() : null;
            color = Defaults.BtnPointTxtClr;
        } else {
            color2 = Defaults.BtnTxtCarved ? this.bgClr.brighter() : null;
            color = this.fgClr;
        }
        if (color2 != null) {
            graphics.setColor(color2);
            graphics.drawString(this.label, n + 1, n2 + 1);
        }
        graphics.setColor(color);
        graphics.drawString(this.label, n, n2);
    }

    public String getActionCommand() {
        if (this.aCmd != null) {
            return this.aCmd;
        }
        return this.label;
    }

    @Override
    ClassProperties getClassProperties() {
        return ClassAnalyzer.analyzeAll(this.getClass(), true);
    }

    public String getLabel() {
        return this.label;
    }

    @Override
    public void handleShortcut(MenuShortcut menuShortcut) {
        int n;
        int n2 = n = menuShortcut != null ? menuShortcut.mods : 0;
        if ((this.state & PUSHED) == 0) {
            this.animate();
        }
        if (this.aListener != null || ((long)this.eventMask & 0x80L) != 0L || (this.flags & 0x20) != 0) {
            Toolkit.eventQueue.postEvent(ActionEvt.getEvent(this, 1001, this.getActionCommand(), n));
        }
    }

    @Override
    public void paint(Graphics graphics) {
        int n = 2;
        if (this.imgs != null && this.imgs.isPlain()) {
            graphics.setColor(this.parent.getBackground());
            graphics.fillRect(0, 0, this.width, this.height);
            if ((this.state & HILIGHTED) > 0) {
                graphics.setColor(Defaults.BtnPointClr);
                graphics.draw3DRect(0, 0, this.width - 1, this.height - 1, (this.state & PUSHED) == 0);
            }
            this.drawImage(graphics);
            return;
        }
        this.kaffePaintBorder(graphics);
        graphics.setColor((this.state & HILIGHTED) > 0 ? Defaults.BtnPointClr : this.bgClr);
        graphics.fill3DRect(n, n, this.width - 2 * n, this.height - 2 * n, (this.state & PUSHED) == 0);
        if (this.imgs != null) {
            this.drawImage(graphics);
            return;
        }
        if (this.label != null) {
            this.drawText(graphics);
        }
    }

    @Override
    protected String paramString() {
        return new StringBuffer().append(super.paramString()).append(",Label: ").append(this.label).toString();
    }

    @Override
    public Dimension preferredSize() {
        int n = 40;
        int n2 = 20;
        if (this.imgs != null) {
            n = this.imgs.getImage().getWidth(this) + 4;
            n2 = this.imgs.getImage().getHeight(this) + 4;
        } else if (this.fm != null) {
            n = Math.max(n, 4 * this.fm.stringWidth(this.label) / 3);
            n2 = Math.max(n2, 2 * this.fm.getHeight());
        }
        return new Dimension(n, n2);
    }

    @Override
    void process(ActionEvent actionEvent) {
        if (this.aListener != null || ((long)this.eventMask & 0x80L) != 0L) {
            this.processEvent(actionEvent);
        }
        if ((this.flags & 0x20) != 0) {
            this.postEvent(Event.getEvent(actionEvent));
        }
    }

    @Override
    void process(FocusEvent focusEvent) {
        this.repaint();
        super.process(focusEvent);
    }

    @Override
    protected void processActionEvent(ActionEvent actionEvent) {
        if (this.aListener != null) {
            this.aListener.actionPerformed(actionEvent);
        }
    }

    @Override
    void processMouse(MouseEvent mouseEvent) {
        switch (mouseEvent.id) {
            case 504: {
                this.state |= HILIGHTED;
                this.repaint();
                break;
            }
            case 505: {
                this.state &= ~HILIGHTED;
                this.repaint();
                break;
            }
            case 501: {
                this.state |= PUSHED;
                if (AWTEvent.keyTgt != this) {
                    this.requestFocus();
                    break;
                }
                this.repaint();
                break;
            }
            case 502: {
                if (this.contains(mouseEvent.getX(), mouseEvent.getY())) {
                    this.handleShortcut(null);
                }
                this.state &= ~PUSHED;
                this.repaint();
            }
        }
        super.processMouse(mouseEvent);
    }

    public void removeActionListener(ActionListener actionListener) {
        this.aListener = AWTEventMulticaster.remove(this.aListener, actionListener);
    }

    @Override
    public void removeNotify() {
        if (this.shortcut != null) {
            ShortcutHandler.removeFromOwner(this.getToplevel(), this.shortcut);
        }
        ShortcutHandler.removeShortcuts(this);
        super.removeNotify();
    }

    public void setActionCommand(String string) {
        this.aCmd = string;
    }

    @Override
    public void setFont(Font font) {
        this.fm = this.getFontMetrics(font);
        super.setFont(font);
    }

    public void setLabel(String string) {
        int n = string.indexOf(126);
        if (n > -1) {
            this.label = new StringBuffer().append(string.substring(0, n)).append(string.substring(n + 1)).toString();
            this.shortcut = new MenuShortcut(this, Character.toUpperCase(string.charAt(n + 1)), 8);
        } else if (string.startsWith(" ") && string.endsWith(" ")) {
            this.imgs = ImageDict.getDefaultDict().getSpec(string.substring(1, string.length() - 1), null, this);
            this.label = this.imgs != null ? null : string;
        } else {
            this.label = string;
        }
        if (this.isShowing()) {
            this.repaint();
        }
    }
}

