/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.AWTEvent;
import java.awt.AWTEventMulticaster;
import java.awt.Color;
import java.awt.Component;
import java.awt.ContainerEvt;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.LayoutManager2;
import java.awt.NativeGraphics;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.io.PrintStream;
import java.io.PrintWriter;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Container
extends Component {
    private static final long serialVersionUID = 4613797578919906343L;
    Component[] children;
    int nChildren;
    LayoutManager layoutm;
    ContainerListener cntrListener;
    Insets insets;

    protected Container() {
        this.Block$();
    }

    public Component add(Component component) {
        this.add(component, null, -1);
        return component;
    }

    public void add(Component component, Object object) {
        this.add(component, object, -1);
    }

    public void add(Component component, Object object, int n) {
        this.addImpl(component, object, n);
    }

    public Component add(Component component, int n) {
        this.add(component, null, n);
        return component;
    }

    public Component add(String string, Component component) {
        this.add(component, string, -1);
        return component;
    }

    public void addContainerListener(ContainerListener containerListener) {
        this.cntrListener = AWTEventMulticaster.add(this.cntrListener, containerListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addImpl(Component component, Object object, int n) {
        Object object2 = Component.treeLock;
        synchronized (object2) {
            if (n < -1 || n > this.nChildren) {
                throw new IllegalArgumentException(new StringBuffer().append("bad index: ").append(n).toString());
            }
            if (component instanceof Container && this.parent == component) {
                throw new IllegalArgumentException("child is a bad container");
            }
            if (component.parent != null) {
                component.parent.remove(component);
            }
            if (this.children == null) {
                this.children = new Component[3];
            } else if (this.nChildren == this.children.length) {
                Component[] componentArray = this.children;
                this.children = new Component[this.nChildren * 2];
                System.arraycopy(componentArray, 0, this.children, 0, this.nChildren);
            }
            if (n < 0 || this.nChildren == 0 || n == this.nChildren) {
                this.children[this.nChildren] = component;
            } else if (n < this.nChildren) {
                System.arraycopy(this.children, n, this.children, n + 1, this.nChildren - n);
                this.children[n] = component;
            }
            ++this.nChildren;
            component.parent = this;
            if ((this.flags & 2) != 0) {
                this.invalidate();
            }
            if ((this.flags & 0x400) != 0) {
                component.addNotify();
                if ((component.flags & 0x100) != 0) {
                    component.repaint();
                }
            }
            if ((this.flags & 5) == 5) {
                component.flags |= 4;
                component.propagateParentShowing(false);
            }
            if ((component.flags & 0x1000) == 0) {
                component.propagateBgClr(this.bgClr);
            }
            if ((component.flags & 0x800) == 0) {
                component.propagateFgClr(this.fgClr);
            }
            if ((component.flags & 0x2000) == 0) {
                component.propagateFont(this.font);
            }
            if (this.layoutm != null) {
                if (this.layoutm instanceof LayoutManager2) {
                    ((LayoutManager2)this.layoutm).addLayoutComponent(component, object);
                }
                if (object instanceof String) {
                    this.layoutm.addLayoutComponent((String)object, component);
                }
            }
            if (this.cntrListener != null || ((long)this.eventMask & 2L) != 0L) {
                AWTEvent.sendEvent(ContainerEvt.getEvent(this, 300, component), false);
            }
            return;
        }
    }

    @Override
    public void addNotify() {
        super.addNotify();
        int n = 0;
        while (n < this.nChildren) {
            this.children[n].addNotify();
            ++n;
        }
    }

    Graphics clipSiblings(Component component, NativeGraphics nativeGraphics) {
        int n = nativeGraphics.xClip + nativeGraphics.xOffset;
        int n2 = nativeGraphics.yClip + nativeGraphics.yOffset;
        int n3 = n + nativeGraphics.wClip;
        int n4 = n2 + nativeGraphics.hClip;
        int n5 = this.nChildren - 1;
        while (n5 >= 0 && this.children[n5] != component) {
            --n5;
        }
        --n5;
        while (n5 >= 0) {
            Component component2 = this.children[n5];
            int n6 = component2.x + component2.width;
            int n7 = component2.y + component2.height;
            --n5;
        }
        return nativeGraphics;
    }

    public int countComponents() {
        return this.nChildren;
    }

    @Override
    public void doLayout() {
        this.layout();
    }

    @Override
    void dump(String string) {
        String string2 = new StringBuffer().append(string).append("  ").toString();
        super.dump(string);
        int n = 0;
        while (n < this.nChildren) {
            this.children[n].dump(new StringBuffer().append(string2).append(n).append(" ").toString());
            ++n;
        }
    }

    void emitRepaints(int n, int n2, int n3, int n4) {
        int n5 = n + n3;
        int n6 = n2 + n4;
        int n7 = 0;
        while (n7 < this.nChildren) {
            Component component = this.children[n7];
            if ((component.flags & 1) != 0) {
                int n8;
                int n9 = component.x + component.width;
                int n10 = component.y + component.height;
                int n11 = n < component.x ? 0 : n - component.x;
                int n12 = n2 < component.y ? 0 : n2 - component.y;
                int n13 = n5 < n9 ? n5 - component.x - n11 : component.width;
                int n14 = n8 = n6 < n10 ? n6 - component.y - n12 : component.height;
                if ((component.flags & 0x8000) != 0) {
                    Toolkit.eventQueue.postPaintEvent((component.flags & 0x4000) != 0 ? 800 : 801, component, n11, n12, n13, n8);
                }
                if (component instanceof Container) {
                    ((Container)component).emitRepaints(n11, n12, n13, n8);
                }
            }
            ++n7;
        }
    }

    @Override
    public float getAlignmentX() {
        if (this.layoutm instanceof LayoutManager2) {
            return ((LayoutManager2)this.layoutm).getLayoutAlignmentX(this);
        }
        return super.getAlignmentX();
    }

    @Override
    public float getAlignmentY() {
        if (this.layoutm instanceof LayoutManager2) {
            return ((LayoutManager2)this.layoutm).getLayoutAlignmentY(this);
        }
        return super.getAlignmentY();
    }

    public Component getComponent(int n) {
        return this.children[n];
    }

    @Override
    public Component getComponentAt(Point point) {
        return this.getComponentAt(point.x, point.y);
    }

    @Override
    public Component getComponentAt(int n, int n2) {
        return this.locate(n, n2);
    }

    public int getComponentCount() {
        return this.countComponents();
    }

    public Component[] getComponents() {
        Component[] componentArray = new Component[this.nChildren];
        if (this.nChildren > 0) {
            System.arraycopy(this.children, 0, componentArray, 0, this.nChildren);
        }
        return componentArray;
    }

    public Insets getInsets() {
        return this.insets();
    }

    public LayoutManager getLayout() {
        return this.layoutm;
    }

    @Override
    public Dimension getMaximumSize() {
        if (this.layoutm instanceof LayoutManager2) {
            return ((LayoutManager2)this.layoutm).maximumLayoutSize(this);
        }
        return super.getMaximumSize();
    }

    @Override
    public Dimension getMinimumSize() {
        return this.minimumSize();
    }

    @Override
    public Dimension getPreferredSize() {
        return this.preferredSize();
    }

    boolean hasDirties() {
        int n = 0;
        while (n < this.nChildren) {
            Component component = this.children[n];
            if ((component.flags & 0x8000) != 0) {
                return true;
            }
            if (component instanceof Container && ((Container)component).hasDirties()) {
                return true;
            }
            ++n;
        }
        return false;
    }

    @Override
    public void hide() {
        if ((this.flags & 4) != 0) {
            int n = 0;
            while (n < this.nChildren) {
                Component component = this.children[n];
                component.flags &= 0xFFFFFFFB;
                if ((component.flags & 1) != 0) {
                    component.propagateParentShowing(false);
                }
                ++n;
            }
        }
        super.hide();
    }

    public Insets insets() {
        return new Insets(this.insets.top, this.insets.left, this.insets.bottom, this.insets.right);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void invalidate() {
        Object object = Component.treeLock;
        synchronized (object) {
            if ((this.flags & 2) != 0) {
                if (this.layoutm instanceof LayoutManager2) {
                    ((LayoutManager2)this.layoutm).invalidateLayout(this);
                }
                this.flags &= 0xFFFFFFFD;
                if (this.parent != null && (this.parent.flags & 2) != 0) {
                    this.parent.invalidate();
                }
            }
            return;
        }
    }

    public boolean isAncestorOf(Component component) {
        component = component.parent;
        while (component != null) {
            if (component == this) {
                return true;
            }
            component = component.parent;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void layout() {
        Object object = Component.treeLock;
        synchronized (object) {
            if (this.layoutm != null && (this.flags & 8) == 0) {
                this.flags |= 8;
                this.layoutm.layoutContainer(this);
                this.flags &= 0xFFFFFFF7;
            }
            return;
        }
    }

    @Override
    public void list(PrintStream printStream, int n) {
        this.list(new PrintWriter(printStream), n);
    }

    @Override
    public void list(PrintWriter printWriter, int n) {
        super.list(printWriter, n);
        Component[] componentArray = this.getComponents();
        int n2 = componentArray.length - 1;
        while (n2 > 0) {
            componentArray[n2].list(printWriter, n + 2);
            --n2;
        }
        printWriter.flush();
    }

    @Override
    public Component locate(int n, int n2) {
        if (!this.isShowing() || n < 0 || n > this.x + this.width || n2 < 0 || n2 > this.y + this.height) {
            return null;
        }
        int n3 = 0;
        while (n3 < this.nChildren) {
            Component component = this.children[n3];
            if (component.contains(n - component.x, n2 - component.y)) {
                if (component.isShowing()) {
                    return component;
                }
                return this;
            }
            ++n3;
        }
        return this;
    }

    void markRepaints(int n, int n2, int n3, int n4) {
        int n5 = n + n3;
        int n6 = n2 + n4;
        int n7 = 0;
        while (n7 < this.nChildren) {
            Component component = this.children[n7];
            if ((component.flags & 1) != 0) {
                int n8 = component.x + component.width;
                int n9 = component.y + component.height;
                if (n < n8 && n2 < n9 && component.x < n5 && component.y < n6) {
                    if ((component.flags & 0x100) != 0) {
                        component.flags |= 0x8000;
                    }
                    if (component instanceof Container) {
                        int n10 = n < component.x ? 0 : n - component.x;
                        int n11 = n2 < component.y ? 0 : n2 - component.y;
                        int n12 = n5 < n8 ? n5 - component.x - n10 : component.width;
                        int n13 = n6 < n9 ? n6 - component.y - n11 : component.height;
                        ((Container)component).markRepaints(n10, n11, n12, n13);
                    }
                }
            }
            ++n7;
        }
    }

    @Override
    public Dimension minimumSize() {
        if (this.layoutm != null) {
            return this.layoutm.minimumLayoutSize(this);
        }
        return super.minimumSize();
    }

    @Override
    public void paint(Graphics graphics) {
        this.validateTree();
        int n = this.nChildren - 1;
        while (n >= 0) {
            Component component = this.children[n];
            if ((component.flags & 1) != 0) {
                graphics.paintChild(component, (this.flags & 0x10) != 0);
            }
            --n;
        }
    }

    public void paintComponents(Graphics graphics) {
        Component[] componentArray = this.getComponents();
        int n = componentArray.length;
        while (n > 0) {
            componentArray[n].paintAll(graphics);
            --n;
        }
    }

    @Override
    protected String paramString() {
        return new StringBuffer().append(super.paramString()).append(",layout=").append(this.getLayout().getClass().getName()).toString();
    }

    @Override
    public Dimension preferredSize() {
        if (this.layoutm != null) {
            return this.layoutm.preferredLayoutSize(this);
        }
        return super.preferredSize();
    }

    public void printComponents(Graphics graphics) {
    }

    @Override
    void process(ContainerEvent containerEvent) {
        if (this.cntrListener != null || ((long)this.eventMask & 2L) != 0L) {
            this.processEvent(containerEvent);
        }
    }

    @Override
    public void processContainerEvent(ContainerEvent containerEvent) {
        if (this.cntrListener != null) {
            switch (containerEvent.getID()) {
                case 300: {
                    this.cntrListener.componentAdded(containerEvent);
                    return;
                }
                case 301: {
                    this.cntrListener.componentRemoved(containerEvent);
                }
            }
        }
    }

    @Override
    void processPaintEvent(int n, int n2, int n3, int n4, int n5) {
        NativeGraphics nativeGraphics = NativeGraphics.getClippedGraphics(null, this, 0, 0, n2, n3, n4, n5, false);
        if (nativeGraphics != null) {
            this.markRepaints(n2, n3, n4, n5);
            if (n == 801) {
                this.update(nativeGraphics);
            } else {
                this.paint(nativeGraphics);
            }
            nativeGraphics.dispose();
            if (this.hasDirties()) {
                this.emitRepaints(n2, n3, n4, n5);
            }
        }
    }

    @Override
    void propagateBgClr(Color color) {
        this.bgClr = color;
        int n = 0;
        while (n < this.nChildren) {
            Component component = this.children[n];
            if ((component.flags & 0x1000) == 0) {
                component.propagateBgClr(color);
            }
            ++n;
        }
    }

    @Override
    void propagateFgClr(Color color) {
        this.fgClr = color;
        int n = 0;
        while (n < this.nChildren) {
            Component component = this.children[n];
            if ((component.flags & 0x800) == 0) {
                component.propagateFgClr(color);
            }
            ++n;
        }
    }

    @Override
    void propagateFont(Font font) {
        this.font = font;
        int n = 0;
        while (n < this.nChildren) {
            Component component = this.children[n];
            if ((component.flags & 0x2000) == 0) {
                component.propagateFont(font);
            }
            ++n;
        }
    }

    @Override
    void propagateParentShowing(boolean bl) {
        if ((this.flags & 1) == 0) {
            return;
        }
        if ((this.flags & 4) != 0) {
            int n = 0;
            while (n < this.nChildren) {
                this.children[n].flags |= 4;
                this.children[n].propagateParentShowing(bl);
                ++n;
            }
        } else {
            int n = 0;
            while (n < this.nChildren) {
                this.children[n].flags &= 0xFFFFFFFB;
                this.children[n].propagateParentShowing(bl);
                ++n;
            }
        }
        if (!bl && this.linkedGraphs != null) {
            this.updateLinkedGraphics();
        }
    }

    @Override
    void propagateReshape() {
        int n = 0;
        while (n < this.nChildren) {
            this.children[n].propagateReshape();
            ++n;
        }
        if (this.linkedGraphs != null) {
            this.updateLinkedGraphics();
        }
    }

    @Override
    void propagateTempEnabled(boolean bl) {
        super.propagateTempEnabled(bl);
        int n = 0;
        while (n < this.nChildren) {
            this.children[n].propagateTempEnabled(bl);
            ++n;
        }
    }

    public void remove(Component component) {
        int n = this.nChildren - 1;
        while (n >= 0) {
            if (this.children[n] == component) {
                this.remove(n);
                return;
            }
            --n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(int n) {
        Object object = Component.treeLock;
        synchronized (object) {
            int n2 = this.nChildren - 1;
            if (n < 0 && n > n2) {
                return;
            }
            Component component = this.children[n];
            if ((component.flags & 0x400) != 0) {
                component.removeNotify();
            }
            if (this.layoutm != null) {
                this.layoutm.removeLayoutComponent(component);
            }
            component.parent = null;
            if (n > -1 && n < n2) {
                System.arraycopy(this.children, n + 1, this.children, n, n2 - n);
            }
            this.children[n2] = null;
            this.nChildren += -1;
            if (this.cntrListener != null || ((long)this.eventMask & 2L) != 0L) {
                AWTEvent.sendEvent(ContainerEvt.getEvent(this, 301, component), false);
            }
            if ((this.flags & 2) != 0) {
                this.invalidate();
            }
            component.flags &= 0xFFFFFFFB;
            component.propagateParentShowing(false);
            if ((component.flags & 0x100) != 0) {
                this.repaint(component.x, component.y, component.width, component.height);
            }
            return;
        }
    }

    public void removeAll() {
        if (this.nChildren > 3) {
            int n = this.flags;
            this.flags &= 0xFFFFFFFE;
            int n2 = this.nChildren - 1;
            while (n2 >= 0) {
                this.remove(n2);
                --n2;
            }
            this.flags = n;
            this.repaint();
            return;
        }
        int n = this.nChildren - 1;
        while (n >= 0) {
            this.remove(n);
            --n;
        }
    }

    public void removeContainerListener(ContainerListener containerListener) {
        this.cntrListener = AWTEventMulticaster.remove(this.cntrListener, containerListener);
    }

    @Override
    public void removeNotify() {
        int n = 0;
        while (n < this.nChildren) {
            if ((this.children[n].flags & 0x400) != 0) {
                this.children[n].removeNotify();
            }
            ++n;
        }
        super.removeNotify();
    }

    public void setLayout(LayoutManager layoutManager) {
        this.layoutm = layoutManager;
        if ((this.flags & 2) != 0) {
            this.invalidate();
        }
    }

    @Override
    public void show() {
        if ((this.flags & 4) != 0) {
            int n = 0;
            while (n < this.nChildren) {
                Component component = this.children[n];
                component.flags |= 4;
                if ((component.flags & 1) != 0) {
                    component.propagateParentShowing(false);
                }
                ++n;
            }
        }
        super.show();
    }

    @Override
    public void update(Graphics graphics) {
        this.flags |= 0x10;
        graphics.clearRect(0, 0, this.width, this.height);
        this.paint(graphics);
        this.flags &= 0xFFFFFFEF;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void validate() {
        Object object = Component.treeLock;
        synchronized (object) {
            if ((this.flags & 0x402) == 1024) {
                this.validateTree();
                this.flags |= 2;
            }
            return;
        }
    }

    protected void validateTree() {
        this.doLayout();
        int n = 0;
        while (n < this.nChildren) {
            this.children[n].validate();
            ++n;
        }
    }

    private /* synthetic */ void Block$() {
        this.insets = Insets.noInsets;
    }
}

