/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.Component;
import java.awt.NativeGraphics;
import java.awt.Toolkit;
import java.lang.ref.WeakReference;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
class GraphicsLink
extends WeakReference {
    GraphicsLink next;
    int xOffset;
    int yOffset;
    boolean isVisible;
    int width;
    int height;

    GraphicsLink(NativeGraphics nativeGraphics) {
        super(nativeGraphics);
    }

    boolean updateGraphics(Component component) {
        NativeGraphics nativeGraphics = (NativeGraphics)this.get();
        if (nativeGraphics != null) {
            boolean bl;
            boolean bl2 = bl = (component.flags & Component.IS_SHOWING) == Component.IS_SHOWING;
            if (bl != this.isVisible) {
                Toolkit.graSetVisible(nativeGraphics.nativeData, bl);
                this.isVisible = bl;
            }
            if (bl) {
                if (nativeGraphics.xClip == 0 && nativeGraphics.yClip == 0 && nativeGraphics.wClip == this.width && nativeGraphics.hClip == this.height) {
                    NativeGraphics.getClippedGraphics(nativeGraphics, component, nativeGraphics.xOffset - this.xOffset, nativeGraphics.yOffset - this.yOffset, 0, 0, component.width, component.height, false);
                    this.width = nativeGraphics.wClip;
                    this.height = nativeGraphics.hClip;
                } else {
                    NativeGraphics.getClippedGraphics(nativeGraphics, component, nativeGraphics.xOffset - this.xOffset, nativeGraphics.yOffset - this.yOffset, nativeGraphics.xClip, nativeGraphics.yClip, nativeGraphics.wClip, nativeGraphics.hClip, false);
                }
            }
            this.xOffset = nativeGraphics.xOffset;
            this.yOffset = nativeGraphics.yOffset;
            return true;
        }
        return false;
    }
}

