/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.Serializable;
import java.util.Hashtable;
import kaffe.util.NotImplemented;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GridBagLayout
implements LayoutManager2,
Serializable {
    protected static final int MINSIZE = 1;
    protected static final int PREFERREDSIZE = 2;
    protected static final int ACTUALSIZE = 3;
    protected static final int MAXGRIDSIZE = 100;
    private static final long serialVersionUID = 8838754796412211005L;
    protected Hashtable comptable;
    protected GridBagConstraints defaultConstraints;
    public int[] columnWidths;
    public int[] rowHeights;
    public double[] columnWeights;
    public double[] rowWeights;
    transient Point offset;
    private static Component[][] defGrid = new Component[100][100];

    protected void AdjustForGravity(GridBagConstraints gridBagConstraints, Rectangle rectangle) {
        throw new NotImplemented(new StringBuffer().append(Class.forName("java.awt.GridBagLayout").getName()).append(".AdjustForGravity()").toString());
    }

    protected void ArrangeGrid(Container container) {
        this.layoutContainer(container);
    }

    public GridBagLayout() {
        this.Block$();
    }

    @Override
    public void addLayoutComponent(Component component, Object object) {
        try {
            if (object != null) {
                this.setConstraints(component, (GridBagConstraints)object);
                return;
            }
        }
        catch (ClassCastException classCastException) {
            throw new IllegalArgumentException("not GridBagConstraints");
        }
    }

    @Override
    public void addLayoutComponent(String string, Component component) {
    }

    void adjustWeightsRelative(Container container) {
        int n;
        double d;
        int n2;
        double d2;
        Insets insets = container.getInsets();
        int n3 = 0;
        int n4 = 0;
        int n5 = this.sumWidths();
        int n6 = this.sumHeights();
        double d3 = 0.0;
        double d4 = 0.0;
        int n7 = 0;
        while (n7 < this.columnWeights.length) {
            d2 = this.columnWeights[n7];
            if (d2 > 0.0) {
                d3 += d2;
                ++n3;
            }
            ++n7;
        }
        n7 = 0;
        while (n7 < this.rowWeights.length) {
            d2 = this.rowWeights[n7];
            if (d2 > 0.0) {
                d4 += d2;
                ++n4;
            }
            ++n7;
        }
        int n8 = insets.left + insets.right;
        int n9 = insets.top + insets.bottom;
        if (n3 > 0) {
            n2 = container.width - n5 - n8;
            n7 = 0;
            while (n7 < this.columnWeights.length - 1) {
                d = this.columnWeights[n7];
                if (d > 0.0) {
                    n = (int)(d / d3 * (double)n2);
                    int n10 = n7;
                    this.columnWidths[n10] = this.columnWidths[n10] + n;
                    d3 -= d;
                    n2 -= n;
                }
                if (d3 == 0.0) break;
                ++n7;
            }
            if (n2 > 0) {
                int n11 = n7;
                this.columnWidths[n11] = this.columnWidths[n11] + n2;
            }
            this.offset.x = 0;
        } else {
            this.offset.x = (container.width - n5 - n8) / 2;
        }
        if (n4 > 0) {
            n2 = container.height - n6 - n9;
            n7 = 0;
            while (n7 < this.rowWeights.length - 1) {
                d = this.rowWeights[n7];
                if (d > 0.0) {
                    n = (int)(d / d4 * (double)n2);
                    int n12 = n7;
                    this.rowHeights[n12] = this.rowHeights[n12] + n;
                    d4 -= d;
                    n2 -= n;
                }
                if (d4 == 0.0) break;
                ++n7;
            }
            if (n2 > 0) {
                int n13 = n7;
                this.rowHeights[n13] = this.rowHeights[n13] + n2;
            }
            this.offset.y = 0;
            return;
        }
        this.offset.y = (container.height - n6 - n9) / 2;
    }

    void clearDefGrid() {
        int n = 0;
        while (n < 100) {
            int n2 = 0;
            while (n2 < 100) {
                GridBagLayout.defGrid[n2][n] = null;
                ++n2;
            }
            ++n;
        }
    }

    Component componentAt(Container container, int n, int n2) {
        int n3 = container.getComponentCount();
        int n4 = 0;
        while (n4 < n3) {
            Component component = container.getComponent(n4);
            GridBagConstraints gridBagConstraints = this.lookupConstraints(component);
            if (gridBagConstraints.gridx <= n && gridBagConstraints.gridy <= n2 && gridBagConstraints.gridx + gridBagConstraints.gridwidth > n && gridBagConstraints.gridy + gridBagConstraints.gridheight > n2) {
                return component;
            }
            ++n4;
        }
        return null;
    }

    void dump() {
        if (this.columnWidths == null || this.rowHeights == null) {
            return;
        }
        System.out.print("\t\t");
        int n = 0;
        while (n < this.columnWidths.length) {
            System.out.print(new StringBuffer().append(this.columnWidths[n]).append("[").append(this.columnWeights[n]).append("]").toString());
            System.out.print('\t');
            ++n;
        }
        System.out.println();
        n = 0;
        while (n < this.rowHeights.length) {
            System.out.print(new StringBuffer().append(this.rowHeights[n]).append("[").append(this.rowWeights[n]).append("]").toString());
            int n2 = 0;
            while (n2 < this.columnWidths.length) {
                Component component = defGrid[n2][n];
                System.out.print('\t');
                System.out.print(component != null ? Integer.toHexString(component.hashCode()) : "-------");
                System.out.print('\t');
                ++n2;
            }
            System.out.println();
            ++n;
        }
        System.out.println();
    }

    void fillGrid(Container container, int n, int n2, int n3) {
        GridBagConstraints gridBagConstraints;
        boolean bl;
        int n4;
        int n5 = 0;
        int n6 = 0;
        Dimension dimension = new Dimension();
        int n7 = 99;
        while (n7 > -1) {
            if (defGrid[99][n7] != null) {
                n5 = Math.max(n5, n);
            } else {
                n4 = 99;
                while (n4 > -1) {
                    if (defGrid[n4][n7] != null) {
                        n5 = Math.max(n5, n4 + 1);
                        break;
                    }
                    --n4;
                }
            }
            --n7;
        }
        n4 = 99;
        while (n4 > -1) {
            if (defGrid[n4][99] != null) {
                n6 = Math.max(n6, n2);
            } else {
                n7 = 99;
                while (n7 > -1) {
                    if (defGrid[n4][n7] != null) {
                        n6 = Math.max(n6, n7 + 1);
                        break;
                    }
                    --n7;
                }
            }
            --n4;
        }
        boolean bl2 = bl = this.columnWidths == null || this.rowHeights == null || this.columnWidths.length != n5 || this.rowHeights.length != n6;
        if (bl) {
            this.columnWidths = new int[n5];
            this.columnWeights = new double[n5];
            this.rowHeights = new int[n6];
            this.rowWeights = new double[n6];
        } else {
            n4 = 0;
            while (n4 < n5) {
                this.columnWidths[n4] = 0;
                this.columnWeights[n4] = 0.0;
                ++n4;
            }
            n7 = 0;
            while (n7 < n6) {
                this.rowHeights[n7] = 0;
                this.rowWeights[n7] = 0.0;
                ++n7;
            }
        }
        this.updateConstraints(container);
        Rectangle rectangle = new Rectangle();
        int n8 = container.getComponentCount();
        int n9 = 0;
        while (n9 < n8) {
            Component component = container.getComponent(n9);
            gridBagConstraints = this.lookupConstraints(component);
            rectangle.setBounds(gridBagConstraints.gridx, gridBagConstraints.gridy, gridBagConstraints.gridwidth, gridBagConstraints.gridheight);
            if (rectangle.width == 1 || rectangle.height == 1) {
                this.getComponentExt(component, gridBagConstraints, n3, dimension);
                if (rectangle.width == 1) {
                    this.columnWidths[rectangle.x] = Math.max(this.columnWidths[rectangle.x], dimension.width);
                }
                if (rectangle.height == 1) {
                    this.rowHeights[rectangle.y] = Math.max(this.rowHeights[rectangle.y], dimension.height);
                }
            }
            int n10 = rectangle.x + rectangle.width - 1;
            this.columnWeights[n10] = Math.max(this.columnWeights[n10], gridBagConstraints.weightx);
            n10 = rectangle.y + rectangle.height - 1;
            this.rowWeights[n10] = Math.max(this.rowWeights[n10], gridBagConstraints.weighty);
            ++n9;
        }
        n4 = 0;
        while (n4 < n5) {
            if (this.columnWidths[n4] == 0) {
                n7 = 0;
                while (n7 < n6) {
                    Component component = this.componentAt(container, n4, n7);
                    if (component != null) {
                        gridBagConstraints = this.lookupConstraints(component);
                        this.getComponentExt(component, gridBagConstraints, n3, dimension);
                        rectangle.setBounds(gridBagConstraints.gridx, gridBagConstraints.gridy, gridBagConstraints.gridwidth, gridBagConstraints.gridheight);
                        this.columnWidths[n4] = Math.max(this.columnWidths[n4], dimension.width / rectangle.width);
                    }
                    ++n7;
                }
            }
            ++n4;
        }
        n7 = 0;
        while (n7 < n6) {
            if (this.rowHeights[n7] == 0) {
                n4 = 0;
                while (n4 < n5) {
                    Component component = this.componentAt(container, n4, n7);
                    if (component != null) {
                        gridBagConstraints = this.lookupConstraints(component);
                        this.getComponentExt(component, gridBagConstraints, n3, dimension);
                        rectangle.setBounds(gridBagConstraints.gridx, gridBagConstraints.gridy, gridBagConstraints.gridwidth, gridBagConstraints.gridheight);
                        this.rowHeights[n7] = Math.max(this.rowHeights[n7], dimension.height / rectangle.height);
                    }
                    ++n4;
                }
            }
            ++n7;
        }
        if (n3 == 3) {
            this.adjustWeightsRelative(container);
        }
    }

    Dimension getComponentExt(Component component, GridBagConstraints gridBagConstraints, int n, Dimension dimension) {
        dimension.setSize(n == 1 ? component.getMinimumSize() : component.getPreferredSize());
        dimension.width += gridBagConstraints.insets.left + gridBagConstraints.insets.right + 2 * gridBagConstraints.ipadx;
        dimension.height += gridBagConstraints.insets.top + gridBagConstraints.insets.bottom + 2 * gridBagConstraints.ipady;
        return dimension;
    }

    public GridBagConstraints getConstraints(Component component) {
        return (GridBagConstraints)this.lookupConstraints(component).clone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void getGrid(Container container, int n) {
        int n2 = 0;
        int n3 = 0;
        int n4 = -1;
        int n5 = -1;
        GridBagConstraints gridBagConstraints = null;
        int n6 = container.getComponentCount();
        Component[][] componentArray = defGrid;
        synchronized (defGrid) {
            this.clearDefGrid();
            int n7 = 0;
            while (n7 < n6) {
                Component component = container.getComponent(n7);
                GridBagConstraints gridBagConstraints2 = this.lookupConstraints(component);
                n2 = gridBagConstraints2.gridx == GridBagConstraints.RELATIVE ? (gridBagConstraints == null ? 0 : (gridBagConstraints.gridwidth > 0 ? (n2 += gridBagConstraints.gridwidth) : -1)) : gridBagConstraints2.gridx;
                n3 = gridBagConstraints2.gridy == GridBagConstraints.RELATIVE ? (gridBagConstraints == null ? 0 : (gridBagConstraints.gridheight == GridBagConstraints.REMAINDER ? -1 : (gridBagConstraints.gridwidth == GridBagConstraints.REMAINDER ? (n3 += Math.max(gridBagConstraints.gridheight, 1)) : -1))) : gridBagConstraints2.gridy;
                if (n2 == -1) {
                    n2 = 0;
                    while (defGrid[n2][n3] != null) {
                        ++n2;
                    }
                }
                if (n3 == -1) {
                    n3 = 0;
                    while (defGrid[n2][n3] != null) {
                        ++n3;
                    }
                }
                int n8 = gridBagConstraints2.gridwidth;
                int n9 = gridBagConstraints2.gridheight;
                if (n8 == GridBagConstraints.REMAINDER) {
                    n4 = Math.max(n4, n2);
                    n8 = 100 - n2;
                } else if (n8 == GridBagConstraints.RELATIVE) {
                    n8 = 1;
                }
                if (n9 == GridBagConstraints.REMAINDER) {
                    n5 = Math.max(n5, n3);
                    n9 = 100 - n3;
                } else if (n9 == GridBagConstraints.RELATIVE) {
                    n9 = 1;
                }
                --n9;
                while (n9 > -1) {
                    int n10 = n8 - 1;
                    while (n10 > -1) {
                        GridBagLayout.defGrid[n2 + n10][n3 + n9] = component;
                        --n10;
                    }
                    --n9;
                }
                gridBagConstraints = gridBagConstraints2;
                ++n7;
            }
            this.fillGrid(container, n4 + 1, n5 + 1, n);
            // ** MonitorExit[var3_9] (shouldn't be in output)
            return;
        }
    }

    @Override
    public float getLayoutAlignmentX(Container container) {
        return 0.5f;
    }

    @Override
    public float getLayoutAlignmentY(Container container) {
        return 0.5f;
    }

    public int[][] getLayoutDimensions() {
        return new int[][]{this.columnWidths, this.rowHeights};
    }

    public Point getLayoutOrigin() {
        return this.offset;
    }

    public double[][] getLayoutWeights() {
        return new double[][]{this.columnWeights, this.rowWeights};
    }

    Rectangle gridToPels(Rectangle rectangle) {
        int n = 0;
        int n2 = 0;
        while (n2 < rectangle.x) {
            n += this.columnWidths[n2];
            ++n2;
        }
        int n3 = 0;
        while (n2 < rectangle.x + rectangle.width) {
            n3 += this.columnWidths[n2];
            ++n2;
        }
        int n4 = 0;
        int n5 = 0;
        while (n5 < rectangle.y) {
            n4 += this.rowHeights[n5];
            ++n5;
        }
        int n6 = 0;
        while (n5 < rectangle.y + rectangle.height) {
            n6 += this.rowHeights[n5];
            ++n5;
        }
        rectangle.setBounds(n, n4, n3, n6);
        return rectangle;
    }

    @Override
    public void invalidateLayout(Container container) {
    }

    @Override
    public void layoutContainer(Container container) {
        Insets insets = container.getInsets();
        Rectangle rectangle = new Rectangle();
        int n = container.getComponentCount();
        this.getGrid(container, 3);
        int n2 = 0;
        while (n2 < n) {
            Component component = container.getComponent(n2);
            GridBagConstraints gridBagConstraints = this.lookupConstraints(component);
            Insets insets2 = gridBagConstraints.insets;
            rectangle.setBounds(gridBagConstraints.gridx, gridBagConstraints.gridy, gridBagConstraints.gridwidth, gridBagConstraints.gridheight);
            this.gridToPels(rectangle);
            Dimension dimension = component.getPreferredSize();
            int n3 = rectangle.x + insets.left + this.offset.x;
            int n4 = rectangle.y + insets.top + this.offset.y;
            int n5 = Math.min(dimension.width, rectangle.width);
            int n6 = Math.min(dimension.height, rectangle.height);
            block0 : switch (gridBagConstraints.fill) {
                case 1: {
                    n3 += insets2.left + gridBagConstraints.ipadx;
                    n4 += insets2.top + gridBagConstraints.ipady;
                    n5 = rectangle.width - (insets2.left + insets2.right + 2 * gridBagConstraints.ipadx);
                    n6 = rectangle.height - (insets2.top + insets2.bottom + 2 * gridBagConstraints.ipady);
                    break;
                }
                case 2: {
                    n3 += insets2.left + gridBagConstraints.ipadx;
                    n5 = rectangle.width - (insets2.left + insets2.right + 2 * gridBagConstraints.ipadx);
                    switch (gridBagConstraints.anchor) {
                        default: {
                            n4 += (rectangle.height - n6) / 2;
                            break block0;
                        }
                        case 11: 
                        case 12: 
                        case 18: {
                            n4 += insets2.top + gridBagConstraints.ipady;
                            break block0;
                        }
                        case 14: 
                        case 15: 
                        case 16: 
                    }
                    n4 += rectangle.height - (dimension.height + insets2.bottom + gridBagConstraints.ipady);
                    break;
                }
                case 3: {
                    n4 += insets2.top + gridBagConstraints.ipady;
                    n6 = rectangle.height - (insets2.top + insets2.bottom + 2 * gridBagConstraints.ipady);
                    switch (gridBagConstraints.anchor) {
                        default: {
                            n3 += (rectangle.width - n5) / 2;
                            break block0;
                        }
                        case 16: 
                        case 17: 
                        case 18: {
                            n3 += insets2.left + gridBagConstraints.ipadx;
                            break block0;
                        }
                        case 12: 
                        case 13: 
                        case 14: 
                    }
                    n3 += rectangle.width - (n5 + insets2.right + gridBagConstraints.ipadx);
                    break;
                }
                default: {
                    switch (gridBagConstraints.anchor) {
                        case 11: {
                            n4 += insets2.top + gridBagConstraints.ipady;
                            n3 += (rectangle.width - n5) / 2;
                            break block0;
                        }
                        case 12: {
                            n4 += insets2.top + gridBagConstraints.ipady;
                            n3 += rectangle.width - (n5 + insets2.right + gridBagConstraints.ipadx);
                            break block0;
                        }
                        case 13: {
                            n4 += (rectangle.height - n6) / 2;
                            n3 += rectangle.width - (n5 + insets2.right + gridBagConstraints.ipadx);
                            break block0;
                        }
                        case 14: {
                            n4 += rectangle.height - (n6 + insets2.bottom + gridBagConstraints.ipady);
                            n3 += rectangle.width - (n5 + insets2.right + gridBagConstraints.ipadx);
                            break block0;
                        }
                        case 15: {
                            n4 += rectangle.height - (n6 + insets2.bottom + gridBagConstraints.ipady);
                            n3 += (rectangle.width - n5) / 2;
                            break block0;
                        }
                        case 16: {
                            n4 += rectangle.height - (n6 + insets2.bottom + gridBagConstraints.ipady);
                            n3 += insets2.left + gridBagConstraints.ipadx;
                            break block0;
                        }
                        case 17: {
                            n4 += (rectangle.height - n6) / 2;
                            n3 += insets2.left + gridBagConstraints.ipadx;
                            break block0;
                        }
                        case 18: {
                            n4 += insets2.top + gridBagConstraints.ipady;
                            n3 += insets2.left + gridBagConstraints.ipadx;
                            break block0;
                        }
                    }
                    n4 += (rectangle.height - n6) / 2;
                    n3 += (rectangle.width - n5) / 2;
                }
            }
            component.setBounds(n3, n4, n5, n6);
            ++n2;
        }
    }

    public Point location(int n, int n2) {
        int n3 = this.offset.x;
        int n4 = this.offset.y;
        int n5 = 0;
        while (n5 < this.columnWidths.length) {
            if (n < (n3 += this.columnWidths[n5])) break;
            ++n5;
        }
        int n6 = 0;
        while (n5 < this.rowHeights.length) {
            if (n2 < (n4 += this.rowHeights[n6])) break;
            ++n6;
        }
        return new Point(n5, n6);
    }

    protected GridBagConstraints lookupConstraints(Component component) {
        GridBagConstraints gridBagConstraints = (GridBagConstraints)this.comptable.get(component);
        if (gridBagConstraints == null) {
            gridBagConstraints = this.defaultConstraints;
        }
        return gridBagConstraints;
    }

    @Override
    public Dimension maximumLayoutSize(Container container) {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    @Override
    public Dimension minimumLayoutSize(Container container) {
        Insets insets = container.getInsets();
        this.getGrid(container, 1);
        return new Dimension(this.sumWidths() + insets.left + insets.right, this.sumHeights() + insets.top + insets.bottom);
    }

    @Override
    public Dimension preferredLayoutSize(Container container) {
        Insets insets = container.getInsets();
        this.getGrid(container, 2);
        return new Dimension(this.sumWidths() + insets.left + insets.right, this.sumHeights() + insets.top + insets.bottom);
    }

    @Override
    public void removeLayoutComponent(Component component) {
    }

    public void setConstraints(Component component, GridBagConstraints gridBagConstraints) {
        this.comptable.put(component, (GridBagConstraints)gridBagConstraints.clone());
    }

    int sumHeights() {
        int n = 0;
        int n2 = 0;
        while (n2 < this.rowHeights.length) {
            n += this.rowHeights[n2];
            ++n2;
        }
        return n;
    }

    int sumWidths() {
        int n = 0;
        int n2 = 0;
        while (n2 < this.columnWidths.length) {
            n += this.columnWidths[n2];
            ++n2;
        }
        return n;
    }

    public String toString() {
        int n = this.columnWidths != null ? this.columnWidths.length : 0;
        int n2 = this.rowHeights != null ? this.rowHeights.length : 0;
        return new StringBuffer().append("GridBagLayout columns: ").append(n).append(",rows: ").append(n2).toString();
    }

    void updateConstraints(Container container) {
        int n = this.columnWidths.length;
        int n2 = this.rowHeights.length;
        int n3 = container.getComponentCount();
        int n4 = 0;
        while (n4 < n3) {
            Component component = container.getComponent(n4);
            GridBagConstraints gridBagConstraints = this.lookupConstraints(component);
            int n5 = 0;
            while (n5 < n2) {
                int n6 = 0;
                while (n6 < n) {
                    if (component == defGrid[n6][n5]) {
                        gridBagConstraints.gridx = n6;
                        gridBagConstraints.gridy = n5;
                        while (++n6 < n && defGrid[n6][n5] == component) {
                        }
                        while (++n5 < n2 && defGrid[n6 - 1][n5] == component) {
                        }
                        gridBagConstraints.gridwidth = n6 - gridBagConstraints.gridx;
                        gridBagConstraints.gridheight = n5 - gridBagConstraints.gridy;
                        n5 = n2;
                        break;
                    }
                    ++n6;
                }
                ++n5;
            }
            ++n4;
        }
    }

    private /* synthetic */ void Block$() {
        this.comptable = new Hashtable();
        this.defaultConstraints = new GridBagConstraints();
        this.offset = new Point();
    }
}

