/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.ByteArrayInputStream;
import kaffe.awt.FlavorConverter;
import kaffe.awt.ObjectSelection;
import kaffe.awt.SerializerConverter;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
class NativeSelection
implements Transferable {
    byte[] data;
    String mimeType;
    DataFlavor[] flavors;
    FlavorConverter[] converters;
    static DataFlavor[] textFlavors = new DataFlavor[2];
    static FlavorConverter[] textConverters;
    static DataFlavor[] objectFlavors;
    static FlavorConverter[] objectConverters;

    NativeSelection(String string, byte[] byArray) {
        this.mimeType = string;
        this.data = byArray;
        this.setFlavors();
    }

    @Override
    public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException {
        int n = 0;
        while (n < this.flavors.length) {
            if (this.flavors[n].equals(dataFlavor)) {
                return this.converters[n].importBytes(this.data);
            }
            ++n;
        }
        throw new UnsupportedFlavorException(dataFlavor);
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        return this.flavors;
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
        int n = 0;
        while (n < this.flavors.length) {
            if (this.flavors[n].equals(dataFlavor)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    void setFlavors() {
        if (this.mimeType.startsWith("text/plain")) {
            this.flavors = textFlavors;
            this.converters = textConverters;
            return;
        }
        if (this.mimeType.startsWith("application/x-java-serialized-object")) {
            this.flavors = objectFlavors;
            this.converters = objectConverters;
            return;
        }
        this.flavors = new DataFlavor[0];
        this.converters = new FlavorConverter[0];
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(50);
        stringBuffer.append("NativeSelection [length: ");
        stringBuffer.append(this.data.length);
        stringBuffer.append(", ");
        int n = 0;
        while (n < 8 && n < this.data.length) {
            stringBuffer.append(Integer.toHexString(this.data[n] & 0xFF));
            stringBuffer.append(' ');
            ++n;
        }
        if (n < this.data.length) {
            stringBuffer.append("...");
        }
        stringBuffer.append(']');
        return stringBuffer.toString();
    }

    static {
        NativeSelection.textFlavors[0] = DataFlavor.stringFlavor;
        NativeSelection.textFlavors[1] = DataFlavor.plainTextFlavor;
        textConverters = new FlavorConverter[2];
        NativeSelection.textConverters[0] = new 1();
        NativeSelection.textConverters[1] = new 2();
        objectFlavors = new DataFlavor[1];
        NativeSelection.objectFlavors[0] = ObjectSelection.objectFlavor;
        objectConverters = new FlavorConverter[1];
        NativeSelection.objectConverters[0] = new SerializerConverter();
    }

    /*
     * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class 1
    implements FlavorConverter {
        @Override
        public Object importBytes(byte[] byArray) {
            return new String(byArray);
        }

        @Override
        public byte[] exportObject(Object object) {
            return null;
        }
    }

    /*
     * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class 2
    implements FlavorConverter {
        @Override
        public Object importBytes(byte[] byArray) {
            return new ByteArrayInputStream(byArray);
        }

        @Override
        public byte[] exportObject(Object object) {
            return null;
        }
    }
}

