/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Polygon
implements Shape,
Serializable {
    public int npoints;
    public int[] xpoints;
    public int[] ypoints;
    protected Rectangle bounds;
    private static final long serialVersionUID = -6460061437900069969L;

    public Polygon() {
        this.npoints = 0;
        this.xpoints = new int[5];
        this.ypoints = new int[5];
    }

    public Polygon(int[] nArray, int[] nArray2, int n) {
        int n2 = nArray.length;
        if (nArray2.length < n2) {
            n2 = nArray2.length;
        }
        if (n2 < n) {
            n = n2;
        }
        this.npoints = n;
        this.xpoints = new int[n];
        this.ypoints = new int[n];
        System.arraycopy(nArray, 0, this.xpoints, 0, n);
        System.arraycopy(nArray2, 0, this.ypoints, 0, n);
    }

    public void addPoint(int n, int n2) {
        if (this.npoints == this.xpoints.length) {
            this.grow();
        }
        this.xpoints[this.npoints] = n;
        this.ypoints[this.npoints] = n2;
        ++this.npoints;
        if (this.bounds != null) {
            int n3;
            if (n < this.bounds.x) {
                this.bounds.x = n;
            }
            if ((n3 = n - this.bounds.x) > this.bounds.width) {
                this.bounds.width = n3;
            }
            if (n2 < this.bounds.y) {
                this.bounds.y = n2;
            }
            if ((n3 = n2 - this.bounds.y) > this.bounds.height) {
                this.bounds.height = n3;
            }
        }
    }

    public boolean contains(Point point) {
        return this.contains(point.x, point.y);
    }

    @Override
    public boolean contains(Point2D point2D) {
        return this.contains(point2D.getX(), point2D.getY());
    }

    @Override
    public boolean contains(Rectangle2D rectangle2D) {
        return this.contains(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight());
    }

    public boolean contains(int n, int n2) {
        return this.inside(n, n2);
    }

    @Override
    public boolean contains(double d, double d2) {
        return this.contains((int)d, (int)d2);
    }

    @Override
    public boolean contains(double d, double d2, double d3, double d4) {
        return this.contains(d, d2) && this.contains(d + d3, d2) && this.contains(d, d2 + d4) && this.contains(d + d3, d2 + d4);
    }

    public boolean inside(int n, int n2) {
        int n3 = 0;
        if (this.bounds == null) {
            this.getBounds();
        }
        if (n < this.bounds.x || n2 < this.bounds.y || n > this.bounds.x + this.bounds.width || n2 > this.bounds.y + this.bounds.height) {
            return false;
        }
        int n4 = 0;
        int n5 = 1;
        while (n4 < this.npoints) {
            if (n5 == this.npoints) {
                n5 = 0;
            }
            int n6 = this.xpoints[n4];
            int n7 = this.xpoints[n5];
            int n8 = this.ypoints[n4];
            int n9 = this.ypoints[n5];
            boolean bl = n8 > n2;
            if (!(n9 > n2 ? bl : !bl)) {
                if (n8 != n2 && (n6 >= n || n7 >= n)) {
                    if (n7 == n6) {
                        ++n3;
                    } else {
                        float f = (n9 - n8) / (n7 - n6);
                        if ((f * (float)n6 - (float)n8) / f > 0.0f) {
                            ++n3;
                        }
                    }
                }
            }
            ++n4;
            ++n5;
        }
        return n3 & true;
    }

    @Override
    public Rectangle getBounds() {
        return this.getBoundingBox();
    }

    @Override
    public Rectangle2D getBounds2D() {
        return this.getBounds();
    }

    @Override
    public PathIterator getPathIterator(AffineTransform affineTransform) {
        return new 1(this, affineTransform);
    }

    @Override
    public PathIterator getPathIterator(AffineTransform affineTransform, double d) {
        return this.getPathIterator(affineTransform);
    }

    public Rectangle getBoundingBox() {
        int n;
        int n2;
        if (this.bounds != null) {
            return this.bounds;
        }
        int n3 = n2 = Integer.MAX_VALUE;
        int n4 = n = Integer.MIN_VALUE;
        int n5 = 0;
        while (n5 < this.npoints) {
            int n6 = this.xpoints[n5];
            int n7 = this.ypoints[n5];
            if (n6 < n2) {
                n2 = n6;
            }
            if (n6 > n) {
                n = n6;
            }
            if (n7 < n3) {
                n3 = n7;
            }
            if (n7 > n4) {
                n4 = n7;
            }
            ++n5;
        }
        this.bounds = new Rectangle(n2, n3, n - n2, n4 - n3);
        return this.bounds;
    }

    void grow() {
        int n = this.xpoints.length * 3 / 2;
        int[] nArray = new int[n];
        System.arraycopy(this.xpoints, 0, nArray, 0, this.npoints);
        this.xpoints = nArray;
        nArray = new int[n];
        System.arraycopy(this.ypoints, 0, nArray, 0, this.npoints);
        this.ypoints = nArray;
    }

    @Override
    public boolean intersects(double d, double d2, double d3, double d4) {
        return this.contains(d, d2) || this.contains(d + d3, d2) || this.contains(d, d2 + d4) || this.contains(d + d3, d2 + d4);
    }

    @Override
    public boolean intersects(Rectangle2D rectangle2D) {
        return this.intersects(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight());
    }

    public void invalidate() {
        this.bounds = null;
    }

    public void reset() {
        this.invalidate();
        this.npoints = 0;
    }

    public void translate(int n, int n2) {
        int n3 = 0;
        while (n3 < this.npoints) {
            int n4 = n3;
            this.xpoints[n4] = this.xpoints[n4] + n;
            int n5 = n3++;
            this.ypoints[n5] = this.ypoints[n5] + n2;
        }
        if (this.bounds != null) {
            this.bounds.x += n;
            this.bounds.y += n2;
        }
    }

    /*
     * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class 1
    implements PathIterator {
        private int vertex;
        private final /* synthetic */ Polygon this$0;
        private final /* synthetic */ AffineTransform var$transform;

        @Override
        public int getWindingRule() {
            return 0;
        }

        @Override
        public boolean isDone() {
            return this.vertex > this.this$0.npoints;
        }

        @Override
        public void next() {
            ++this.vertex;
        }

        @Override
        public int currentSegment(float[] fArray) {
            if (this.vertex >= this.this$0.npoints) {
                return 4;
            }
            fArray[0] = this.this$0.xpoints[this.vertex];
            fArray[1] = this.this$0.ypoints[this.vertex];
            if (this.var$transform != null) {
                this.var$transform.transform(fArray, 0, fArray, 0, 1);
            }
            if (this.vertex == 0) {
                return 0;
            }
            return 1;
        }

        @Override
        public int currentSegment(double[] dArray) {
            if (this.vertex >= this.this$0.npoints) {
                return 4;
            }
            dArray[0] = this.this$0.xpoints[this.vertex];
            dArray[1] = this.this$0.ypoints[this.vertex];
            if (this.var$transform != null) {
                this.var$transform.transform(dArray, 0, dArray, 0, 1);
            }
            if (this.vertex == 0) {
                return 0;
            }
            return 1;
        }

        public 1() {
            this.this$0 = var1_1;
            this.var$transform = var2_2;
        }
    }
}

