/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Rectangle
extends Rectangle2D
implements Shape,
Serializable {
    private static final long serialVersionUID = -4345857070255674764L;
    public int x;
    public int y;
    public int width;
    public int height;

    public Rectangle() {
    }

    public Rectangle(Dimension dimension) {
        this.setSize(dimension.width, dimension.height);
    }

    public Rectangle(Point point) {
        this.setLocation(point.x, point.y);
    }

    public Rectangle(Point point, Dimension dimension) {
        this.setBounds(point.x, point.y, dimension.width, dimension.height);
    }

    public Rectangle(Rectangle rectangle) {
        this.setBounds(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public Rectangle(int n, int n2) {
        this.setSize(n, n2);
    }

    public Rectangle(int n, int n2, int n3, int n4) {
        this.setBounds(n, n2, n3, n4);
    }

    public void add(Point point) {
        this.add(point.x, point.y);
    }

    public void add(Rectangle rectangle) {
        int n = this.x + this.width;
        int n2 = this.y + this.height;
        int n3 = rectangle.x + rectangle.width;
        int n4 = rectangle.y + rectangle.height;
        if (rectangle.x < this.x) {
            this.x = rectangle.x;
        }
        if (rectangle.y < this.y) {
            this.y = rectangle.y;
        }
        this.width = (n > n3 ? n : n3) - this.x;
        this.height = (n2 > n4 ? n2 : n4) - this.y;
    }

    public void add(int n, int n2) {
        int n3 = this.x + this.width;
        int n4 = this.y + this.height;
        if (n < this.x) {
            this.x = n;
        }
        if (n2 < this.y) {
            this.y = n2;
        }
        this.width = (n > n3 ? n : n3) - this.x;
        this.height = (n2 > n4 ? n2 : n4) - this.y;
    }

    public boolean contains(Point point) {
        return this.contains(point.x, point.y);
    }

    public boolean contains(Rectangle rectangle) {
        return this.contains(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public boolean contains(int n, int n2) {
        return this.inside(n, n2);
    }

    public boolean contains(int n, int n2, int n3, int n4) {
        return this.inside(n, n2) && this.inside(n + this.width, n2 + this.height);
    }

    @Override
    public Rectangle2D createIntersection(Rectangle2D rectangle2D) {
        Rectangle2D rectangle2D2 = this.getBounds2D();
        Rectangle2D.intersect(this, rectangle2D, rectangle2D2);
        return rectangle2D2;
    }

    @Override
    public Rectangle2D createUnion(Rectangle2D rectangle2D) {
        Rectangle2D rectangle2D2 = this.getBounds2D();
        Rectangle2D.union(this, rectangle2D, rectangle2D2);
        return rectangle2D2;
    }

    @Override
    public boolean equals(Object object) {
        if (object instanceof Rectangle) {
            Rectangle rectangle = (Rectangle)object;
            return this.x == rectangle.x && this.y == rectangle.y && this.width == rectangle.width && this.height == rectangle.height;
        }
        return false;
    }

    @Override
    public Rectangle getBounds() {
        return new Rectangle(this);
    }

    @Override
    public Rectangle2D getBounds2D() {
        return this.getBounds();
    }

    @Override
    public double getHeight() {
        return this.height;
    }

    public Point getLocation() {
        return new Point(this.x, this.y);
    }

    public Dimension getSize() {
        return new Dimension(this.width, this.height);
    }

    @Override
    public double getWidth() {
        return this.width;
    }

    @Override
    public double getX() {
        return this.x;
    }

    @Override
    public double getY() {
        return this.y;
    }

    public void grow(int n, int n2) {
        this.x -= n;
        this.y -= n2;
        this.width += 2 * n;
        this.height += 2 * n2;
    }

    @Override
    public int hashCode() {
        return this.x ^ this.y * 37 ^ this.width * 43 ^ this.height * 47;
    }

    public boolean inside(int n, int n2) {
        return this.x <= n && this.x + this.width >= n && this.y <= n2 && this.y + this.height >= n2;
    }

    public Rectangle intersection(Rectangle rectangle) {
        int n = this.x + this.width;
        int n2 = this.y + this.height;
        int n3 = rectangle.x + rectangle.width;
        int n4 = rectangle.y + rectangle.height;
        if (this.x > n3 || this.y > n4 || n < rectangle.x || n2 < rectangle.y) {
            return new Rectangle();
        }
        int n5 = this.x > rectangle.x ? this.x : rectangle.x;
        int n6 = this.y > rectangle.y ? this.y : rectangle.y;
        int n7 = (n < n3 ? n : n3) - n5;
        int n8 = (n2 < n4 ? n2 : n4) - n6;
        return new Rectangle(n5, n6, n7, n8);
    }

    public boolean intersects(Rectangle rectangle) {
        return this.x <= rectangle.x + rectangle.width && this.y <= rectangle.y + rectangle.height && rectangle.x <= this.x + this.width && rectangle.y <= this.y + this.height;
    }

    @Override
    public boolean isEmpty() {
        return this.width <= 0 || this.height <= 0;
    }

    public void move(int n, int n2) {
        this.x = n;
        this.y = n2;
    }

    @Override
    public int outcode(double d, double d2) {
        int n = 0;
        if (this.width <= 0) {
            n |= 5;
        } else if (d < (double)this.x) {
            n |= 1;
        } else if (d > (double)(this.x + this.width)) {
            n |= 4;
        }
        if (this.height <= 0) {
            n |= 0xA;
        } else if (d2 < (double)this.y) {
            n |= 2;
        } else if (d2 > (double)(this.y + this.height)) {
            n |= 8;
        }
        return n;
    }

    public void reshape(int n, int n2, int n3, int n4) {
        this.x = n;
        this.y = n2;
        this.width = n3;
        this.height = n4;
    }

    public void resize(int n, int n2) {
        this.width = n;
        this.height = n2;
    }

    public void setBounds(Rectangle rectangle) {
        this.setBounds(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        this.reshape(n, n2, n3, n4);
    }

    public void setLocation(Point point) {
        this.x = point.x;
        this.y = point.y;
    }

    @Override
    public void setRect(double d, double d2, double d3, double d4) {
        this.setBounds((int)d, (int)d2, (int)d3, (int)d4);
    }

    public void setLocation(int n, int n2) {
        this.move(n, n2);
    }

    public void setSize(Dimension dimension) {
        this.setSize(dimension.width, dimension.height);
    }

    public void setSize(int n, int n2) {
        this.resize(n, n2);
    }

    public String toString() {
        return new StringBuffer().append(this.getClass().getName()).append("[x=").append(this.x).append(",y=").append(this.y).append(",width=").append(this.width).append(",height=").append(this.height).append(']').toString();
    }

    public void translate(int n, int n2) {
        this.x += n;
        this.y += n2;
    }

    public Rectangle union(Rectangle rectangle) {
        int n = this.x + this.width;
        int n2 = this.y + this.height;
        int n3 = rectangle.x + rectangle.width;
        int n4 = rectangle.y + rectangle.height;
        int n5 = this.x < rectangle.x ? this.x : rectangle.x;
        int n6 = this.y < rectangle.y ? this.y : rectangle.y;
        int n7 = (n > n3 ? n : n3) - n5;
        int n8 = (n2 > n4 ? n2 : n4) - n6;
        return new Rectangle(n5, n6, n7, n8);
    }
}

