/*
 * Decompiled with CFR 0.152.
 */
package java.awt.dnd;

import java.awt.Component;
import java.awt.Point;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.event.InputEvent;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.TooManyListenersException;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DragGestureRecognizer
implements Serializable {
    private static final long serialVersionUID = 8996673345831063337L;
    protected DragSource dragSource;
    protected Component component;
    protected transient DragGestureListener dragGestureListener;
    protected int sourceActions;
    protected ArrayList events;

    protected DragGestureRecognizer(DragSource dragSource, Component component, int n, DragGestureListener dragGestureListener) {
        this.Block$();
        if (dragSource == null) {
            throw new IllegalArgumentException();
        }
        this.dragSource = dragSource;
        this.component = component;
        this.sourceActions = n;
        this.dragGestureListener = dragGestureListener;
    }

    protected DragGestureRecognizer(DragSource dragSource, Component component, int n) {
        this(dragSource, component, n, null);
    }

    protected DragGestureRecognizer(DragSource dragSource, Component component) {
        this(dragSource, component, 0, null);
    }

    protected DragGestureRecognizer(DragSource dragSource) {
        this(dragSource, null, 0, null);
    }

    protected abstract void registerListeners();

    protected abstract void unregisterListeners();

    public DragSource getDragSource() {
        return this.dragSource;
    }

    public Component getComponent() {
        return this.component;
    }

    public void setComponent(Component component) {
        this.component = component;
    }

    public int getSourceActions() {
        return this.sourceActions;
    }

    public void setSourceActions(int n) {
        this.sourceActions = n;
    }

    public InputEvent getTriggerEvent() {
        if (this.events.size() > 0) {
            return (InputEvent)this.events.get(0);
        }
        return null;
    }

    public void resetRecognizer() {
        throw new Error("not implemented");
    }

    public void addDragGestureListener(DragGestureListener dragGestureListener) throws TooManyListenersException {
        if (this.dragGestureListener != null) {
            throw new TooManyListenersException();
        }
        this.dragGestureListener = dragGestureListener;
    }

    public void removeDragGestureListener(DragGestureListener dragGestureListener) {
        if (this.dragGestureListener != dragGestureListener) {
            throw new IllegalArgumentException();
        }
        this.dragGestureListener = null;
    }

    protected void fireDragGestureRecognized(int n, Point point) {
        throw new Error("not implemented");
    }

    protected void appendEvent(InputEvent inputEvent) {
        if (inputEvent == null) {
            return;
        }
        this.events.add(inputEvent);
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        objectInputStream.defaultReadObject();
        this.dragGestureListener = (DragGestureListener)objectInputStream.readObject();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeObject(this.dragGestureListener instanceof Serializable ? this.dragGestureListener : null);
    }

    private /* synthetic */ void Block$() {
        this.events = new ArrayList();
    }
}

