/*
 * Decompiled with CFR 0.152.
 */
package java.awt.event;

import java.awt.Component;
import java.awt.Event;
import java.awt.event.InputEvent;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KeyEvent
extends InputEvent {
    protected int keyCode;
    protected char keyChar;
    private static final long serialVersionUID = -2352130953028126954L;
    public static final int KEY_FIRST = 400;
    public static final int KEY_LAST = 402;
    public static final int KEY_TYPED = 400;
    public static final int KEY_PRESSED = 401;
    public static final int KEY_RELEASED = 402;
    public static final int VK_ENTER = 10;
    public static final int VK_BACK_SPACE = 8;
    public static final int VK_TAB = 9;
    public static final int VK_CANCEL = 3;
    public static final int VK_CLEAR = 12;
    public static final int VK_SHIFT = 16;
    public static final int VK_CONTROL = 17;
    public static final int VK_ALT = 18;
    public static final int VK_PAUSE = 19;
    public static final int VK_CAPS_LOCK = 20;
    public static final int VK_ESCAPE = 27;
    public static final int VK_SPACE = 32;
    public static final int VK_PAGE_UP = 33;
    public static final int VK_PAGE_DOWN = 34;
    public static final int VK_END = 35;
    public static final int VK_HOME = 36;
    public static final int VK_LEFT = 37;
    public static final int VK_UP = 38;
    public static final int VK_RIGHT = 39;
    public static final int VK_DOWN = 40;
    public static final int VK_COMMA = 44;
    public static final int VK_MINUS = 45;
    public static final int VK_PERIOD = 46;
    public static final int VK_SLASH = 47;
    public static final int VK_0 = 48;
    public static final int VK_1 = 49;
    public static final int VK_2 = 50;
    public static final int VK_3 = 51;
    public static final int VK_4 = 52;
    public static final int VK_5 = 53;
    public static final int VK_6 = 54;
    public static final int VK_7 = 55;
    public static final int VK_8 = 56;
    public static final int VK_9 = 57;
    public static final int VK_SEMICOLON = 59;
    public static final int VK_EQUALS = 61;
    public static final int VK_A = 65;
    public static final int VK_B = 66;
    public static final int VK_C = 67;
    public static final int VK_D = 68;
    public static final int VK_E = 69;
    public static final int VK_F = 70;
    public static final int VK_G = 71;
    public static final int VK_H = 72;
    public static final int VK_I = 73;
    public static final int VK_J = 74;
    public static final int VK_K = 75;
    public static final int VK_L = 76;
    public static final int VK_M = 77;
    public static final int VK_N = 78;
    public static final int VK_O = 79;
    public static final int VK_P = 80;
    public static final int VK_Q = 81;
    public static final int VK_R = 82;
    public static final int VK_S = 83;
    public static final int VK_T = 84;
    public static final int VK_U = 85;
    public static final int VK_V = 86;
    public static final int VK_W = 87;
    public static final int VK_X = 88;
    public static final int VK_Y = 89;
    public static final int VK_Z = 90;
    public static final int VK_OPEN_BRACKET = 91;
    public static final int VK_BACK_SLASH = 92;
    public static final int VK_CLOSE_BRACKET = 93;
    public static final int VK_NUMPAD0 = 96;
    public static final int VK_NUMPAD1 = 97;
    public static final int VK_NUMPAD2 = 98;
    public static final int VK_NUMPAD3 = 99;
    public static final int VK_NUMPAD4 = 100;
    public static final int VK_NUMPAD5 = 101;
    public static final int VK_NUMPAD6 = 102;
    public static final int VK_NUMPAD7 = 103;
    public static final int VK_NUMPAD8 = 104;
    public static final int VK_NUMPAD9 = 105;
    public static final int VK_MULTIPLY = 106;
    public static final int VK_ADD = 107;
    public static final int VK_SEPARATER = 108;
    public static final int VK_SEPARATOR = 108;
    public static final int VK_SUBTRACT = 109;
    public static final int VK_DECIMAL = 110;
    public static final int VK_DIVIDE = 111;
    public static final int VK_DELETE = 127;
    public static final int VK_NUM_LOCK = 144;
    public static final int VK_SCROLL_LOCK = 145;
    public static final int VK_F1 = 112;
    public static final int VK_F2 = 113;
    public static final int VK_F3 = 114;
    public static final int VK_F4 = 115;
    public static final int VK_F5 = 116;
    public static final int VK_F6 = 117;
    public static final int VK_F7 = 118;
    public static final int VK_F8 = 119;
    public static final int VK_F9 = 120;
    public static final int VK_F10 = 121;
    public static final int VK_F11 = 122;
    public static final int VK_F12 = 123;
    public static final int VK_F13 = 61440;
    public static final int VK_F14 = 61441;
    public static final int VK_F15 = 61442;
    public static final int VK_F16 = 61443;
    public static final int VK_F17 = 61444;
    public static final int VK_F18 = 61445;
    public static final int VK_F19 = 61446;
    public static final int VK_F20 = 61447;
    public static final int VK_F21 = 61448;
    public static final int VK_F22 = 61449;
    public static final int VK_F23 = 61450;
    public static final int VK_F24 = 61451;
    public static final int VK_PRINTSCREEN = 154;
    public static final int VK_INSERT = 155;
    public static final int VK_HELP = 156;
    public static final int VK_META = 157;
    public static final int VK_BACK_QUOTE = 192;
    public static final int VK_QUOTE = 222;
    public static final int VK_KP_UP = 224;
    public static final int VK_KP_DOWN = 225;
    public static final int VK_KP_LEFT = 226;
    public static final int VK_KP_RIGHT = 227;
    public static final int VK_DEAD_GRAVE = 128;
    public static final int VK_DEAD_ACUTE = 129;
    public static final int VK_DEAD_CIRCUMFLEX = 130;
    public static final int VK_DEAD_TILDE = 131;
    public static final int VK_DEAD_MACRON = 132;
    public static final int VK_DEAD_BREVE = 133;
    public static final int VK_DEAD_ABOVEDOT = 134;
    public static final int VK_DEAD_DIAERESIS = 135;
    public static final int VK_DEAD_ABOVERING = 136;
    public static final int VK_DEAD_DOUBLEACUTE = 137;
    public static final int VK_DEAD_CARON = 138;
    public static final int VK_DEAD_CEDILLA = 139;
    public static final int VK_DEAD_OGONEK = 140;
    public static final int VK_DEAD_IOTA = 141;
    public static final int VK_DEAD_VOICED_SOUND = 142;
    public static final int VK_DEAD_SEMIVOICED_SOUND = 143;
    public static final int VK_AMPERSAND = 150;
    public static final int VK_ASTERISK = 151;
    public static final int VK_QUOTEDBL = 152;
    public static final int VK_LESS = 153;
    public static final int VK_GREATER = 160;
    public static final int VK_BRACELEFT = 161;
    public static final int VK_BRACERIGHT = 162;
    public static final int VK_AT = 512;
    public static final int VK_COLON = 513;
    public static final int VK_CIRCUMFLEX = 514;
    public static final int VK_DOLLAR = 515;
    public static final int VK_EURO_SIGN = 516;
    public static final int VK_EXCLAMATION_MARK = 517;
    public static final int VK_INVERTED_EXCLAMATION_MARK = 518;
    public static final int VK_LEFT_PARENTHESIS = 519;
    public static final int VK_NUMBER_SIGN = 520;
    public static final int VK_PLUS = 521;
    public static final int VK_RIGHT_PARENTHESIS = 522;
    public static final int VK_UNDERSCORE = 523;
    public static final int VK_FINAL = 24;
    public static final int VK_CONVERT = 28;
    public static final int VK_NONCONVERT = 29;
    public static final int VK_ACCEPT = 30;
    public static final int VK_MODECHANGE = 31;
    public static final int VK_KANA = 21;
    public static final int VK_KANJI = 25;
    public static final int VK_ALPHANUMERIC = 240;
    public static final int VK_KATAKANA = 241;
    public static final int VK_HIRAGANA = 242;
    public static final int VK_FULL_WIDTH = 243;
    public static final int VK_HALF_WIDTH = 244;
    public static final int VK_ROMAN_CHARACTERS = 245;
    public static final int VK_ALL_CANDIDATES = 256;
    public static final int VK_PREVIOUS_CANDIDATE = 257;
    public static final int VK_CODE_INPUT = 258;
    public static final int VK_JAPANESE_KATAKANA = 259;
    public static final int VK_JAPANESE_HIRAGANA = 260;
    public static final int VK_JAPANESE_ROMAN = 261;
    public static final int VK_KANA_LOCK = 262;
    public static final int VK_INPUT_METHOD_ON_OFF = 263;
    public static final int VK_CUT = 65489;
    public static final int VK_COPY = 65485;
    public static final int VK_PASTE = 65487;
    public static final int VK_UNDO = 65483;
    public static final int VK_AGAIN = 65481;
    public static final int VK_FIND = 65488;
    public static final int VK_PROPS = 65482;
    public static final int VK_STOP = 65480;
    public static final int VK_COMPOSE = 65312;
    public static final int VK_ALT_GRAPH = 65406;
    public static final int VK_UNDEFINED = 0;
    public static final char CHAR_UNDEFINED = '\uffff';
    public static final int KEY_LOCATION_UNKNOWN = 0;
    public static final int KEY_LOCATION_STANDARD = 1;
    public static final int KEY_LOCATION_LEFT = 2;
    public static final int KEY_LOCATION_RIGHT = 3;
    public static final int KEY_LOCATION_NUMPAD = 4;

    public KeyEvent(Component component, int n, long l, int n2, int n3) {
        super(component, n);
        this.when = l;
        this.modifiers = n2;
        this.keyCode = n3;
        this.keyChar = (char)n3;
    }

    public KeyEvent(Component component, int n, long l, int n2, int n3, char c) {
        super(component, n);
        this.when = l;
        this.modifiers = n2;
        this.keyCode = n3;
        this.keyChar = c;
    }

    public KeyEvent(Component component, int n, long l, int n2, int n3, char c, int n4) {
        super(component, n);
        this.when = l;
        this.modifiers = n2;
        this.keyCode = n3;
        this.keyChar = c;
    }

    public char getKeyChar() {
        return this.keyChar;
    }

    public int getKeyCode() {
        return this.keyCode;
    }

    public static String getKeyModifiersText(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        if ((n & 4) != 0) {
            ++n2;
            stringBuffer.append("Meta");
        }
        if ((n & 2) != 0) {
            if (n2++ > 0) {
                stringBuffer.append('+');
            }
            stringBuffer.append("Ctrl");
        }
        if ((n & 8) != 0) {
            if (n2++ > 0) {
                stringBuffer.append('+');
            }
            stringBuffer.append("Alt");
        }
        if ((n & 1) != 0) {
            if (n2++ > 0) {
                stringBuffer.append('+');
            }
            stringBuffer.append("Shift");
        }
        return stringBuffer.toString();
    }

    public static String getKeyText(int n) {
        if (n >= 48 && n <= 57 || n >= 65 && n <= 90 || n == 44 || n == 46 || n == 47 || n == 59 || n == 61 || n == 91 || n == 92 || n == 93) {
            return String.valueOf((char)n);
        }
        switch (n) {
            case 10: {
                return "Enter";
            }
            case 8: {
                return "Backspace";
            }
            case 9: {
                return "Tab";
            }
            case 3: {
                return "Cancel";
            }
            case 12: {
                return "Clear";
            }
            case 16: {
                return "Shift";
            }
            case 17: {
                return "Control";
            }
            case 18: {
                return "Alt";
            }
            case 19: {
                return "Pause";
            }
            case 20: {
                return "Caps Lock";
            }
            case 27: {
                return "Escape";
            }
            case 32: {
                return "Space";
            }
            case 33: {
                return "Page Up";
            }
            case 34: {
                return "Page Down";
            }
            case 35: {
                return "End";
            }
            case 36: {
                return "Home";
            }
            case 37: {
                return "Left";
            }
            case 38: {
                return "Up";
            }
            case 39: {
                return "Right";
            }
            case 40: {
                return "Down";
            }
            case 226: {
                return "Left";
            }
            case 224: {
                return "Up";
            }
            case 227: {
                return "Right";
            }
            case 225: {
                return "Down";
            }
            case 106: {
                return "NumPad *";
            }
            case 107: {
                return "NumPad +";
            }
            case 108: {
                return "NumPad ,";
            }
            case 109: {
                return "NumPad -";
            }
            case 110: {
                return "NumPad .";
            }
            case 111: {
                return "NumPad /";
            }
            case 112: {
                return "F1";
            }
            case 113: {
                return "F2";
            }
            case 114: {
                return "F3";
            }
            case 115: {
                return "F4";
            }
            case 116: {
                return "F5";
            }
            case 117: {
                return "F6";
            }
            case 118: {
                return "F7";
            }
            case 119: {
                return "F8";
            }
            case 120: {
                return "F9";
            }
            case 121: {
                return "F10";
            }
            case 122: {
                return "F11";
            }
            case 123: {
                return "F12";
            }
            case 61440: {
                return "F13";
            }
            case 61441: {
                return "F14";
            }
            case 61442: {
                return "F15";
            }
            case 61443: {
                return "F16";
            }
            case 61444: {
                return "F17";
            }
            case 61445: {
                return "F18";
            }
            case 61446: {
                return "F19";
            }
            case 61447: {
                return "F20";
            }
            case 61448: {
                return "F21";
            }
            case 61449: {
                return "F22";
            }
            case 61450: {
                return "F23";
            }
            case 61451: {
                return "F24";
            }
            case 127: {
                return "Delete";
            }
            case 144: {
                return "Num Lock";
            }
            case 145: {
                return "Scroll Lock";
            }
            case 154: {
                return "Print Screen";
            }
            case 155: {
                return "Insert";
            }
            case 156: {
                return "Help";
            }
            case 157: {
                return "Meta";
            }
            case 192: {
                return "Back Quote";
            }
            case 222: {
                return "Quote";
            }
            case 24: {
                return "Final";
            }
            case 28: {
                return "Convert";
            }
            case 29: {
                return "No Convert";
            }
            case 30: {
                return "Accept";
            }
            case 31: {
                return "Mode Change";
            }
            case 21: {
                return "Kana";
            }
            case 25: {
                return "Kanji";
            }
            case 65481: {
                return "Again";
            }
            case 256: {
                return "All Candidates";
            }
            case 240: {
                return "Alphanumeric";
            }
            case 65406: {
                return "Alt Graph";
            }
            case 150: {
                return "Ampersand";
            }
            case 151: {
                return "Asterisk";
            }
            case 512: {
                return "At";
            }
            case 161: {
                return "Left Brace";
            }
            case 162: {
                return "Right Brace";
            }
            case 514: {
                return "Circumflex";
            }
            case 258: {
                return "Code Input";
            }
            case 513: {
                return "Colon";
            }
            case 65312: {
                return "Compose ";
            }
            case 65485: {
                return "Copy";
            }
            case 65489: {
                return "Cut";
            }
            case 134: {
                return "Dead Above Dot";
            }
            case 136: {
                return "Dead Above Ring";
            }
            case 129: {
                return "Dead Acute";
            }
            case 133: {
                return "Dead Breve";
            }
            case 138: {
                return "Dead Caron";
            }
            case 139: {
                return "Dead Cedilla";
            }
            case 130: {
                return "Dead Circumflex";
            }
            case 135: {
                return "Dead Diaeresis";
            }
            case 137: {
                return "Dead Double Acute";
            }
            case 128: {
                return "Dead Grave";
            }
            case 141: {
                return "Dead Iota";
            }
            case 132: {
                return "Dead Macron";
            }
            case 140: {
                return "Dead Ogonek";
            }
            case 143: {
                return "Dead Semivoiced Sound";
            }
            case 131: {
                return "Dead Tilde";
            }
            case 142: {
                return "Dead Voiced Sound";
            }
            case 515: {
                return "Dollar";
            }
            case 516: {
                return "Euro";
            }
            case 517: {
                return "Exclamation Mark";
            }
            case 65488: {
                return "Find";
            }
            case 243: {
                return "Full-Width";
            }
            case 160: {
                return "Greater";
            }
            case 244: {
                return "Half-Width";
            }
            case 242: {
                return "Hiragana";
            }
            case 263: {
                return "Input Method On/Off";
            }
            case 518: {
                return "Inverted Exclamation Mark";
            }
            case 260: {
                return "Japanese Hiragana";
            }
            case 259: {
                return "Japanese Katakana";
            }
            case 261: {
                return "Japanese Roman";
            }
            case 262: {
                return "Kana Lock";
            }
            case 241: {
                return "Katakana";
            }
            case 519: {
                return "Left Parenthesis";
            }
            case 153: {
                return "Less";
            }
            case 45: {
                return "Minus";
            }
            case 520: {
                return "Number Sign";
            }
            case 65487: {
                return "Paste";
            }
            case 521: {
                return "Plus";
            }
            case 257: {
                return "Previous Candidate";
            }
            case 65482: {
                return "Props";
            }
            case 152: {
                return "Double Quote";
            }
            case 522: {
                return "Right Parenthesis";
            }
            case 245: {
                return "Roman Characters";
            }
            case 65480: {
                return "Stop";
            }
            case 523: {
                return "Underscore";
            }
            case 65483: {
                return "Undo";
            }
        }
        if (n >= 96 && n <= 105) {
            return new StringBuffer().append("NumPad-").append((char)(n - 96 + 48)).toString();
        }
        return new StringBuffer().append("Unknown keyCode: 0x").append(Integer.toString(n, 16)).toString();
    }

    @Override
    protected Event initOldEvent(Event event) {
        if (this.keyChar == '\u0000') {
            return null;
        }
        event.target = this.source;
        event.id = this.id;
        event.when = this.when;
        event.modifiers = this.modifiers;
        event.key = this.keyChar;
        event.x = ((Component)this.getSource()).getX();
        event.y = ((Component)this.getSource()).getY();
        return event;
    }

    public boolean isActionKey() {
        int n = this.keyCode;
        if (n == 32) {
            return false;
        }
        if (n > 40 && n < 112) {
            return false;
        }
        if (n < 19) {
            return false;
        }
        if (n > 25 && n < 28) {
            return false;
        }
        if (n > 21 && n < 24) {
            return false;
        }
        if (n <= 123) {
            return true;
        }
        if (n >= 144 && n <= 145) {
            return true;
        }
        if (n >= 154 && n <= 156) {
            return true;
        }
        if (n >= 224 && n <= 227) {
            return true;
        }
        if (n >= 240 && n <= 245) {
            return true;
        }
        if (n >= 256 && n <= 263) {
            return true;
        }
        if (n >= 61440 && n <= 61451) {
            return true;
        }
        if (n >= 65480 && n <= 65483) {
            return true;
        }
        if (n == 65485) {
            return true;
        }
        return n >= 65487 && n <= 65489;
    }

    @Override
    public String paramString() {
        String string;
        int n = this.keyCode;
        char c = this.keyChar;
        switch (this.id) {
            case 401: {
                string = "KEY_PRESSED";
                break;
            }
            case 402: {
                string = "KEY_RELEASED";
                break;
            }
            case 400: {
                string = "KEY_TYPED";
                break;
            }
            default: {
                string = "unknown type";
            }
        }
        string = string.concat(new StringBuffer().append(",keyCode=").append(this.keyCode).toString());
        string = this.isActionKey() || n == 10 || n == 8 || n == 9 || n == 27 || n == 127 || n >= 96 && n <= 105 ? string.concat(new StringBuffer().append(',').append(KeyEvent.getKeyText(n)).toString()) : (c == '\n' || c == '\b' || c == '\t' || c == '\u001b' || c == '\u007f' ? string.concat(new StringBuffer().append(',').append(KeyEvent.getKeyText(c)).toString()) : string.concat(new StringBuffer().append(",keyChar='").append(this.keyChar).append("'").toString()));
        if (this.modifiers > 0) {
            string = string.concat(new StringBuffer().append(",modifiers=").append(KeyEvent.getKeyModifiersText(this.modifiers)).toString());
        }
        return string;
    }

    public int getKeyLocation() {
        return 0;
    }

    public void setKeyChar(char c) {
        this.keyChar = c;
    }

    public void setKeyCode(int n) {
        this.keyCode = n;
    }

    public void setModifiers(int n) {
        this.modifiers = n;
    }
}

