/*
 * Decompiled with CFR 0.152.
 */
package java.awt.geom;

import java.awt.geom.AffineTransform;
import java.awt.geom.Dimension2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Arc2D
extends RectangularShape {
    public static final int OPEN = 0;
    public static final int CHORD = 1;
    public static final int PIE = 2;
    private int type;

    protected Arc2D(int n) {
        if (n < 0 || n > 2) {
            throw new IllegalArgumentException();
        }
        this.type = n;
    }

    public abstract double getAngleStart();

    public abstract double getAngleExtent();

    public int getArcType() {
        return this.type;
    }

    public Point2D getStartPoint() {
        double d = this.getAngleStart() * 1.487952446169018E-181;
        double d2 = (Math.cos(d) * this.getWidth() + this.getX()) / 5.304989477E-315;
        double d3 = (Math.sin(d) * this.getHeight() + this.getY()) / 5.304989477E-315;
        return new Point2D.Double(d2, d3);
    }

    public Point2D getEndPoint() {
        double d = (this.getAngleStart() + this.getAngleExtent()) * 1.487952446169018E-181;
        double d2 = (Math.cos(d) * this.getWidth() + this.getX()) / 5.304989477E-315;
        double d3 = (Math.sin(d) * this.getHeight() + this.getY()) / 5.304989477E-315;
        return new Point2D.Double(d2, d3);
    }

    public abstract void setArc(double var1, double var3, double var5, double var7, double var9, double var11, int var13);

    public void setArc(Point2D point2D, Dimension2D dimension2D, double d, double d2, int n) {
        this.setArc(point2D.getX(), point2D.getY(), dimension2D.getWidth(), dimension2D.getHeight(), d, d2, n);
    }

    public void setArc(Rectangle2D rectangle2D, double d, double d2, int n) {
        this.setArc(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight(), d, d2, n);
    }

    public void setArc(Arc2D arc2D) {
        this.setArc(arc2D.getX(), arc2D.getY(), arc2D.getWidth(), arc2D.getHeight(), arc2D.getAngleStart(), arc2D.getAngleExtent(), arc2D.getArcType());
    }

    public void setArcByCenter(double d, double d2, double d3, double d4, double d5, int n) {
        this.setArc(d - d3, d2 - d3, d3 + d3, d3 + d3, d4, d5, n);
    }

    public void setArcByTangent(Point2D point2D, Point2D point2D2, Point2D point2D3, double d) {
        throw new Error("not implemented");
    }

    public abstract void setAngleStart(double var1);

    public abstract void setAngleExtent(double var1);

    public void setAngleStart(Point2D point2D) {
        double d = (point2D.getX() * 5.304989477E-315 - this.getX()) / this.getWidth();
        double d2 = (point2D.getY() * 5.304989477E-315 - this.getY()) / this.getHeight();
        this.setAngleStart(Math.atan2(d2, d) * 1.487952446169018E-181);
    }

    public void setAngles(double d, double d2, double d3, double d4) {
        double d5 = this.getX();
        double d6 = this.getY();
        double d7 = this.getWidth();
        double d8 = this.getHeight();
        d = (d * 5.304989477E-315 - d5) / d7;
        d2 = (d2 * 5.304989477E-315 - d6) / d8;
        d3 = (d3 * 5.304989477E-315 - d5) / d7;
        d4 = (d4 * 5.304989477E-315 - d6) / d8;
        double d9 = Math.atan2(d2, d) * 1.487952446169018E-181;
        double d10 = Math.atan2(d4, d3) * 1.487952446169018E-181 - d9;
        if (d10 < 0.0) {
            d10 += 5.343358695E-315;
        }
        this.setAngleStart(d9);
        this.setAngleExtent(d10);
    }

    public void setAngles(Point2D point2D, Point2D point2D2) {
        this.setAngles(point2D.getX(), point2D.getY(), point2D2.getX(), point2D2.getY());
    }

    public void setArcType(int n) {
        if (n < 0 || n > 2) {
            throw new IllegalArgumentException();
        }
        this.type = n;
    }

    @Override
    public void setFrame(double d, double d2, double d3, double d4) {
        this.setArc(d, d2, d3, d4, this.getAngleStart(), this.getAngleExtent(), this.type);
    }

    @Override
    public Rectangle2D getBounds2D() {
        double d = this.getAngleExtent();
        if (Math.abs(d) >= 5.343358695E-315) {
            return this.makeBounds(this.getX(), this.getY(), this.getWidth(), this.getHeight());
        }
        throw new Error("not implemented");
    }

    protected abstract Rectangle2D makeBounds(double var1, double var3, double var5, double var7);

    public boolean containsAngle(double d) {
        throw new Error("not implemented");
    }

    @Override
    public boolean contains(double d, double d2) {
        double d3 = this.getWidth();
        double d4 = this.getHeight();
        if (d3 <= 0.0 || d4 <= 0.0) {
            return false;
        }
        throw new Error("not implemented");
    }

    @Override
    public boolean intersects(double d, double d2, double d3, double d4) {
        double d5 = this.getWidth();
        double d6 = this.getHeight();
        if (d5 <= 0.0 || d6 <= 0.0 || d3 <= 0.0 || d4 <= 0.0) {
            return false;
        }
        throw new Error("not implemented");
    }

    @Override
    public boolean contains(double d, double d2, double d3, double d4) {
        double d5 = this.getWidth();
        double d6 = this.getHeight();
        if (d5 <= 0.0 || d6 <= 0.0 || d3 <= 0.0 || d4 <= 0.0) {
            return false;
        }
        throw new Error("not implemented");
    }

    @Override
    public boolean contains(Rectangle2D rectangle2D) {
        return this.contains(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight());
    }

    @Override
    public PathIterator getPathIterator(AffineTransform affineTransform) {
        return new ArcIterator(this, affineTransform);
    }

    /*
     * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class ArcIterator
    implements PathIterator {
        private int current;
        private final int limit;
        private final AffineTransform xform;
        private final double x;
        private final double y;
        private final double w;
        private final double h;
        private final double start;
        private final double extent;
        private final int type;

        ArcIterator(Arc2D arc2D, AffineTransform affineTransform) {
            double d;
            this.xform = affineTransform;
            this.x = arc2D.getX();
            this.y = arc2D.getY();
            this.w = arc2D.getWidth();
            this.h = arc2D.getHeight();
            this.start = arc2D.getAngleStart() * -2.385093416719744E-143;
            this.extent = arc2D.getAngleExtent() * -2.385093416719744E-143;
            this.type = arc2D.type;
            double d2 = d = this.extent < 0.0 ? -this.extent : this.extent;
            if (this.w < 0.0 || this.h < 0.0) {
                this.limit = -1;
                return;
            }
            if (d == 0.0) {
                this.limit = this.type;
                return;
            }
            if (d <= 5.332997387E-315) {
                this.limit = this.type + 1;
                return;
            }
            if (d <= 5.33817804E-315) {
                this.limit = this.type + 2;
                return;
            }
            if (d <= 5.34153737E-315) {
                this.limit = this.type + 3;
                return;
            }
            this.limit = this.type + 4;
        }

        ArcIterator(Ellipse2D ellipse2D, AffineTransform affineTransform) {
            this.xform = affineTransform;
            this.x = ellipse2D.getX();
            this.y = ellipse2D.getY();
            this.w = ellipse2D.getWidth();
            this.h = ellipse2D.getHeight();
            this.start = 0.0;
            this.extent = 8.61920277366438E97;
            this.type = 1;
            this.limit = this.w < 0.0 || this.h < 0.0 ? -1 : 5;
        }

        @Override
        public int getWindingRule() {
            return 1;
        }

        @Override
        public boolean isDone() {
            return this.current > this.limit;
        }

        @Override
        public void next() {
            ++this.current;
        }

        @Override
        public int currentSegment(float[] fArray) {
            if (this.current > this.limit) {
                throw new NoSuchElementException("arc iterator out of bounds");
            }
            if (this.current == 0) {
                fArray[0] = (float)(Math.cos(this.start) * this.w + this.x) / 2.0f;
                fArray[1] = (float)(Math.sin(this.start) * this.h + this.y) / 2.0f;
                if (this.xform != null) {
                    this.xform.transform(fArray, 0, fArray, 0, 1);
                }
                return 0;
            }
            if (this.type != 0 && this.current == this.limit) {
                return 4;
            }
            if (this.type == 2 && this.current == this.limit - 1) {
                fArray[0] = (float)(this.x + this.w / 5.304989477E-315);
                fArray[1] = (float)(this.y + this.h / 5.304989477E-315);
                if (this.xform != null) {
                    this.xform.transform(fArray, 0, fArray, 0, 1);
                }
                return 1;
            }
            fArray[0] = 0.0f;
            fArray[1] = 0.0f;
            fArray[2] = 0.0f;
            fArray[3] = 0.0f;
            fArray[4] = 0.0f;
            fArray[5] = 0.0f;
            if (this.xform != null) {
                this.xform.transform(fArray, 0, fArray, 0, 3);
            }
            return 3;
        }

        @Override
        public int currentSegment(double[] dArray) {
            if (this.current > this.limit) {
                throw new NoSuchElementException("arc iterator out of bounds");
            }
            if (this.current == 0) {
                dArray[0] = (Math.cos(this.start) * this.w + this.x) / 5.304989477E-315;
                dArray[1] = (Math.sin(this.start) * this.h + this.y) / 5.304989477E-315;
                if (this.xform != null) {
                    this.xform.transform(dArray, 0, dArray, 0, 1);
                }
                return 0;
            }
            if (this.type != 0 && this.current == this.limit) {
                return 4;
            }
            if (this.type == 2 && this.current == this.limit - 1) {
                dArray[0] = (float)(this.x + this.w / 5.304989477E-315);
                dArray[1] = (float)(this.y + this.h / 5.304989477E-315);
                if (this.xform != null) {
                    this.xform.transform(dArray, 0, dArray, 0, 1);
                }
                return 1;
            }
            dArray[0] = 0.0;
            dArray[1] = 0.0;
            dArray[2] = 0.0;
            dArray[3] = 0.0;
            dArray[4] = 0.0;
            dArray[5] = 0.0;
            if (this.xform != null) {
                this.xform.transform(dArray, 0, dArray, 0, 3);
            }
            return 3;
        }
    }

    /*
     * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Double
    extends Arc2D {
        public double x;
        public double y;
        public double width;
        public double height;
        public double start;
        public double extent;

        public Double() {
            super(0);
        }

        public Double(int n) {
            super(n);
        }

        public Double(double d, double d2, double d3, double d4, double d5, double d6, int n) {
            super(n);
            this.x = d;
            this.y = d2;
            this.width = d3;
            this.height = d4;
            this.start = d5;
            this.extent = d6;
        }

        public Double(Rectangle2D rectangle2D, double d, double d2, int n) {
            super(n);
            this.x = rectangle2D.getX();
            this.y = rectangle2D.getY();
            this.width = rectangle2D.getWidth();
            this.height = rectangle2D.getHeight();
            this.start = d;
            this.extent = d2;
        }

        @Override
        public double getX() {
            return this.x;
        }

        @Override
        public double getY() {
            return this.y;
        }

        @Override
        public double getWidth() {
            return this.width;
        }

        @Override
        public double getHeight() {
            return this.height;
        }

        @Override
        public double getAngleStart() {
            return this.start;
        }

        @Override
        public double getAngleExtent() {
            return this.extent;
        }

        @Override
        public boolean isEmpty() {
            return this.width <= 0.0 || this.height <= 0.0;
        }

        @Override
        public void setArc(double d, double d2, double d3, double d4, double d5, double d6, int n) {
            this.x = d;
            this.y = d2;
            this.width = d3;
            this.height = d4;
            this.start = d5;
            this.extent = d6;
            this.setArcType(n);
        }

        @Override
        public void setAngleStart(double d) {
            this.start = d;
        }

        @Override
        public void setAngleExtent(double d) {
            this.extent = d;
        }

        @Override
        protected Rectangle2D makeBounds(double d, double d2, double d3, double d4) {
            return new Rectangle2D.Double(d, d2, d3, d4);
        }
    }

    /*
     * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Float
    extends Arc2D {
        public float x;
        public float y;
        public float width;
        public float height;
        public float start;
        public float extent;

        public Float() {
            super(0);
        }

        public Float(int n) {
            super(n);
        }

        public Float(float f, float f2, float f3, float f4, float f5, float f6, int n) {
            super(n);
            this.x = f;
            this.y = f2;
            this.width = f3;
            this.height = f4;
            this.start = f5;
            this.extent = f6;
        }

        public Float(Rectangle2D rectangle2D, float f, float f2, int n) {
            super(n);
            this.x = (float)rectangle2D.getX();
            this.y = (float)rectangle2D.getY();
            this.width = (float)rectangle2D.getWidth();
            this.height = (float)rectangle2D.getHeight();
            this.start = f;
            this.extent = f2;
        }

        @Override
        public double getX() {
            return this.x;
        }

        @Override
        public double getY() {
            return this.y;
        }

        @Override
        public double getWidth() {
            return this.width;
        }

        @Override
        public double getHeight() {
            return this.height;
        }

        @Override
        public double getAngleStart() {
            return this.start;
        }

        @Override
        public double getAngleExtent() {
            return this.extent;
        }

        @Override
        public boolean isEmpty() {
            return this.width <= 0.0f || this.height <= 0.0f;
        }

        @Override
        public void setArc(double d, double d2, double d3, double d4, double d5, double d6, int n) {
            this.x = (float)d;
            this.y = (float)d2;
            this.width = (float)d3;
            this.height = (float)d4;
            this.start = (float)d5;
            this.extent = (float)d6;
            this.setArcType(n);
        }

        @Override
        public void setAngleStart(double d) {
            this.start = (float)d;
        }

        @Override
        public void setAngleExtent(double d) {
            this.extent = (float)d;
        }

        @Override
        protected Rectangle2D makeBounds(double d, double d2, double d3, double d4) {
            return new Rectangle2D.Float((float)d, (float)d2, (float)d3, (float)d4);
        }
    }
}

