/*
 * Decompiled with CFR 0.152.
 */
package java.awt.geom;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Point2D
implements Cloneable {
    protected Point2D() {
    }

    public abstract double getX();

    public abstract double getY();

    public abstract void setLocation(double var1, double var3);

    public void setLocation(Point2D point2D) {
        this.setLocation(point2D.getX(), point2D.getY());
    }

    public static double distanceSq(double d, double d2, double d3, double d4) {
        return (d3 -= d) * d3 + (d4 -= d2) * d4;
    }

    public static double distance(double d, double d2, double d3, double d4) {
        return Math.sqrt(Point2D.distanceSq(d, d2, d3, d4));
    }

    public double distanceSq(double d, double d2) {
        return Point2D.distanceSq(this.getX(), d, this.getY(), d2);
    }

    public double distanceSq(Point2D point2D) {
        return Point2D.distanceSq(this.getX(), point2D.getX(), this.getY(), point2D.getY());
    }

    public double distance(double d, double d2) {
        return Point2D.distance(this.getX(), d, this.getY(), d2);
    }

    public double distance(Point2D point2D) {
        return Point2D.distance(this.getX(), point2D.getX(), this.getY(), point2D.getY());
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw (Error)new InternalError().initCause(cloneNotSupportedException);
        }
    }

    public int hashCode() {
        long l = java.lang.Double.doubleToLongBits(this.getY());
        l = l * 31L ^ java.lang.Double.doubleToLongBits(this.getX());
        return (int)(l >> 32 ^ l);
    }

    public boolean equals(Object object) {
        if (!(object instanceof Point2D)) {
            return false;
        }
        Point2D point2D = (Point2D)object;
        return this.getX() == point2D.getX() && this.getY() == point2D.getY();
    }

    /*
     * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Double
    extends Point2D {
        public double x;
        public double y;

        public Double() {
        }

        public Double(double d, double d2) {
            this.x = d;
            this.y = d2;
        }

        @Override
        public double getX() {
            return this.x;
        }

        @Override
        public double getY() {
            return this.y;
        }

        @Override
        public void setLocation(double d, double d2) {
            this.x = d;
            this.y = d2;
        }

        public String toString() {
            return new StringBuffer().append("Point2D.Double[").append(this.x).append(", ").append(this.y).append(']').toString();
        }
    }

    /*
     * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Float
    extends Point2D {
        public float x;
        public float y;

        public Float() {
        }

        public Float(float f, float f2) {
            this.x = f;
            this.y = f2;
        }

        @Override
        public double getX() {
            return this.x;
        }

        @Override
        public double getY() {
            return this.y;
        }

        @Override
        public void setLocation(double d, double d2) {
            this.x = (float)d;
            this.y = (float)d2;
        }

        public void setLocation(float f, float f2) {
            this.x = f;
            this.y = f2;
        }

        public String toString() {
            return new StringBuffer().append("Point2D.Float[").append(this.x).append(", ").append(this.y).append(']').toString();
        }
    }
}

