/*
 * Decompiled with CFR 0.152.
 */
package java.beans;

import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IndexedPropertyDescriptor
extends PropertyDescriptor {
    private Method idxgetter;
    private Method idxsetter;
    private Class idxrettype;

    public IndexedPropertyDescriptor(String string, Class clazz) throws IntrospectionException {
        super(string, clazz);
        this.init(clazz);
        this.check();
    }

    public IndexedPropertyDescriptor(String string, Class clazz, String string2, String string3, String string4, String string5) throws IntrospectionException {
        super(string, clazz, string2, string3);
        this.init(clazz, string4, string5);
        this.check();
    }

    public IndexedPropertyDescriptor(String string, Method method, Method method2, Method method3, Method method4) throws IntrospectionException {
        super(string, method, method2);
        this.idxgetter = method3;
        this.idxsetter = method4;
        if (this.idxgetter != null) {
            this.idxrettype = this.idxgetter.getReturnType();
        } else if (this.idxsetter != null) {
            this.idxrettype = this.idxsetter.getParameterTypes()[1];
        }
        this.check();
    }

    private void check() throws IntrospectionException {
        this.checkGetter(this.getIndexedReadMethod());
        this.checkSetter(this.getIndexedWriteMethod());
        this.checkGetterAndSetterMatch(this.getIndexedReadMethod(), this.getIndexedWriteMethod());
    }

    private void checkGetterAndSetterMatch(Method method, Method method2) throws IntrospectionException {
        Class clazz = this.getIndexedPropertyType();
        if (method != null && method.getReturnType() != clazz || method2 != null && method2.getParameterTypes()[1] != clazz) {
            throw new IntrospectionException(new StringBuffer().append("Getter method ").append(method).append(" and setter method ").append(method2).append(" don't match.").toString());
        }
    }

    private void checkSetter(Method method) throws IntrospectionException {
        if (method != null) {
            if (method.getParameterTypes().length != 2) {
                throw new IntrospectionException(new StringBuffer().append("Setter method ").append(method).append(" must accept only two pararmeters.").toString());
            }
            if (method.getReturnType() != Void.TYPE) {
                throw new IntrospectionException(new StringBuffer().append("Setter method ").append(method).append(" must return void.").toString());
            }
        }
    }

    private void checkGetter(Method method) throws IntrospectionException {
        if (method != null) {
            if (method.getParameterTypes().length != 1) {
                throw new IntrospectionException(new StringBuffer().append("Getter method ").append(method).append(" must accept only one pararmeter.").toString());
            }
            if (method.getReturnType() == Void.TYPE) {
                throw new IntrospectionException(new StringBuffer().append("Getter method ").append(method).append(" must not return void.").toString());
            }
        }
    }

    public Class getIndexedPropertyType() {
        return this.idxrettype;
    }

    public Method getIndexedReadMethod() {
        return this.idxgetter;
    }

    public Method getIndexedWriteMethod() {
        return this.idxsetter;
    }

    private void init(Class clazz) throws IntrospectionException {
        this.init(clazz, this.getReadMethod().getName(), this.getWriteMethod().getName());
    }

    private void init(Class clazz, String string, String string2) throws IntrospectionException {
        Class[] classArray;
        NoSuchMethodException noSuchMethodException = null;
        try {
            classArray = new Class[]{Integer.TYPE};
            this.idxgetter = clazz.getMethod(string, classArray);
            this.idxrettype = this.idxgetter.getReturnType();
        }
        catch (NoSuchMethodException noSuchMethodException2) {
            noSuchMethodException = noSuchMethodException2;
        }
        try {
            classArray = new Class[]{Integer.TYPE, this.idxrettype};
            this.idxsetter = clazz.getMethod(string2, classArray);
        }
        catch (NoSuchMethodException noSuchMethodException3) {
            noSuchMethodException = noSuchMethodException3;
        }
        if (noSuchMethodException != null) {
            throw new IntrospectionException("failed");
        }
    }
}

