/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.IOException;
import java.io.Writer;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CharArrayWriter
extends Writer {
    private static final int DEFAULTBUFFERSIZE = 64;
    private static final int DEFAULTBUFFERSPILL = 64;
    protected char[] buf;
    protected int count;

    public CharArrayWriter() {
        this(64);
    }

    public CharArrayWriter(int n) {
        if (n < 0) {
            throw new IllegalArgumentException(new StringBuffer().append("Negative initial size : ").append(n).toString());
        }
        this.buf = new char[n];
    }

    @Override
    public void write(int n) {
        try {
            super.write(n);
            return;
        }
        catch (IOException iOException) {
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(char[] cArray, int n, int n2) {
        if (n2 < 0 || n < 0 || n + n2 > cArray.length) {
            throw new IndexOutOfBoundsException();
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.count + n2 > this.buf.length) {
                char[] cArray2 = this.buf;
                this.buf = new char[this.count + n2 + 64];
                System.arraycopy(cArray2, 0, this.buf, 0, this.count);
            }
            System.arraycopy(cArray, n, this.buf, this.count, n2);
            this.count += n2;
            return;
        }
    }

    @Override
    public void write(String string, int n, int n2) {
        this.write(string.toCharArray(), n, n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeTo(Writer writer) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            writer.write(this.buf, 0, this.count);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        Object object = this.lock;
        synchronized (object) {
            this.count = 0;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public char[] toCharArray() {
        Object object = this.lock;
        synchronized (object) {
            char[] cArray = new char[this.count];
            System.arraycopy(this.buf, 0, cArray, 0, this.count);
            return cArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        Object object = this.lock;
        synchronized (object) {
            return this.count;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        Object object = this.lock;
        synchronized (object) {
            return new String(this.buf, 0, this.count);
        }
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() {
    }
}

