/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.DataOutput;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UTFDataFormatException;
import kaffe.util.UTF8;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataOutputStream
extends FilterOutputStream
implements DataOutput {
    protected int written;

    public DataOutputStream(OutputStream outputStream) {
        super(outputStream);
    }

    @Override
    public void flush() throws IOException {
        super.flush();
    }

    public final int size() {
        return this.written;
    }

    @Override
    public synchronized void write(byte[] byArray, int n, int n2) throws IOException {
        if (n < 0 || n2 < 0 || n + n2 > byArray.length) {
            throw new IndexOutOfBoundsException();
        }
        super.write(byArray, n, n2);
        this.written += n2;
    }

    @Override
    public synchronized void write(int n) throws IOException {
        super.write(n);
        ++this.written;
    }

    @Override
    public final void writeBoolean(boolean bl) throws IOException {
        if (bl) {
            this.writeByte(1);
            return;
        }
        this.writeByte(0);
    }

    @Override
    public final void writeByte(int n) throws IOException {
        this.write(n);
    }

    @Override
    public final void writeBytes(String string) throws IOException {
        char[] cArray = string.toCharArray();
        byte[] byArray = new byte[cArray.length];
        int n = 0;
        while (n < cArray.length) {
            byArray[n] = (byte)(cArray[n] & 0xFF);
            ++n;
        }
        this.write(byArray, 0, byArray.length);
    }

    @Override
    public final void writeChar(int n) throws IOException {
        this.writeByte((n & 0xFF00) >> 8);
        this.writeByte(n & 0xFF);
    }

    @Override
    public final void writeChars(String string) throws IOException {
        int n = 0;
        while (n < string.length()) {
            this.writeChar(string.charAt(n));
            ++n;
        }
    }

    @Override
    public final void writeDouble(double d) throws IOException {
        this.writeLong(Double.doubleToLongBits(d));
    }

    @Override
    public final void writeFloat(float f) throws IOException {
        this.writeInt(Float.floatToIntBits(f));
    }

    @Override
    public final void writeInt(int n) throws IOException {
        byte[] byArray = new byte[4];
        int n2 = 0;
        int n3 = 24;
        while (n2 < 4) {
            byArray[n2] = (byte)(0xFF & n >> n3);
            ++n2;
            n3 -= 8;
        }
        this.write(byArray, 0, 4);
    }

    @Override
    public final void writeLong(long l) throws IOException {
        int n = (int)(l >> 32);
        int n2 = (int)(l & 0xFFFFFFFFFFFFFFFFL);
        this.writeInt(n);
        this.writeInt(n2);
    }

    @Override
    public final void writeShort(int n) throws IOException {
        this.writeChar(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void writeUTF(String string) throws IOException {
        byte[] byArray = UTF8.encode(string);
        if (byArray.length > 65535) {
            throw new UTFDataFormatException("String too long");
        }
        DataOutputStream dataOutputStream = this;
        synchronized (dataOutputStream) {
            this.writeShort(byArray.length);
            this.write(byArray, 0, byArray.length);
            return;
        }
    }
}

