/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.File;
import java.io.FileDescriptor;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileInputStream
extends InputStream {
    private FileDescriptor fd;

    public FileInputStream(FileDescriptor fileDescriptor) {
        this.Block$();
        if (fileDescriptor == null) {
            throw new NullPointerException();
        }
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkRead(fileDescriptor);
        }
        this.fd = fileDescriptor;
    }

    public FileInputStream(String string) throws FileNotFoundException {
        this(new File(string));
    }

    public FileInputStream(File file) throws FileNotFoundException {
        this.Block$();
        String string = file.getPath();
        if (file.isDirectory()) {
            throw new FileNotFoundException(new StringBuffer().append(string).append(": Is a directory").toString());
        }
        try {
            this.open(string);
            return;
        }
        catch (IOException iOException) {
            throw new FileNotFoundException(new StringBuffer().append(string).append(": ").append(iOException.getMessage()).toString());
        }
    }

    @Override
    public native int available() throws IOException;

    @Override
    public native void close() throws IOException;

    protected void finalize() throws IOException {
        this.close();
        try {
            super.finalize();
            return;
        }
        catch (Throwable throwable) {
            throw new IOException(throwable.getMessage());
        }
    }

    public final FileDescriptor getFD() throws IOException {
        return this.fd;
    }

    private native void open(String var1) throws IOException;

    @Override
    public native int read() throws IOException;

    @Override
    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (n < 0 || n2 < 0 || n + n2 > byArray.length) {
            throw new IndexOutOfBoundsException();
        }
        return this.readBytes(byArray, n, n2);
    }

    private native int readBytes(byte[] var1, int var2, int var3);

    @Override
    public native long skip(long var1) throws IOException;

    static {
        System.loadLibrary("io");
    }

    private /* synthetic */ void Block$() {
        this.fd = new FileDescriptor();
    }
}

