/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.File;
import java.io.FileDescriptor;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileOutputStream
extends OutputStream {
    private FileDescriptor fd;

    public FileOutputStream(FileDescriptor fileDescriptor) {
        this.Block$();
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkWrite(fileDescriptor);
        }
        this.fd = fileDescriptor;
    }

    public FileOutputStream(String string) throws FileNotFoundException {
        this(string, false);
    }

    public FileOutputStream(File file) throws FileNotFoundException {
        this(file, false);
    }

    public FileOutputStream(String string, boolean bl) throws FileNotFoundException {
        this(new File(string), bl);
    }

    public FileOutputStream(File file, boolean bl) throws FileNotFoundException {
        this.Block$();
        String string = file.getPath();
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkWrite(string);
        }
        try {
            if (!bl) {
                this.open(string);
                return;
            }
            this.openAppend(string);
            return;
        }
        catch (IOException iOException) {
            throw new FileNotFoundException(new StringBuffer().append(string).append(": ").append(iOException.getMessage()).toString());
        }
    }

    @Override
    public native void close() throws IOException;

    protected void finalize() throws IOException {
        this.close();
        try {
            super.finalize();
            return;
        }
        catch (Throwable throwable) {
            throw new IOException(throwable.getMessage());
        }
    }

    public final FileDescriptor getFD() throws IOException {
        return this.fd;
    }

    private native void open(String var1) throws IOException;

    private native void openAppend(String var1) throws IOException;

    @Override
    public void write(byte[] byArray) throws IOException {
        this.write(byArray, 0, byArray.length);
    }

    @Override
    public void write(byte[] byArray, int n, int n2) throws IOException {
        this.writeBytes(byArray, n, n2);
    }

    @Override
    public native void write(int var1) throws IOException;

    private native void writeBytes(byte[] var1, int var2, int var3);

    static {
        System.loadLibrary("io");
    }

    private /* synthetic */ void Block$() {
        this.fd = new FileDescriptor();
    }
}

