/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import kaffe.io.ByteToCharConverter;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InputStreamReader
extends Reader {
    private static final int BUFDEFAULT = 128;
    private ByteToCharConverter encoding;
    private InputStream strm;
    private byte[] inbuf;

    public InputStreamReader(InputStream inputStream) {
        super(inputStream);
        this.Block$();
        this.strm = inputStream;
        this.encoding = ByteToCharConverter.getDefault();
    }

    public InputStreamReader(InputStream inputStream, String string) throws UnsupportedEncodingException {
        super(inputStream);
        this.Block$();
        this.strm = inputStream;
        this.encoding = ByteToCharConverter.getConverter(string);
    }

    private void checkIfStillOpen() throws IOException {
        if (this.strm == null) {
            throw new IOException("Stream closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.strm != null) {
                this.strm.close();
                this.strm = null;
                this.inbuf = null;
                this.encoding = null;
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getEncoding() {
        Object object = this.lock;
        synchronized (object) {
            return this.encoding == null ? null : this.encoding.toString();
        }
    }

    @Override
    public int read() throws IOException {
        return super.read();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(char[] cArray, int n, int n2) throws IOException {
        if (n2 < 0 || n < 0 || n + n2 > cArray.length) {
            throw new IndexOutOfBoundsException();
        }
        int n3 = 0;
        boolean bl = false;
        Object object = this.lock;
        synchronized (object) {
            this.checkIfStillOpen();
            while (n2 > n3) {
                int n4;
                int n5 = n2 - n3;
                int n6 = this.encoding.withdraw(this.inbuf, 0, this.inbuf.length);
                int n7 = this.inbuf.length - n6;
                if (n5 > n7) {
                    n5 = n7;
                }
                if ((n4 = this.strm.read(this.inbuf, n6, n5)) < 0) {
                    n4 = 0;
                    bl = true;
                }
                n3 += this.encoding.convert(this.inbuf, 0, n6 + n4, cArray, n + n3, n2 - n3);
                if (n4 < n5 || !this.ready()) break;
            }
            if (bl && !this.encoding.havePending()) {
                return -1;
            }
            return n3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean ready() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.checkIfStillOpen();
            return this.encoding.havePending() || this.strm.available() > 0;
        }
    }

    private /* synthetic */ void Block$() {
        this.inbuf = new byte[128];
    }
}

