/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LineNumberInputStream
extends FilterInputStream {
    private int lineNo;
    private boolean skipNextLF;
    private int markLineNo;
    private boolean markSkipNextLF;

    public LineNumberInputStream(InputStream inputStream) {
        super(inputStream);
    }

    @Override
    public int available() throws IOException {
        int n = super.available();
        if (this.skipNextLF) {
            return Math.max(n - 1, 0);
        }
        return n;
    }

    public int getLineNumber() {
        return this.lineNo;
    }

    @Override
    public void mark(int n) {
        super.mark(n);
        this.markLineNo = this.lineNo;
        this.markSkipNextLF = this.skipNextLF;
    }

    @Override
    public int read() throws IOException {
        int n = super.read();
        if (this.skipNextLF) {
            this.skipNextLF = false;
            if (n == 10) {
                n = super.read();
            }
        }
        if (n == 13) {
            this.skipNextLF = true;
            n = 10;
        }
        if (n == 10) {
            ++this.lineNo;
        }
        return n;
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (n < 0 || n2 < 0 || n + n2 > byArray.length) {
            throw new IndexOutOfBoundsException();
        }
        int n3 = n + n2;
        int n4 = n;
        while (n4 < n3) {
            int n5 = this.read();
            if (n5 == -1) {
                if (n4 - n == 0) {
                    return -1;
                }
                return n4 - n;
            }
            byArray[n4] = (byte)n5;
            ++n4;
        }
        return n2;
    }

    @Override
    public void reset() throws IOException {
        super.reset();
        this.lineNo = this.markLineNo;
        this.skipNextLF = this.markSkipNextLF;
    }

    public void setLineNumber(int n) {
        this.lineNo = n;
    }

    @Override
    public long skip(long l) throws IOException {
        long l2 = 0L;
        while (l2 < l) {
            int n = this.read();
            if (n == -1) {
                if (l2 == 0L) {
                    return -1L;
                }
                return l2;
            }
            ++l2;
        }
        return l;
    }
}

