/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.IOException;
import java.io.PipedWriter;
import java.io.Reader;
import kaffe.io.CircularBuffer;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PipedReader
extends Reader {
    CircularBuffer buffer;
    private static final int PIPE_SIZE = 2048;

    public PipedReader() {
    }

    public PipedReader(PipedWriter pipedWriter) throws IOException {
        this.connect(pipedWriter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkIfConnected() throws IOException {
        PipedReader pipedReader = this;
        synchronized (pipedReader) {
            if (!this.isConnected()) {
                throw new IOException("Pipe not connected");
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connect(PipedWriter pipedWriter) throws IOException {
        PipedReader pipedReader = this;
        synchronized (pipedReader) {
            if (this.isConnected()) {
                throw new IOException("Already connected");
            }
            this.buffer = pipedWriter.buffer = new CircularBuffer(2048);
            return;
        }
    }

    private boolean isConnected() {
        return this.buffer != null;
    }

    @Override
    public int read() throws IOException {
        return super.read();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int read(char[] cArray, int n, int n2) throws IOException {
        this.checkIfConnected();
        CircularBuffer circularBuffer = this.buffer;
        synchronized (circularBuffer) {
            int n3;
            while ((n3 = this.buffer.read(cArray, n, n2)) == 0) {
                try {
                    this.buffer.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            this.buffer.notify();
            return n3;
        }
    }

    @Override
    public boolean ready() throws IOException {
        this.checkIfConnected();
        return this.buffer.isEmpty() ^ true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        CircularBuffer circularBuffer = this.buffer;
        synchronized (circularBuffer) {
            this.buffer.close();
            this.buffer.notifyAll();
            return;
        }
    }
}

