/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PrintWriter
extends Writer {
    private static final String newline = System.getProperty("line.separator");
    protected Writer out;
    private boolean flsh;
    private boolean error;

    public PrintWriter(Writer writer) {
        this(writer, false);
    }

    public PrintWriter(Writer writer, boolean bl) {
        super(writer);
        this.out = writer;
        this.flsh = bl;
    }

    public PrintWriter(OutputStream outputStream) {
        this(outputStream, false);
    }

    public PrintWriter(OutputStream outputStream, boolean bl) {
        this(new OutputStreamWriter(outputStream), bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() {
        Object object = this.lock;
        synchronized (object) {
            if (this.isStillOpen()) {
                try {
                    this.out.flush();
                }
                catch (IOException iOException) {
                    this.error = true;
                }
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Object object = this.lock;
        synchronized (object) {
            if (this.isStillOpen()) {
                try {
                    this.out.close();
                }
                catch (IOException iOException) {
                    this.error = true;
                }
                this.out = null;
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkError() {
        Object object = this.lock;
        synchronized (object) {
            this.flush();
            return this.error;
        }
    }

    private boolean isStillOpen() {
        return this.out != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setError() {
        Object object = this.lock;
        synchronized (object) {
            this.error = true;
            return;
        }
    }

    @Override
    public void write(int n) {
        try {
            super.write(n);
            return;
        }
        catch (IOException iOException) {
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(char[] cArray, int n, int n2) {
        if (n2 < 0 || n < 0 || n + n2 > cArray.length) {
            throw new IndexOutOfBoundsException();
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.isStillOpen()) {
                try {
                    this.out.write(cArray, n, n2);
                }
                catch (IOException iOException) {
                    this.setError();
                }
            }
            return;
        }
    }

    @Override
    public void write(char[] cArray) {
        this.write(cArray, 0, cArray.length);
    }

    @Override
    public void write(String string, int n, int n2) {
        this.write(string.toCharArray(), n, n2);
    }

    @Override
    public void write(String string) {
        this.write(string.toCharArray(), 0, string.length());
    }

    public void print(boolean bl) {
        this.write(String.valueOf(bl));
    }

    public void print(char c) {
        this.write(String.valueOf(c));
    }

    public void print(int n) {
        this.write(String.valueOf(n));
    }

    public void print(long l) {
        this.write(String.valueOf(l));
    }

    public void print(float f) {
        this.write(String.valueOf(f));
    }

    public void print(double d) {
        this.write(String.valueOf(d));
    }

    public void print(char[] cArray) {
        this.write(String.valueOf(cArray));
    }

    public void print(String string) {
        this.write(String.valueOf(string));
    }

    public void print(Object object) {
        this.print(String.valueOf(object));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println() {
        Object object = this.lock;
        synchronized (object) {
            this.write(newline);
            if (this.flsh) {
                this.flush();
            }
            return;
        }
    }

    public void println(boolean bl) {
        this.println(String.valueOf(bl));
    }

    public void println(char c) {
        this.println(String.valueOf(c));
    }

    public void println(int n) {
        this.println(String.valueOf(n));
    }

    public void println(long l) {
        this.println(String.valueOf(l));
    }

    public void println(float f) {
        this.println(String.valueOf(f));
    }

    public void println(double d) {
        this.println(String.valueOf(d));
    }

    public void println(char[] cArray) {
        this.println(String.valueOf(cArray));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println(String string) {
        Object object = this.lock;
        synchronized (object) {
            this.print(string);
            this.println();
            return;
        }
    }

    public void println(Object object) {
        this.println(String.valueOf(object));
    }
}

