/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PushbackInputStream
extends FilterInputStream {
    protected byte[] buf;
    protected int pos;
    private static final int DEFAULT_PUSHBACK_BUFFER_SIZE = 1;

    public PushbackInputStream(InputStream inputStream) {
        this(inputStream, 1);
    }

    public PushbackInputStream(InputStream inputStream, int n) {
        super(inputStream);
        if (n <= 0) {
            throw new IllegalArgumentException("size <= 0");
        }
        this.buf = new byte[n];
        this.pos = this.buf.length;
    }

    @Override
    public int available() throws IOException {
        return super.available() + (this.buf.length - this.pos);
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public int read() throws IOException {
        if (this.pos < this.buf.length) {
            return this.buf[this.pos++] & 0xFF;
        }
        return super.read();
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (n < 0 || n2 < 0 || n + n2 > byArray.length) {
            throw new IndexOutOfBoundsException();
        }
        int n3 = 0;
        while (this.pos < this.buf.length && n2 > 0) {
            byArray[n++] = this.buf[this.pos++];
            --n2;
            ++n3;
        }
        if (n2 > 0) {
            int n4 = super.read(byArray, n, n2);
            if (n4 == -1) {
                if (n3 == 0) {
                    return -1;
                }
            } else {
                n3 += n4;
            }
        }
        return n3;
    }

    public void unread(byte[] byArray) throws IOException {
        this.unread(byArray, 0, byArray.length);
    }

    public void unread(byte[] byArray, int n, int n2) throws IOException {
        if (n < 0 || n2 < 0 || n + n2 > byArray.length) {
            throw new IndexOutOfBoundsException();
        }
        if (this.pos < n2) {
            throw new IOException("pushback buffer is full");
        }
        this.pos -= n2;
        System.arraycopy(byArray, n, this.buf, this.pos, n2);
    }

    public void unread(int n) throws IOException {
        if (this.pos == 0) {
            throw new IOException("pushback buffer is full");
        }
        this.buf[this.pos += -1] = (byte)n;
    }
}

