/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.EOFException;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UTFDataFormatException;
import kaffe.util.UTF8;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RandomAccessFile
implements DataOutput,
DataInput {
    private final FileDescriptor fd;

    public RandomAccessFile(File file, String string) throws FileNotFoundException {
        this(file.getPath(), string);
    }

    public RandomAccessFile(String string, String string2) throws FileNotFoundException {
        boolean bl;
        this.Block$();
        if (string2.equalsIgnoreCase("r")) {
            bl = false;
        } else if (string2.equalsIgnoreCase("rw")) {
            bl = true;
        } else {
            throw new IllegalArgumentException();
        }
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkRead(string);
            if (bl) {
                securityManager.checkWrite(string);
            }
        }
        this.open(string, bl);
    }

    public native void close() throws IOException;

    public final FileDescriptor getFD() throws IOException {
        return this.fd;
    }

    public native long getFilePointer() throws IOException;

    public native long length() throws IOException;

    private native void open(String var1, boolean var2);

    public native int read() throws IOException;

    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3 = 0;
        while (n3 < n2) {
            int n4 = this.readBytes(byArray, n + n3, n2 - n3);
            if (n4 == -1) break;
            n3 += n4;
        }
        if (n2 > 0 && n3 == 0) {
            return -1;
        }
        return n3;
    }

    @Override
    public final boolean readBoolean() throws IOException {
        return this.readByte() == 0;
    }

    @Override
    public final byte readByte() throws IOException {
        int n = this.read();
        if (n == -1) {
            throw new EOFException();
        }
        return (byte)n;
    }

    private native int readBytes(byte[] var1, int var2, int var3);

    @Override
    public final char readChar() throws IOException {
        int n = this.readUnsignedByte();
        int n2 = this.readUnsignedByte();
        return (char)(n << 8 | n2);
    }

    @Override
    public final double readDouble() throws IOException {
        return Double.longBitsToDouble(this.readLong());
    }

    @Override
    public final float readFloat() throws IOException {
        return Float.intBitsToFloat(this.readInt());
    }

    @Override
    public final void readFully(byte[] byArray) throws IOException {
        this.readFully(byArray, 0, byArray.length);
    }

    @Override
    public final void readFully(byte[] byArray, int n, int n2) throws IOException {
        int n3 = this.read(byArray, n, n2);
        if (n3 != n2) {
            throw new EOFException();
        }
    }

    @Override
    public final int readInt() throws IOException {
        int n = this.readUnsignedByte();
        int n2 = this.readUnsignedByte();
        int n3 = this.readUnsignedByte();
        int n4 = this.readUnsignedByte();
        return n << 24 | (n2 << 16) + (n3 << 8) + n4;
    }

    @Override
    public final String readLine() throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (true) {
            int n2 = this.read();
            char c = (char)(n2 & 0xFF);
            if (n2 == -1) break;
            ++n;
            if (c == '\n') break;
            if (c == '\r') {
                int n3 = this.read();
                char c2 = (char)(n3 & 0xFF);
                if (n3 == -1 || c2 == '\n') break;
                this.seek(this.getFilePointer() - 1L);
                break;
            }
            stringBuffer.append(c);
        }
        if (n == 0) {
            return null;
        }
        return stringBuffer.toString();
    }

    @Override
    public final long readLong() throws IOException {
        int n = this.readInt();
        int n2 = this.readInt();
        return ((long)n << 32) + ((long)n2 & 0xFFFFFFFFL);
    }

    @Override
    public final short readShort() throws IOException {
        int n = this.readUnsignedByte();
        int n2 = this.readUnsignedByte();
        return (short)(n << 8 | n2);
    }

    @Override
    public final String readUTF() throws IOException {
        return UTF8.decode(this, this.readUnsignedShort());
    }

    @Override
    public final int readUnsignedByte() throws IOException {
        return this.readByte() & 0xFF;
    }

    @Override
    public final int readUnsignedShort() throws IOException {
        int n = this.readUnsignedByte();
        int n2 = this.readUnsignedByte();
        return n << 8 | n2;
    }

    public native void seek(long var1) throws IOException;

    @Override
    public int skipBytes(int n) throws IOException {
        long l = this.getFilePointer();
        this.seek(l + (long)n);
        return n;
    }

    @Override
    public void write(byte[] byArray) throws IOException {
        this.writeBytes(byArray, 0, byArray.length);
    }

    @Override
    public void write(byte[] byArray, int n, int n2) throws IOException {
        this.writeBytes(byArray, n, n2);
    }

    @Override
    public native void write(int var1) throws IOException;

    @Override
    public final void writeBoolean(boolean bl) throws IOException {
        if (bl) {
            this.writeByte(1);
            return;
        }
        this.writeByte(0);
    }

    @Override
    public final void writeByte(int n) throws IOException {
        this.write(n);
    }

    @Override
    public final void writeBytes(String string) throws IOException {
        char[] cArray = string.toCharArray();
        byte[] byArray = new byte[cArray.length];
        int n = 0;
        while (n < cArray.length) {
            byArray[n] = (byte)(cArray[n] & 0xFF);
            ++n;
        }
        this.write(byArray, 0, byArray.length);
    }

    private native void writeBytes(byte[] var1, int var2, int var3);

    @Override
    public final void writeChar(int n) throws IOException {
        this.writeByte((n & 0xFF00) >> 8);
        this.writeByte(n & 0xFF);
    }

    @Override
    public final void writeChars(String string) throws IOException {
        int n = 0;
        while (n < string.length()) {
            this.writeChar(string.charAt(n));
            ++n;
        }
    }

    @Override
    public final void writeDouble(double d) throws IOException {
        this.writeLong(Double.doubleToLongBits(d));
    }

    @Override
    public final void writeFloat(float f) throws IOException {
        this.writeInt(Float.floatToIntBits(f));
    }

    @Override
    public final void writeInt(int n) throws IOException {
        byte[] byArray = new byte[4];
        int n2 = 0;
        int n3 = 24;
        while (n2 < 4) {
            byArray[n2] = (byte)(0xFF & n >> n3);
            ++n2;
            n3 -= 8;
        }
        this.write(byArray, 0, 4);
    }

    @Override
    public final void writeLong(long l) throws IOException {
        int n = (int)(l >> 32);
        int n2 = (int)(l & 0xFFFFFFFFFFFFFFFFL);
        this.writeInt(n);
        this.writeInt(n2);
    }

    @Override
    public final void writeShort(int n) throws IOException {
        this.writeChar(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void writeUTF(String string) throws IOException {
        byte[] byArray = UTF8.encode(string);
        if (byArray.length > 65535) {
            throw new UTFDataFormatException("String too long");
        }
        RandomAccessFile randomAccessFile = this;
        synchronized (randomAccessFile) {
            this.writeShort(byArray.length);
            this.write(byArray, 0, byArray.length);
            return;
        }
    }

    static {
        System.loadLibrary("io");
    }

    private /* synthetic */ void Block$() {
        this.fd = new FileDescriptor();
    }
}

