/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Vector;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SequenceInputStream
extends InputStream {
    private Vector streams;
    private int currentStreamIdx;
    private InputStream currentStream;

    public SequenceInputStream(Enumeration enumeration) {
        this.Block$();
        while (enumeration.hasMoreElements()) {
            this.streams.addElement(enumeration.nextElement());
        }
        this.currentStream = (InputStream)this.streams.elementAt(0);
    }

    public SequenceInputStream(InputStream inputStream, InputStream inputStream2) {
        this.Block$();
        if (inputStream == null || inputStream2 == null) {
            throw new NullPointerException();
        }
        this.streams.addElement(inputStream);
        this.streams.addElement(inputStream2);
        this.currentStream = inputStream;
    }

    @Override
    public int available() throws IOException {
        if (this.currentStreamIdx >= this.streams.size()) {
            return 0;
        }
        return this.currentStream.available();
    }

    @Override
    public void close() throws IOException {
        int n = this.currentStreamIdx;
        while (n < this.streams.size()) {
            ((InputStream)this.streams.elementAt(n)).close();
            ++n;
        }
        this.currentStreamIdx = 0;
        this.currentStream = null;
        this.streams = new Vector();
    }

    @Override
    public int read() throws IOException {
        if (this.currentStreamIdx >= this.streams.size()) {
            return -1;
        }
        int n;
        while ((n = this.currentStream.read()) == -1) {
            this.currentStream.close();
            ++this.currentStreamIdx;
            if (this.currentStreamIdx >= this.streams.size()) {
                return -1;
            }
            this.currentStream = (InputStream)this.streams.elementAt(this.currentStreamIdx);
        }
        return n;
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (this.currentStreamIdx >= this.streams.size()) {
            return -1;
        }
        int n3;
        while ((n3 = this.currentStream.read(byArray, n, n2)) == -1) {
            this.currentStream.close();
            ++this.currentStreamIdx;
            if (this.currentStreamIdx >= this.streams.size()) {
                return -1;
            }
            this.currentStream = (InputStream)this.streams.elementAt(this.currentStreamIdx);
        }
        return n3;
    }

    private /* synthetic */ void Block$() {
        this.streams = new Vector();
    }
}

