/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PushbackReader;
import java.io.Reader;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StreamTokenizer {
    public static final int TT_EOF = -1;
    public static final int TT_EOL = 10;
    public static final int TT_NUMBER = -2;
    public static final int TT_WORD = -3;
    private static final int TT_INITIAL = -4;
    public int ttype;
    public String sval;
    public double nval;
    private PushbackReader pushIn;
    private BufferedReader bufferedIn;
    private Reader rawIn;
    private TableEntry[] lookup;
    private final TableEntry ordinary;
    private boolean pushBack;
    private boolean EOLSignificant;
    private boolean CComments;
    private boolean CPlusPlusComments;
    private boolean toLower;
    private final StringBuffer buffer;
    private boolean endOfFile;
    private int lineNumber;

    public StreamTokenizer(InputStream inputStream) {
        this(new InputStreamReader(inputStream));
    }

    public StreamTokenizer(Reader reader) {
        this.Block$();
        this.rawIn = reader;
        this.bufferedIn = new BufferedReader(this.rawIn);
        this.pushIn = new PushbackReader(this.bufferedIn);
        int n = 0;
        while (n < this.lookup.length) {
            this.lookup[n] = new TableEntry();
            ++n;
        }
        this.init();
    }

    private int chrRead() throws IOException {
        if (this.endOfFile) {
            return -1;
        }
        return this.pushIn.read();
    }

    private void unRead(int n) throws IOException {
        if (n == -1) {
            this.endOfFile = true;
            return;
        }
        this.pushIn.unread(n);
    }

    public void commentChar(int n) {
        if (n >= 0 && n <= 255) {
            this.lookup(n).isComment = true;
        }
    }

    public void eolIsSignificant(boolean bl) {
        this.EOLSignificant = bl;
    }

    public int lineno() {
        return this.lineNumber;
    }

    public void lowerCaseMode(boolean bl) {
        this.toLower = bl;
    }

    public int nextToken() throws IOException {
        if (this.pushBack) {
            this.pushBack = false;
        } else {
            this.nextTokenType();
        }
        return this.ttype;
    }

    private void nextTokenType() throws IOException {
        int n = this.chrRead();
        TableEntry tableEntry = this.lookup(n);
        if (tableEntry.isWhitespace) {
            this.parseWhitespaceChars(n);
            return;
        }
        if (tableEntry.isNumeric) {
            this.parseNumericChars(n);
            return;
        }
        if (tableEntry.isAlphabetic) {
            this.parseAlphabeticChars(n);
            return;
        }
        if (!(n == 47 && this.CPlusPlusComments && this.parseCPlusPlusCommentChars() || n == 47 && this.CComments && this.parseCCommentChars())) {
            if (tableEntry.isComment) {
                this.parseCommentChars();
                return;
            }
            if (tableEntry.isStringQuote) {
                this.parseStringQuoteChars(n);
                return;
            }
            this.sval = null;
            if (n == -1) {
                this.ttype = -1;
                return;
            }
            this.ttype = n;
        }
    }

    private boolean EOLParsed(int n) {
        return n == 13 || n == 10;
    }

    private void skipEOL(int n) throws IOException {
        if (n == 13 && (n = this.chrRead()) != 10) {
            this.unRead(n);
        }
    }

    private void parseWhitespaceChars(int n) throws IOException {
        do {
            if (!this.EOLParsed(n)) continue;
            ++this.lineNumber;
            this.skipEOL(n);
            if (!this.EOLSignificant) continue;
            this.ttype = 10;
            return;
        } while ((n = this.chrRead()) != -1 && this.lookup(n).isWhitespace);
        this.unRead(n);
        this.nextTokenType();
    }

    private void parseNumericChars(int n) throws IOException {
        boolean bl = false;
        this.buffer.setLength(0);
        do {
            if (n == 46) {
                if (bl) break;
                bl = true;
            }
            this.buffer.append((char)n);
        } while (this.lookup(n = this.chrRead()).isNumeric && n != 45 && (n != 46 || !bl));
        this.unRead(n);
        try {
            this.nval = Double.parseDouble(this.buffer.toString());
            this.ttype = -2;
            return;
        }
        catch (NumberFormatException numberFormatException) {
            if (this.buffer.toString().equals("-")) {
                this.ttype = 45;
                return;
            }
            if (this.buffer.toString().equals(".")) {
                this.ttype = -2;
                this.nval = 0.0;
                return;
            }
            this.ttype = -2;
            this.nval = 1.0609978955E-314;
            return;
        }
    }

    private void parseAlphabeticChars(int n) throws IOException {
        this.buffer.setLength(0);
        while (this.lookup(n).isAlphabetic || this.lookup(n).isNumeric) {
            this.buffer.append((char)n);
            n = this.chrRead();
        }
        this.unRead(n);
        this.ttype = -3;
        this.sval = this.buffer.toString();
        if (this.toLower) {
            this.sval = this.sval.toLowerCase();
        }
    }

    private void parseCommentChars() throws IOException {
        this.skipLine();
        this.nextTokenType();
    }

    private void parseStringQuoteChars(int n) throws IOException {
        int n2 = n;
        this.buffer.setLength(0);
        n = this.chrRead();
        while (n != n2 && !this.EOLParsed(n) && n != -1) {
            if (n == 92) {
                n = this.chrRead();
                switch (n) {
                    case 97: {
                        n = 7;
                        break;
                    }
                    case 98: {
                        n = 8;
                        break;
                    }
                    case 102: {
                        n = 12;
                        break;
                    }
                    case 110: {
                        n = 10;
                        break;
                    }
                    case 114: {
                        n = 13;
                        break;
                    }
                    case 116: {
                        n = 9;
                        break;
                    }
                    case 118: {
                        n = 11;
                        break;
                    }
                    default: {
                        if (48 > n || n > 55) break;
                        n = this.parseOctalEscape(n);
                    }
                }
            }
            this.buffer.append((char)n);
            n = this.chrRead();
        }
        if (this.EOLParsed(n)) {
            this.unRead(n);
        }
        this.ttype = n2;
        this.sval = this.buffer.toString();
    }

    private boolean parseCPlusPlusCommentChars() throws IOException {
        int n = this.chrRead();
        if (n == 47) {
            this.skipLine();
            this.nextTokenType();
            return true;
        }
        this.unRead(n);
        return false;
    }

    private boolean parseCCommentChars() throws IOException {
        int n = this.chrRead();
        if (n == 42) {
            this.skipCComment();
            this.nextTokenType();
            return true;
        }
        this.unRead(n);
        return false;
    }

    private int parseOctalEscape(int n) throws IOException {
        int n2 = 0;
        int n3 = 1;
        boolean bl = false;
        if (48 <= n && n <= 51) {
            bl = true;
        }
        do {
            n2 = n2 * 8 + Character.digit((char)n, 8);
        } while (48 <= (n = this.chrRead()) && n <= 55 && (++n3 <= 2 || bl) && n3 <= 3);
        this.unRead(n);
        return n2;
    }

    public void ordinaryChar(int n) {
        if (n >= 0 && n <= 255) {
            TableEntry tableEntry = this.lookup(n);
            tableEntry.isAlphabetic = false;
            tableEntry.isStringQuote = false;
            tableEntry.isNumeric = false;
            tableEntry.isComment = false;
            tableEntry.isWhitespace = false;
        }
    }

    public void ordinaryChars(int n, int n2) {
        if (n < 0) {
            n = 0;
        }
        if (n2 > 255) {
            n2 = 255;
        }
        int n3 = n;
        while (n3 <= n2) {
            this.ordinaryChar(n3);
            ++n3;
        }
    }

    public void parseNumbers() {
        int n = 48;
        while (n <= 57) {
            this.lookup(n).isNumeric = true;
            ++n;
        }
        this.lookup(46).isNumeric = true;
        this.lookup(45).isNumeric = true;
    }

    public void pushBack() {
        this.pushBack = true;
    }

    public void quoteChar(int n) {
        if (n >= 0 && n <= 255) {
            this.lookup(n).isStringQuote = true;
        }
    }

    private void init() {
        this.wordChars(65, 90);
        this.wordChars(97, 122);
        this.wordChars(160, 255);
        this.whitespaceChars(0, 32);
        this.parseNumbers();
        this.commentChar(47);
        this.quoteChar(39);
        this.quoteChar(34);
        this.EOLSignificant = false;
        this.CComments = false;
        this.CPlusPlusComments = false;
        this.toLower = false;
    }

    public void resetSyntax() {
        this.ordinaryChars(0, 255);
    }

    private void skipCComment() throws IOException {
        while (true) {
            int n;
            if (this.EOLParsed(n = this.chrRead())) {
                ++this.lineNumber;
                this.skipEOL(n);
                continue;
            }
            if (n == 42) {
                int n2 = this.chrRead();
                if (n2 == 47) {
                    return;
                }
                this.unRead(n2);
                continue;
            }
            if (n == -1) break;
        }
    }

    private void skipLine() throws IOException {
        int n = this.chrRead();
        while (!this.EOLParsed(n) && n != -1) {
            n = this.chrRead();
        }
        if (this.EOLParsed(n)) {
            this.unRead(n);
        }
    }

    public void slashSlashComments(boolean bl) {
        this.CPlusPlusComments = bl;
    }

    public void slashStarComments(boolean bl) {
        this.CComments = bl;
    }

    public String toString() {
        if (this.ttype == -1) {
            return new StringBuffer().append("Token[EOF], line ").append(this.lineno()).toString();
        }
        if (this.ttype == 10) {
            return new StringBuffer().append("Token[EOL], line ").append(this.lineno()).toString();
        }
        if (this.ttype == -2) {
            return new StringBuffer().append("Token[n=").append(this.nval).append("], line ").append(this.lineno()).toString();
        }
        if (this.ttype == -3 || this.lookup(this.ttype).isStringQuote) {
            return new StringBuffer().append("Token[").append(this.sval).append("], line ").append(this.lineno()).toString();
        }
        if (this.ttype == -4) {
            return new StringBuffer().append("Token[NOTHING], line ").append(this.lineno()).toString();
        }
        return new StringBuffer().append("Token['").append((char)this.ttype).append("'], line ").append(this.lineno()).toString();
    }

    public void whitespaceChars(int n, int n2) {
        if (n < 0) {
            n = 0;
        }
        if (n2 > 255) {
            n2 = 255;
        }
        int n3 = n;
        while (n3 <= n2) {
            TableEntry tableEntry = this.lookup(n3);
            tableEntry.isWhitespace = true;
            tableEntry.isAlphabetic = false;
            tableEntry.isNumeric = false;
            ++n3;
        }
    }

    public void wordChars(int n, int n2) {
        if (n < 0) {
            n = 0;
        }
        if (n2 > 255) {
            n2 = 255;
        }
        int n3 = n;
        while (n3 <= n2) {
            this.lookup(n3).isAlphabetic = true;
            ++n3;
        }
    }

    private TableEntry lookup(int n) {
        if (n < 0 || n > 255) {
            return this.ordinary;
        }
        return this.lookup[n];
    }

    private /* synthetic */ void Block$() {
        this.ttype = -4;
        this.lookup = new TableEntry[256];
        this.ordinary = new TableEntry();
        this.buffer = new StringBuffer();
        this.lineNumber = 1;
    }

    /*
     * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
     */
    class TableEntry {
        private boolean isNumeric;
        private boolean isWhitespace;
        private boolean isAlphabetic;
        private boolean isStringQuote;
        private boolean isComment;

        TableEntry() {
        }
    }
}

