/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.IOException;
import java.io.Writer;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringWriter
extends Writer {
    private static final int DEFAULT = 128;
    private StringBuffer buf;

    public StringWriter() {
        this(128);
    }

    public StringWriter(int n) {
        if (n < 0) {
            throw new IllegalArgumentException(new StringBuffer().append("Negative initial size: ").append(n).toString());
        }
        this.buf = new StringBuffer(n);
        this.lock = this.buf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(int n) {
        Object object = this.lock;
        synchronized (object) {
            this.buf.append((char)n);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(char[] cArray, int n, int n2) {
        if (n2 < 0 || n < 0 || n + n2 > cArray.length) {
            throw new IndexOutOfBoundsException();
        }
        Object object = this.lock;
        synchronized (object) {
            this.buf.append(cArray, n, n2);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(String string) {
        Object object = this.lock;
        synchronized (object) {
            this.buf.append(string);
            return;
        }
    }

    @Override
    public void write(String string, int n, int n2) {
        this.write(string.toCharArray(), n, n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        Object object = this.lock;
        synchronized (object) {
            return this.buf.toString();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StringBuffer getBuffer() {
        Object object = this.lock;
        synchronized (object) {
            return this.buf;
        }
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() throws IOException {
    }
}

