/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.StringTokenizer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import kaffe.util.IntegerHashtable;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Character
implements Serializable,
Comparable {
    public static final int MIN_RADIX = 2;
    public static final int MAX_RADIX = 36;
    public static final char MIN_VALUE = '\u0000';
    public static final char MAX_VALUE = '\uffff';
    public static final byte UNASSIGNED = 0;
    public static final byte UPPERCASE_LETTER = 1;
    public static final byte LOWERCASE_LETTER = 2;
    public static final byte TITLECASE_LETTER = 3;
    public static final byte MODIFIER_LETTER = 4;
    public static final byte OTHER_LETTER = 5;
    public static final byte NON_SPACING_MARK = 6;
    public static final byte ENCLOSING_MARK = 7;
    public static final byte COMBINING_SPACING_MARK = 8;
    public static final byte DECIMAL_DIGIT_NUMBER = 9;
    public static final byte LETTER_NUMBER = 10;
    public static final byte OTHER_NUMBER = 11;
    public static final byte SPACE_SEPARATOR = 12;
    public static final byte LINE_SEPARATOR = 13;
    public static final byte PARAGRAPH_SEPARATOR = 14;
    public static final byte CONTROL = 15;
    public static final byte FORMAT = 16;
    public static final byte PRIVATE_USE = 18;
    public static final byte SURROGATE = 19;
    public static final byte DASH_PUNCTUATION = 20;
    public static final byte START_PUNCTUATION = 21;
    public static final byte END_PUNCTUATION = 22;
    public static final byte CONNECTOR_PUNCTUATION = 23;
    public static final byte OTHER_PUNCTUATION = 24;
    public static final byte MATH_SYMBOL = 25;
    public static final byte CURRENCY_SYMBOL = 26;
    public static final byte MODIFIER_SYMBOL = 27;
    public static final byte OTHER_SYMBOL = 28;
    public static final Class TYPE = Class.getPrimitiveClass("char");
    private final char value;
    private static final long serialVersionUID = 3786198910865385080L;
    private static final char FULLWIDTH_LATIN_CAPITAL_LETTER_A = '\uff21';
    private static final char FULLWIDTH_LATIN_CAPITAL_LETTER_Z = '\uff3a';
    private static final char FULLWIDTH_LATIN_SMALL_LETTER_A = '\uff41';
    private static final char FULLWIDTH_LATIN_SMALL_LETTER_Z = '\uff5a';

    public Character(char c) {
        this.value = c;
    }

    public char charValue() {
        return this.value;
    }

    public int hashCode() {
        return this.value;
    }

    public boolean equals(Object object) {
        return object instanceof Character && ((Character)object).value == this.value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public int compareTo(Character c) {
        return this.value - c.value;
    }

    @Override
    public int compareTo(Object object) {
        return this.compareTo((Character)object);
    }

    public static boolean isSpace(char c) {
        switch (c) {
            case '\t': 
            case '\n': 
            case '\f': 
            case '\r': 
            case ' ': {
                return true;
            }
        }
        return false;
    }

    public static boolean isLetterOrDigit(char c) {
        return Character.isLetter(c) || Character.isDigit(c);
    }

    public static boolean isJavaLetter(char c) {
        return c == '$' || c == '_' || Character.isLetter(c);
    }

    public static boolean isJavaLetterOrDigit(char c) {
        return c == '$' || c == '_' || Character.isLetterOrDigit(c);
    }

    public static boolean isTitleCase(char c) {
        switch (Character.getType(c)) {
            case 3: {
                return true;
            }
        }
        return false;
    }

    public static boolean isDefined(char c) {
        return Character.getType(c) != 0;
    }

    public static boolean isIdentifierIgnorable(char c) {
        return c >= '\u0000' && c <= '\b' || c >= '\u000e' && c <= '\u001b' || c >= '\u007f' && c <= '\u009f' || c >= '\u200c' && c <= '\u200f' || c >= '\u202a' && c <= '\u202e' || c >= '\u206a' && c <= '\u206f' || c == '\ufeff';
    }

    public static boolean isLowerCase(char c) {
        switch (Character.getType(c)) {
            case 2: {
                return true;
            }
        }
        return false;
    }

    public static boolean isUpperCase(char c) {
        switch (Character.getType(c)) {
            case 1: {
                return true;
            }
        }
        return false;
    }

    public static boolean isDigit(char c) {
        return Character.getType(c) == 9;
    }

    public static boolean isLetter(char c) {
        switch (Character.getType(c)) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                return true;
            }
        }
        return false;
    }

    public static char toLowerCase(char c) {
        CharacterProperties characterProperties = Character.getCharProp(c);
        if (characterProperties.lower != '\u0000') {
            return characterProperties.lower;
        }
        return c;
    }

    public static char toUpperCase(char c) {
        CharacterProperties characterProperties = Character.getCharProp(c);
        if (characterProperties.upper != '\u0000') {
            return characterProperties.upper;
        }
        return c;
    }

    public static char toTitleCase(char c) {
        CharacterProperties characterProperties = Character.getCharProp(c);
        if (characterProperties.title != '\u0000') {
            return characterProperties.title;
        }
        return c;
    }

    public static int digit(char c, int n) {
        if (n < 2 || n > 36) {
            return -1;
        }
        int n2 = n;
        if (Character.isDigit(c)) {
            n2 = Character.getCharProp((char)c).numeric;
            if (n2 < 0) {
                return -1;
            }
        } else if ('A' <= c && c <= 'Z') {
            n2 = c - 55;
        } else if ('a' <= c && c <= 'z') {
            n2 = c - 87;
        } else if ('\uff21' <= c && c <= '\uff3a') {
            n2 = c - 65303;
        } else if ('\uff41' <= c && c <= '\uff5a') {
            n2 = c - 65335;
        }
        if (n2 < n) {
            return n2;
        }
        return -1;
    }

    public static char forDigit(int n, int n2) {
        if (n2 < 2 || n2 > 36) {
            return '\u0000';
        }
        if (n < 0 || n >= n2) {
            return '\u0000';
        }
        if (n < 10) {
            return (char)(48 + n);
        }
        return (char)(97 + (n - 10));
    }

    public static int getNumericValue(char c) {
        short s = Character.getCharProp((char)c).numeric;
        if (s == -1) {
            return Character.digit(c, 36);
        }
        return s;
    }

    public static int getType(char c) {
        return Character.getCharProp((char)c).category;
    }

    public static boolean isISOControl(char c) {
        if (c < ' ') {
            return true;
        }
        if (c < '\u007f') {
            return false;
        }
        return c < '\u00a0';
    }

    public static boolean isJavaIdentifierPart(char c) {
        switch (Character.getType(c)) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 23: 
            case 26: {
                return true;
            }
        }
        return Character.isIdentifierIgnorable(c);
    }

    public static boolean isJavaIdentifierStart(char c) {
        switch (Character.getType(c)) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 23: 
            case 26: {
                return true;
            }
        }
        return false;
    }

    public static boolean isSpaceChar(char c) {
        switch (Character.getType(c)) {
            case 12: 
            case 13: 
            case 14: {
                return true;
            }
        }
        return false;
    }

    public static boolean isUnicodeIdentifierPart(char c) {
        switch (Character.getType(c)) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 23: {
                return true;
            }
        }
        return Character.isIdentifierIgnorable(c);
    }

    public static boolean isUnicodeIdentifierStart(char c) {
        return Character.isLetter(c);
    }

    public static boolean isWhitespace(char c) {
        switch (c) {
            case '\t': 
            case '\n': 
            case '\u000b': 
            case '\f': 
            case '\r': 
            case '\u001c': 
            case '\u001d': 
            case '\u001e': 
            case '\u001f': {
                return true;
            }
        }
        switch (Character.getType(c)) {
            case 12: {
                return Character.getCharProp((char)c).noBreak ^ true;
            }
            case 13: 
            case 14: {
                return true;
            }
        }
        return false;
    }

    private static CharacterProperties getCharProp(char c) {
        CharacterProperties characterProperties = (CharacterProperties)CharacterProperties.cache.get(c);
        if (characterProperties != null) {
            return characterProperties;
        }
        int n = CharacterProperties.getIndex(c);
        characterProperties = n < 0 ? new CharacterProperties(c, 0, false, -1, '\u0000', '\u0000', '\u0000') : CharacterProperties.decodeProp(c, n);
        return characterProperties;
    }

    /*
     * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Subset {
        private final String name;

        protected Subset(String string) {
            this.name = string.toString();
        }

        public final boolean equals(Object object) {
            return object == this;
        }

        public final int hashCode() {
            return super.hashCode();
        }

        public final String toString() {
            return this.name;
        }
    }

    /*
     * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class UnicodeBlock
    extends Subset {
        private final char start;
        private final char end;
        public static final UnicodeBlock BASIC_LATIN = new UnicodeBlock('\u0000', '\u007f', "BASIC_LATIN");
        public static final UnicodeBlock LATIN_1_SUPPLEMENT = new UnicodeBlock('\u0080', '\u00ff', "LATIN_1_SUPPLEMENT");
        public static final UnicodeBlock LATIN_EXTENDED_A = new UnicodeBlock('\u0100', '\u017f', "LATIN_EXTENDED_A");
        public static final UnicodeBlock LATIN_EXTENDED_B = new UnicodeBlock('\u0180', '\u024f', "LATIN_EXTENDED_B");
        public static final UnicodeBlock IPA_EXTENSIONS = new UnicodeBlock('\u0250', '\u02af', "IPA_EXTENSIONS");
        public static final UnicodeBlock SPACING_MODIFIER_LETTERS = new UnicodeBlock('\u02b0', '\u02ff', "SPACING_MODIFIER_LETTERS");
        public static final UnicodeBlock COMBINING_DIACRITICAL_MARKS = new UnicodeBlock('\u0300', '\u036f', "COMBINING_DIACRITICAL_MARKS");
        public static final UnicodeBlock GREEK = new UnicodeBlock('\u0370', '\u03ff', "GREEK");
        public static final UnicodeBlock CYRILLIC = new UnicodeBlock('\u0400', '\u04ff', "CYRILLIC");
        public static final UnicodeBlock ARMENIAN = new UnicodeBlock('\u0530', '\u058f', "ARMENIAN");
        public static final UnicodeBlock HEBREW = new UnicodeBlock('\u0590', '\u05ff', "HEBREW");
        public static final UnicodeBlock ARABIC = new UnicodeBlock('\u0600', '\u06ff', "ARABIC");
        public static final UnicodeBlock SYRIAC = new UnicodeBlock('\u0700', '\u074f', "SYRIAC");
        public static final UnicodeBlock THAANA = new UnicodeBlock('\u0780', '\u07bf', "THAANA");
        public static final UnicodeBlock DEVANAGARI = new UnicodeBlock('\u0900', '\u097f', "DEVANAGARI");
        public static final UnicodeBlock BENGALI = new UnicodeBlock('\u0980', '\u09ff', "BENGALI");
        public static final UnicodeBlock GURMUKHI = new UnicodeBlock('\u0a00', '\u0a7f', "GURMUKHI");
        public static final UnicodeBlock GUJARATI = new UnicodeBlock('\u0a80', '\u0aff', "GUJARATI");
        public static final UnicodeBlock ORIYA = new UnicodeBlock('\u0b00', '\u0b7f', "ORIYA");
        public static final UnicodeBlock TAMIL = new UnicodeBlock('\u0b80', '\u0bff', "TAMIL");
        public static final UnicodeBlock TELUGU = new UnicodeBlock('\u0c00', '\u0c7f', "TELUGU");
        public static final UnicodeBlock KANNADA = new UnicodeBlock('\u0c80', '\u0cff', "KANNADA");
        public static final UnicodeBlock MALAYALAM = new UnicodeBlock('\u0d00', '\u0d7f', "MALAYALAM");
        public static final UnicodeBlock SINHALA = new UnicodeBlock('\u0d80', '\u0dff', "SINHALA");
        public static final UnicodeBlock THAI = new UnicodeBlock('\u0e00', '\u0e7f', "THAI");
        public static final UnicodeBlock LAO = new UnicodeBlock('\u0e80', '\u0eff', "LAO");
        public static final UnicodeBlock TIBETAN = new UnicodeBlock('\u0f00', '\u0fff', "TIBETAN");
        public static final UnicodeBlock MYANMAR = new UnicodeBlock('\u1000', '\u109f', "MYANMAR");
        public static final UnicodeBlock GEORGIAN = new UnicodeBlock('\u10a0', '\u10ff', "GEORGIAN");
        public static final UnicodeBlock HANGUL_JAMO = new UnicodeBlock('\u1100', '\u11ff', "HANGUL_JAMO");
        public static final UnicodeBlock ETHIOPIC = new UnicodeBlock('\u1200', '\u137f', "ETHIOPIC");
        public static final UnicodeBlock CHEROKEE = new UnicodeBlock('\u13a0', '\u13ff', "CHEROKEE");
        public static final UnicodeBlock UNIFIED_CANADIAN_ABORIGINAL_SYLLABICS = new UnicodeBlock('\u1400', '\u167f', "UNIFIED_CANADIAN_ABORIGINAL_SYLLABICS");
        public static final UnicodeBlock OGHAM = new UnicodeBlock('\u1680', '\u169f', "OGHAM");
        public static final UnicodeBlock RUNIC = new UnicodeBlock('\u16a0', '\u16ff', "RUNIC");
        public static final UnicodeBlock KHMER = new UnicodeBlock('\u1780', '\u17ff', "KHMER");
        public static final UnicodeBlock MONGOLIAN = new UnicodeBlock('\u1800', '\u18af', "MONGOLIAN");
        public static final UnicodeBlock LATIN_EXTENDED_ADDITIONAL = new UnicodeBlock('\u1e00', '\u1eff', "LATIN_EXTENDED_ADDITIONAL");
        public static final UnicodeBlock GREEK_EXTENDED = new UnicodeBlock('\u1f00', '\u1fff', "GREEK_EXTENDED");
        public static final UnicodeBlock GENERAL_PUNCTUATION = new UnicodeBlock('\u2000', '\u206f', "GENERAL_PUNCTUATION");
        public static final UnicodeBlock SUPERSCRIPTS_AND_SUBSCRIPTS = new UnicodeBlock('\u2070', '\u209f', "SUPERSCRIPTS_AND_SUBSCRIPTS");
        public static final UnicodeBlock CURRENCY_SYMBOLS = new UnicodeBlock('\u20a0', '\u20cf', "CURRENCY_SYMBOLS");
        public static final UnicodeBlock COMBINING_MARKS_FOR_SYMBOLS = new UnicodeBlock('\u20d0', '\u20ff', "COMBINING_MARKS_FOR_SYMBOLS");
        public static final UnicodeBlock LETTERLIKE_SYMBOLS = new UnicodeBlock('\u2100', '\u214f', "LETTERLIKE_SYMBOLS");
        public static final UnicodeBlock NUMBER_FORMS = new UnicodeBlock('\u2150', '\u218f', "NUMBER_FORMS");
        public static final UnicodeBlock ARROWS = new UnicodeBlock('\u2190', '\u21ff', "ARROWS");
        public static final UnicodeBlock MATHEMATICAL_OPERATORS = new UnicodeBlock('\u2200', '\u22ff', "MATHEMATICAL_OPERATORS");
        public static final UnicodeBlock MISCELLANEOUS_TECHNICAL = new UnicodeBlock('\u2300', '\u23ff', "MISCELLANEOUS_TECHNICAL");
        public static final UnicodeBlock CONTROL_PICTURES = new UnicodeBlock('\u2400', '\u243f', "CONTROL_PICTURES");
        public static final UnicodeBlock OPTICAL_CHARACTER_RECOGNITION = new UnicodeBlock('\u2440', '\u245f', "OPTICAL_CHARACTER_RECOGNITION");
        public static final UnicodeBlock ENCLOSED_ALPHANUMERICS = new UnicodeBlock('\u2460', '\u24ff', "ENCLOSED_ALPHANUMERICS");
        public static final UnicodeBlock BOX_DRAWING = new UnicodeBlock('\u2500', '\u257f', "BOX_DRAWING");
        public static final UnicodeBlock BLOCK_ELEMENTS = new UnicodeBlock('\u2580', '\u259f', "BLOCK_ELEMENTS");
        public static final UnicodeBlock GEOMETRIC_SHAPES = new UnicodeBlock('\u25a0', '\u25ff', "GEOMETRIC_SHAPES");
        public static final UnicodeBlock MISCELLANEOUS_SYMBOLS = new UnicodeBlock('\u2600', '\u26ff', "MISCELLANEOUS_SYMBOLS");
        public static final UnicodeBlock DINGBATS = new UnicodeBlock('\u2700', '\u27bf', "DINGBATS");
        public static final UnicodeBlock BRAILLE_PATTERNS = new UnicodeBlock('\u2800', '\u28ff', "BRAILLE_PATTERNS");
        public static final UnicodeBlock CJK_RADICALS_SUPPLEMENT = new UnicodeBlock('\u2e80', '\u2eff', "CJK_RADICALS_SUPPLEMENT");
        public static final UnicodeBlock KANGXI_RADICALS = new UnicodeBlock('\u2f00', '\u2fdf', "KANGXI_RADICALS");
        public static final UnicodeBlock IDEOGRAPHIC_DESCRIPTION_CHARACTERS = new UnicodeBlock('\u2ff0', '\u2fff', "IDEOGRAPHIC_DESCRIPTION_CHARACTERS");
        public static final UnicodeBlock CJK_SYMBOLS_AND_PUNCTUATION = new UnicodeBlock('\u3000', '\u303f', "CJK_SYMBOLS_AND_PUNCTUATION");
        public static final UnicodeBlock HIRAGANA = new UnicodeBlock('\u3040', '\u309f', "HIRAGANA");
        public static final UnicodeBlock KATAKANA = new UnicodeBlock('\u30a0', '\u30ff', "KATAKANA");
        public static final UnicodeBlock BOPOMOFO = new UnicodeBlock('\u3100', '\u312f', "BOPOMOFO");
        public static final UnicodeBlock HANGUL_COMPATIBILITY_JAMO = new UnicodeBlock('\u3130', '\u318f', "HANGUL_COMPATIBILITY_JAMO");
        public static final UnicodeBlock KANBUN = new UnicodeBlock('\u3190', '\u319f', "KANBUN");
        public static final UnicodeBlock BOPOMOFO_EXTENDED = new UnicodeBlock('\u31a0', '\u31bf', "BOPOMOFO_EXTENDED");
        public static final UnicodeBlock ENCLOSED_CJK_LETTERS_AND_MONTHS = new UnicodeBlock('\u3200', '\u32ff', "ENCLOSED_CJK_LETTERS_AND_MONTHS");
        public static final UnicodeBlock CJK_COMPATIBILITY = new UnicodeBlock('\u3300', '\u33ff', "CJK_COMPATIBILITY");
        public static final UnicodeBlock CJK_UNIFIED_IDEOGRAPHS_EXTENSION_A = new UnicodeBlock('\u3400', '\u4db5', "CJK_UNIFIED_IDEOGRAPHS_EXTENSION_A");
        public static final UnicodeBlock CJK_UNIFIED_IDEOGRAPHS = new UnicodeBlock('\u4e00', '\u9fff', "CJK_UNIFIED_IDEOGRAPHS");
        public static final UnicodeBlock YI_SYLLABLES = new UnicodeBlock('\ua000', '\ua48f', "YI_SYLLABLES");
        public static final UnicodeBlock YI_RADICALS = new UnicodeBlock('\ua490', '\ua4cf', "YI_RADICALS");
        public static final UnicodeBlock HANGUL_SYLLABLES = new UnicodeBlock('\uac00', '\ud7a3', "HANGUL_SYLLABLES");
        public static final UnicodeBlock SURROGATES_AREA = new UnicodeBlock('\ud800', '\udfff', "SURROGATES_AREA");
        public static final UnicodeBlock PRIVATE_USE_AREA = new UnicodeBlock('\ue000', '\uf8ff', "PRIVATE_USE_AREA");
        public static final UnicodeBlock CJK_COMPATIBILITY_IDEOGRAPHS = new UnicodeBlock('\uf900', '\ufaff', "CJK_COMPATIBILITY_IDEOGRAPHS");
        public static final UnicodeBlock ALPHABETIC_PRESENTATION_FORMS = new UnicodeBlock('\ufb00', '\ufb4f', "ALPHABETIC_PRESENTATION_FORMS");
        public static final UnicodeBlock ARABIC_PRESENTATION_FORMS_A = new UnicodeBlock('\ufb50', '\ufdff', "ARABIC_PRESENTATION_FORMS_A");
        public static final UnicodeBlock COMBINING_HALF_MARKS = new UnicodeBlock('\ufe20', '\ufe2f', "COMBINING_HALF_MARKS");
        public static final UnicodeBlock CJK_COMPATIBILITY_FORMS = new UnicodeBlock('\ufe30', '\ufe4f', "CJK_COMPATIBILITY_FORMS");
        public static final UnicodeBlock SMALL_FORM_VARIANTS = new UnicodeBlock('\ufe50', '\ufe6f', "SMALL_FORM_VARIANTS");
        public static final UnicodeBlock ARABIC_PRESENTATION_FORMS_B = new UnicodeBlock('\ufe70', '\ufefe', "ARABIC_PRESENTATION_FORMS_B");
        public static final UnicodeBlock HALFWIDTH_AND_FULLWIDTH_FORMS = new UnicodeBlock('\uff00', '\uffef', "HALFWIDTH_AND_FULLWIDTH_FORMS");
        public static final UnicodeBlock SPECIALS = new UnicodeBlock('\ufff0', '\ufffd', "SPECIALS");
        private static final UnicodeBlock[] sets = new UnicodeBlock[]{BASIC_LATIN, LATIN_1_SUPPLEMENT, LATIN_EXTENDED_A, LATIN_EXTENDED_B, IPA_EXTENSIONS, SPACING_MODIFIER_LETTERS, COMBINING_DIACRITICAL_MARKS, GREEK, CYRILLIC, ARMENIAN, HEBREW, ARABIC, SYRIAC, THAANA, DEVANAGARI, BENGALI, GURMUKHI, GUJARATI, ORIYA, TAMIL, TELUGU, KANNADA, MALAYALAM, SINHALA, THAI, LAO, TIBETAN, MYANMAR, GEORGIAN, HANGUL_JAMO, ETHIOPIC, CHEROKEE, UNIFIED_CANADIAN_ABORIGINAL_SYLLABICS, OGHAM, RUNIC, KHMER, MONGOLIAN, LATIN_EXTENDED_ADDITIONAL, GREEK_EXTENDED, GENERAL_PUNCTUATION, SUPERSCRIPTS_AND_SUBSCRIPTS, CURRENCY_SYMBOLS, COMBINING_MARKS_FOR_SYMBOLS, LETTERLIKE_SYMBOLS, NUMBER_FORMS, ARROWS, MATHEMATICAL_OPERATORS, MISCELLANEOUS_TECHNICAL, CONTROL_PICTURES, OPTICAL_CHARACTER_RECOGNITION, ENCLOSED_ALPHANUMERICS, BOX_DRAWING, BLOCK_ELEMENTS, GEOMETRIC_SHAPES, MISCELLANEOUS_SYMBOLS, DINGBATS, BRAILLE_PATTERNS, CJK_RADICALS_SUPPLEMENT, KANGXI_RADICALS, IDEOGRAPHIC_DESCRIPTION_CHARACTERS, CJK_SYMBOLS_AND_PUNCTUATION, HIRAGANA, KATAKANA, BOPOMOFO, HANGUL_COMPATIBILITY_JAMO, KANBUN, BOPOMOFO_EXTENDED, ENCLOSED_CJK_LETTERS_AND_MONTHS, CJK_COMPATIBILITY, CJK_UNIFIED_IDEOGRAPHS_EXTENSION_A, CJK_UNIFIED_IDEOGRAPHS, YI_SYLLABLES, YI_RADICALS, HANGUL_SYLLABLES, SURROGATES_AREA, PRIVATE_USE_AREA, CJK_COMPATIBILITY_IDEOGRAPHS, ALPHABETIC_PRESENTATION_FORMS, ARABIC_PRESENTATION_FORMS_A, COMBINING_HALF_MARKS, CJK_COMPATIBILITY_FORMS, SMALL_FORM_VARIANTS, ARABIC_PRESENTATION_FORMS_B, HALFWIDTH_AND_FULLWIDTH_FORMS, SPECIALS};

        private UnicodeBlock(char c, char c2, String string) {
            super(string);
            this.start = c;
            this.end = c2;
        }

        public static UnicodeBlock of(char c) {
            if (c == '\ufeff') {
                return SPECIALS;
            }
            int n = 0;
            int n2 = sets.length - 1;
            while (n <= n2) {
                int n3 = n + n2 >> 1;
                UnicodeBlock unicodeBlock = sets[n3];
                if (c < unicodeBlock.start) {
                    n2 = n3 - 1;
                    continue;
                }
                if (c > unicodeBlock.end) {
                    n = n3 + 1;
                    continue;
                }
                return unicodeBlock;
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CharacterProperties {
        char unicode;
        int category;
        boolean noBreak;
        short numeric;
        char upper;
        char lower;
        char title;
        static IntegerHashtable cache;
        private static byte[] propTable;
        private static char[] rangeStart;
        private static char[] rangeEnd;
        private static int[] rangeOffset;

        CharacterProperties(char c, int n, boolean bl, short s, char c2, char c3, char c4) {
            this.unicode = c;
            this.category = n;
            this.noBreak = bl;
            this.numeric = s;
            this.upper = c2;
            this.lower = c3;
            this.title = c4;
            cache.put(c, this);
        }

        private static byte[] getResource(String string) throws IOException {
            int n;
            Object object;
            Object object2;
            String string2 = System.getProperties().getProperty("path.separator");
            String string3 = System.getProperties().getProperty("java.class.path");
            StringTokenizer stringTokenizer = new StringTokenizer(string3, string2);
            InputStream inputStream = null;
            while (stringTokenizer.hasMoreTokens()) {
                try {
                    object2 = new ZipFile(stringTokenizer.nextToken());
                    if (object2 == null || (object = (Object)((ZipFile)object2).getEntry(string)) == null) continue;
                    inputStream = ((ZipFile)object2).getInputStream((ZipEntry)object);
                    break;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (inputStream == null) {
                throw new IOException("not found");
            }
            object2 = new ByteArrayOutputStream(5000);
            object = new byte[1024];
            while ((n = inputStream.read((byte[])object)) != -1) {
                ((ByteArrayOutputStream)object2).write((byte[])object, 0, n);
            }
            return ((ByteArrayOutputStream)object2).toByteArray();
        }

        private static int getIndex(char c) {
            char[] cArray = rangeStart;
            char[] cArray2 = rangeEnd;
            int n = 0;
            int n2 = cArray.length - 1;
            while (n <= n2) {
                int n3 = n + n2 >> 1;
                if (c < cArray[n3]) {
                    n2 = n3 - 1;
                    continue;
                }
                if (c > cArray2[n3]) {
                    n = n3 + 1;
                    continue;
                }
                return n3;
            }
            return -1;
        }

        private static CharacterProperties decodeProp(char c, int n) {
            byte[] byArray = propTable;
            byte by = (byte)(rangeOffset[n] >> 20 & 3);
            int n2 = rangeOffset[n] & 0xFFFFF;
            if (by == 0) {
                n2 += 3 * (c - rangeStart[n]);
            } else if (by == 3) {
                n2 += 9 * (c - rangeStart[n]);
            }
            boolean bl = false;
            int n3 = byArray[n2] & 0x1F;
            if (n3 == 31) {
                n3 = 12;
                bl = true;
            }
            if (by < 3) {
                char c2 = (char)(((byArray[n2 + 1] & 0xFF) << 8) + (byArray[n2 + 2] & 0xFF));
                if (by == 2) {
                    c2 = (char)(c2 + (short)(0xFFFF & c - rangeStart[n]));
                }
                switch (byArray[n2] >> 5 & 3) {
                    case 0: {
                        return new CharacterProperties(c, n3, bl, -1, '\u0000', '\u0000', '\u0000');
                    }
                    case 1: {
                        return new CharacterProperties(c, n3, bl, -1, c2, '\u0000', c2);
                    }
                    case 2: {
                        return new CharacterProperties(c, n3, bl, -1, '\u0000', c2, '\u0000');
                    }
                }
                return new CharacterProperties(c, n3, bl, (short)c2, '\u0000', '\u0000', '\u0000');
            }
            short s = (short)(((byArray[n2 + 1] & 0xFF) << 8) + (byArray[n2 + 2] & 0xFF));
            char c3 = (char)(((byArray[n2 + 3] & 0xFF) << 8) + (byArray[n2 + 4] & 0xFF));
            char c4 = (char)(((byArray[n2 + 5] & 0xFF) << 8) + (byArray[n2 + 6] & 0xFF));
            char c5 = (char)(((byArray[n2 + 7] & 0xFF) << 8) + (byArray[n2 + 8] & 0xFF));
            return new CharacterProperties(c, n3, bl, s, c3, c4, c5);
        }

        static {
            byte[] byArray;
            cache = new IntegerHashtable();
            try {
                propTable = CharacterProperties.getResource("kaffe/lang/unicode.tbl");
            }
            catch (IOException iOException) {
                throw new Error(new StringBuffer().append("Missing Kaffe Unicode Database table: ").append(iOException).toString());
            }
            try {
                byArray = CharacterProperties.getResource("kaffe/lang/unicode.idx");
            }
            catch (IOException iOException) {
                throw new Error(new StringBuffer().append("Missing Kaffe Unicode Database index: ").append(iOException).toString());
            }
            if (byArray.length % 7 != 0) {
                throw new Error("Corrupted Kaffe Unicode Database");
            }
            int n = byArray.length / 7;
            rangeStart = new char[n];
            rangeEnd = new char[n];
            rangeOffset = new int[n];
            int n2 = 0;
            int n3 = 0;
            while (n2 < n) {
                CharacterProperties.rangeStart[n2] = (char)(((byArray[n3] & 0xFF) << 8) + (byArray[n3 + 1] & 0xFF));
                CharacterProperties.rangeEnd[n2] = (char)(((byArray[n3 + 2] & 0xFF) << 8) + (byArray[n3 + 3] & 0xFF));
                CharacterProperties.rangeOffset[n2] = ((byArray[n3 + 4] & 0xFF) << 16) + ((byArray[n3 + 5] & 0xFF) << 8) + (byArray[n3 + 6] & 0xFF);
                ++n2;
                n3 += 7;
            }
        }
    }
}

