/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.security.ProtectionDomain;
import java.util.Vector;
import kaffe.lang.PackageHelper;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Class
implements Serializable {
    private Class() {
    }

    public static Class forName(String string) throws ClassNotFoundException {
        return Class.forName(string, true, null);
    }

    public static Class forName(String string, boolean bl, ClassLoader classLoader) throws ClassNotFoundException {
        Class clazz;
        if (string.indexOf(47) != -1) {
            throw new ClassNotFoundException("Cannot have slashes - use dots instead.");
        }
        if (classLoader == null && (classLoader = CallStack.getCallersClassLoader()) == null) {
            classLoader = ClassLoader.getSystemClassLoader();
        }
        if ((clazz = classLoader.findLoadedClass(string)) == null) {
            clazz = classLoader.loadClass(string, bl);
        }
        return clazz;
    }

    private String fullResourceName(String string) {
        if (string.charAt(0) == '/') {
            return string;
        }
        String string2 = this.getName();
        StringBuffer stringBuffer = new StringBuffer();
        int n = string2.lastIndexOf(46);
        if (n != -1) {
            stringBuffer.append(string2.substring(0, n + 1).replace('.', '/'));
        }
        stringBuffer.append(string);
        return stringBuffer.toString();
    }

    public ClassLoader getClassLoader() {
        return this.getClassLoader0();
    }

    private native ClassLoader getClassLoader0();

    public Class getDeclaringClass() {
        Class[] classArray = this.getClasses0(false);
        switch (classArray.length) {
            case 0: {
                return null;
            }
            case 1: {
                return classArray[0];
            }
        }
        throw new ClassFormatError(new StringBuffer().append("Too many outer classes :").append(classArray.length).toString());
    }

    public Class[] getClasses() {
        SecurityManager securityManager = System.getSecurityManager();
        Vector vector = new Vector();
        Class clazz = this;
        while (clazz != null) {
            if (securityManager != null) {
                securityManager.checkMemberAccess(clazz, 0);
            }
            Class[] classArray = clazz.getClasses0(true);
            int n = 0;
            while (n < classArray.length) {
                if (Modifier.isPublic(classArray[n].getModifiers())) {
                    vector.add(classArray[n]);
                }
                ++n;
            }
            clazz = clazz.getSuperclass();
        }
        return (Class[])vector.toArray(new Class[vector.size()]);
    }

    private native Class[] getClasses0(boolean var1);

    public native Class getComponentType();

    public Constructor getConstructor(Class[] classArray) throws NoSuchMethodException, SecurityException {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkMemberAccess(this, 0);
        }
        return this.getConstructor0(classArray, false);
    }

    private native Constructor getConstructor0(Class[] var1, boolean var2);

    public Constructor[] getConstructors() throws SecurityException {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkMemberAccess(this, 0);
        }
        return this.getConstructors0(false);
    }

    private native Constructor[] getConstructors0(boolean var1);

    public Class[] getDeclaredClasses() throws SecurityException {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkMemberAccess(this, 1);
        }
        return this.getClasses0(true);
    }

    public Constructor getDeclaredConstructor(Class[] classArray) throws NoSuchMethodException, SecurityException {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkMemberAccess(this, 1);
        }
        return this.getConstructor0(classArray, true);
    }

    public Constructor[] getDeclaredConstructors() throws SecurityException {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkMemberAccess(this, 1);
        }
        return this.getConstructors0(true);
    }

    public Field getDeclaredField(String string) throws NoSuchFieldException, SecurityException {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkMemberAccess(this, 1);
        }
        return this.getField0(string, true);
    }

    public Field[] getDeclaredFields() throws SecurityException {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkMemberAccess(this, 1);
        }
        return this.getFields0(true);
    }

    public Method getDeclaredMethod(String string, Class[] classArray) throws NoSuchMethodException, SecurityException {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkMemberAccess(this, 1);
        }
        return this.getMethod0(string, classArray, true);
    }

    public Method[] getDeclaredMethods() throws SecurityException {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkMemberAccess(this, 1);
        }
        return this.getMethods0(true);
    }

    public Field getField(String string) throws NoSuchFieldException, SecurityException {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkMemberAccess(this, 0);
        }
        return this.getField0(string, false);
    }

    private native Field getField0(String var1, boolean var2);

    public Field[] getFields() throws SecurityException {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkMemberAccess(this, 0);
        }
        return this.getFields0(false);
    }

    private native Field[] getFields0(boolean var1);

    public native Class[] getInterfaces();

    public Method getMethod(String string, Class[] classArray) throws NoSuchMethodException, SecurityException {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkMemberAccess(this, 0);
        }
        if (string.equals("<init>") || string.equals("<clinit>")) {
            throw new NoSuchMethodException();
        }
        return this.getMethod0(string, classArray, false);
    }

    private native Method getMethod0(String var1, Class[] var2, boolean var3);

    public Method[] getMethods() throws SecurityException {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkMemberAccess(this, 0);
        }
        return this.getMethods0(false);
    }

    private native Method[] getMethods0(boolean var1);

    public native int getModifiers();

    public native String getName();

    public Package getPackage() {
        String string;
        ClassLoader classLoader = this.getClassLoader();
        if (classLoader != null && (string = PackageHelper.getPackageName(this)) != null) {
            return classLoader.getPackage(string);
        }
        return null;
    }

    public ProtectionDomain getProtectionDomain() {
        return this.getClassLoader().getProtectionDomain(this);
    }

    static native Class getPrimitiveClass(String var0);

    public URL getResource(String string) {
        ClassLoader classLoader = this.getClassLoader();
        string = this.fullResourceName(string);
        if (classLoader == null) {
            return ClassLoader.getSystemResource(string);
        }
        return classLoader.getResource(string);
    }

    public InputStream getResourceAsStream(String string) {
        try {
            URL uRL = this.getResource(string);
            if (uRL == null) {
                return null;
            }
            return uRL.openStream();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public native Object[] getSigners();

    native void setSigners(Object[] var1);

    public native Class getSuperclass();

    public native boolean isArray();

    public native boolean isAssignableFrom(Class var1);

    public native boolean isInstance(Object var1);

    public native boolean isInterface();

    public native boolean isPrimitive();

    public Object newInstance() throws InstantiationException, IllegalAccessException {
        if (Modifier.isAbstract(this.getModifiers()) || this.isInterface() || this.isPrimitive()) {
            throw new InstantiationException(this.getName());
        }
        try {
            return this.getDeclaredConstructor(null).newInstance(null);
        }
        catch (InvocationTargetException invocationTargetException) {
            if (invocationTargetException.getTargetException() instanceof RuntimeException) {
                throw (RuntimeException)invocationTargetException.getTargetException();
            }
            throw new InstantiationException(invocationTargetException.getTargetException().getMessage());
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new InstantiationException(noSuchMethodException.getMessage());
        }
    }

    public String toString() {
        return new StringBuffer().append(this.isInterface() ? "interface " : (this.isPrimitive() ? "" : "class ")).append(this.getName()).toString();
    }

    /*
     * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class CallStack {
        private Class[] classStack = SecurityManager.getClassContext0();

        CallStack() {
        }

        static ClassLoader getCallersClassLoader() {
            CallStack callStack = new CallStack();
            int n = 2;
            Class clazz = callStack.getStackClass(n);
            if (clazz != null && callStack.getStackClass(n - 1) == clazz) {
                while (callStack.getStackClass(++n) == clazz) {
                }
                clazz = callStack.getStackClass(n);
            }
            if (clazz != null && clazz.getName().equals("java.lang.reflect.Method")) {
                clazz = callStack.getStackClass(n += 2);
            }
            if (clazz != null) {
                return clazz.getClassLoader();
            }
            return null;
        }

        private Class getStackClass(int n) {
            if ((n += 2) >= 0 && n < this.classStack.length) {
                return this.classStack[n];
            }
            return null;
        }
    }
}

