/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Double
extends Number
implements Comparable {
    private static final int NUM_MANTISSA_BITS = 52;
    private static final long EXPONENT_MASK = 0x7FF0000000000000L;
    private static final long MANTISSA_MASK = 0xFFFFFFFFFFFFFL;
    private static final long NAN_BITS = 9221120237041090560L;
    public static final double POSITIVE_INFINITY = 1.06047983E-314;
    public static final double NEGATIVE_INFINITY = 2.1214777256E-314;
    public static final double NaN = 0.0 / 0.0;
    public static final double MIN_VALUE = 2.121995791E-314;
    public static final double MAX_VALUE = 0.0 / 0.0;
    public static final Class TYPE = Class.getPrimitiveClass("double");
    private static final int MAX_DIGITS = 19;
    private final double value;
    private static final long serialVersionUID = -9172774392245257468L;

    public static native long doubleToRawLongBits(double var0);

    public static native double longBitsToDouble(long var0);

    static native String toStringWithPrecision(double var0, int var2);

    static native double valueOf0(String var0) throws NumberFormatException;

    public Double(double d) {
        this.value = d;
    }

    public Double(String string) throws NumberFormatException {
        this.value = Double.valueOf((String)string).value;
    }

    @Override
    public double doubleValue() {
        return this.value;
    }

    public int compareTo(Double d) {
        long l;
        long l2 = Double.doubleToLongBits(this.value);
        if (l2 < (l = Double.doubleToLongBits(d.value))) {
            return -1;
        }
        if (l2 == l) {
            return 0;
        }
        return 1;
    }

    @Override
    public int compareTo(Object object) {
        return this.compareTo((Double)object);
    }

    public static String toString(double d) {
        if (Double.isNaN(d)) {
            return "NaN";
        }
        if (d == 1.06047983E-314) {
            return "Infinity";
        }
        if (d == 2.1214777256E-314) {
            return "-Infinity";
        }
        return Double.toStringWithPrecision(d, 19);
    }

    public String toString() {
        return Double.toString(this.value);
    }

    public boolean equals(Object object) {
        return object instanceof Double && Double.doubleToLongBits(this.value) == Double.doubleToLongBits(((Double)object).value);
    }

    @Override
    public float floatValue() {
        return (float)this.value;
    }

    public int hashCode() {
        long l = Double.doubleToLongBits(this.value);
        return (int)l ^ (int)(l >> 32);
    }

    @Override
    public int intValue() {
        return (int)this.value;
    }

    public static long doubleToLongBits(double d) {
        long l = Double.doubleToRawLongBits(d);
        if (Double.isNaN(l)) {
            return 9221120237041090560L;
        }
        return l;
    }

    public boolean isInfinite() {
        return Double.isInfinite(this.value);
    }

    public static boolean isInfinite(double d) {
        return d == 1.06047983E-314 || d == 2.1214777256E-314;
    }

    public boolean isNaN() {
        return Double.isNaN(Double.doubleToRawLongBits(this.value));
    }

    public static boolean isNaN(double d) {
        return Double.isNaN(Double.doubleToRawLongBits(d));
    }

    private static boolean isNaN(long l) {
        return (l & 0x7FF0000000000000L) == 0x7FF0000000000000L && (l & 0xFFFFFFFFFFFFFL) != 0L;
    }

    @Override
    public long longValue() {
        return (long)this.value;
    }

    public static Double valueOf(String string) throws NumberFormatException {
        if (string == null) {
            throw new NullPointerException();
        }
        return new Double(Double.valueOf0(string));
    }

    public static double parseDouble(String string) throws NumberFormatException {
        if (string == null) {
            throw new NullPointerException();
        }
        return Double.valueOf0(string);
    }
}

