/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Float
extends Number
implements Comparable {
    private static final int NUM_MANTISSA_BITS = 23;
    private static final int EXPONENT_MASK = 2139095040;
    private static final int MANTISSA_MASK = 0x7FFFFF;
    private static final int NAN_BITS = 2143289344;
    public static final float POSITIVE_INFINITY = 1.0f / 0.0f;
    public static final float NEGATIVE_INFINITY = -1.0f / 0.0f;
    public static final float NaN = 0.0f / 0.0f;
    public static final float MIN_VALUE = 1.4E-45f;
    public static final float MAX_VALUE = 3.4028235E38f;
    public static final Class TYPE = Class.getPrimitiveClass("float");
    private static final int MAX_DIGITS = 10;
    private final float value;
    private static final long serialVersionUID = -2671257302660747028L;

    public static native int floatToRawIntBits(float var0);

    public static native float intBitsToFloat(int var0);

    private static native String toStringWithPrecision(float var0, int var1);

    public Float(float f) {
        this.value = f;
    }

    public Float(double d) {
        this.value = (float)d;
    }

    public Float(String string) throws NumberFormatException {
        this.value = Float.valueOf((String)string).value;
    }

    public boolean equals(Object object) {
        return object instanceof Float && Float.floatToIntBits(this.value) == Float.floatToIntBits(((Float)object).value);
    }

    public int compareTo(Float f) {
        int n;
        int n2 = Float.floatToIntBits(this.value);
        if (n2 < (n = Float.floatToIntBits(f.value))) {
            return -1;
        }
        if (n2 == n) {
            return 0;
        }
        return 1;
    }

    @Override
    public int compareTo(Object object) {
        return this.compareTo((Float)object);
    }

    public int hashCode() {
        return Float.floatToIntBits(this.value);
    }

    @Override
    public double doubleValue() {
        return this.value;
    }

    @Override
    public float floatValue() {
        return this.value;
    }

    @Override
    public long longValue() {
        return (long)this.value;
    }

    @Override
    public int intValue() {
        return (int)this.value;
    }

    public static String toString(float f) {
        if (Float.isNaN(f)) {
            return "NaN";
        }
        if (f == Float.POSITIVE_INFINITY) {
            return "Infinity";
        }
        if (f == Float.NEGATIVE_INFINITY) {
            return "-Infinity";
        }
        return Float.toStringWithPrecision(f, 10);
    }

    public String toString() {
        return Float.toString(this.value);
    }

    public static int floatToIntBits(float f) {
        int n = Float.floatToRawIntBits(f);
        if (Float.isNaN(n)) {
            return 2143289344;
        }
        return n;
    }

    public static boolean isNaN(float f) {
        return Float.isNaN(Float.floatToRawIntBits(f));
    }

    public boolean isNaN() {
        return Float.isNaN(Float.floatToRawIntBits(this.value));
    }

    private static boolean isNaN(int n) {
        return (n & 0x7F800000) == 2139095040 && (n & 0x7FFFFF) != 0;
    }

    public static boolean isInfinite(float f) {
        return f == Float.POSITIVE_INFINITY || f == Float.NEGATIVE_INFINITY;
    }

    public boolean isInfinite() {
        return Float.isInfinite(this.value);
    }

    public static Float valueOf(String string) throws NumberFormatException {
        if (string == null) {
            throw new NullPointerException();
        }
        return new Float(Double.valueOf0(string));
    }

    public static float parseFloat(String string) throws NumberFormatException {
        if (string == null) {
            throw new NullPointerException();
        }
        return (float)Double.valueOf0(string);
    }
}

