/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Long
extends Number
implements Comparable {
    private final long value;
    public static final long MIN_VALUE = -9223372036854775808L;
    public static final long MAX_VALUE = 0x7FFFFFFFFFFFFFFFL;
    public static final Class TYPE = Class.getPrimitiveClass("long");
    private static final long serialVersionUID = 4290774380558885855L;

    public Long(String string) throws NumberFormatException {
        this.value = Long.valueOf((String)string).value;
    }

    public Long(long l) {
        this.value = l;
    }

    public static Long decode(String string) throws NumberFormatException {
        int n = 1;
        if (string.startsWith("-")) {
            n = -1;
            string = string.substring(1);
        }
        if (string.equals("0")) {
            return new Long(0L);
        }
        int n2 = 10;
        if (string.equals("0")) {
            return new Long(0L);
        }
        if (string.startsWith("0x")) {
            n2 = 16;
            string = string.substring(2);
        } else if (string.startsWith("#")) {
            n2 = 16;
            string = string.substring(1);
        } else if (string.startsWith("0")) {
            n2 = 8;
            string = string.substring(1);
        }
        if (string.startsWith("-")) {
            throw new NumberFormatException();
        }
        return new Long(Long.parseUnsignedLong(string, n2, n));
    }

    @Override
    public double doubleValue() {
        return this.value;
    }

    public boolean equals(Object object) {
        return object instanceof Long && ((Long)object).value == this.value;
    }

    public int compareTo(Long l) {
        long l2 = this.value;
        long l3 = l.value;
        if (l2 == l3) {
            return 0;
        }
        if (l2 < l3) {
            return -1;
        }
        return 1;
    }

    @Override
    public int compareTo(Object object) {
        return this.compareTo((Long)object);
    }

    @Override
    public float floatValue() {
        return this.value;
    }

    public static Long getLong(String string) {
        return Long.getLong(string, null);
    }

    public static Long getLong(String string, Long l) {
        String string2 = System.getProperty(string);
        if (string2 != null && !string2.equals("")) {
            long l2 = 1L;
            if (string2.startsWith("-")) {
                l2 = -1L;
                string2 = string2.substring(1);
            }
            if (string2.equals("0")) {
                return new Long(0L);
            }
            int n = 10;
            if (string2.startsWith("0x")) {
                n = 16;
                string2 = string2.substring(2);
            } else if (string2.startsWith("#")) {
                n = 16;
                string2 = string2.substring(1);
            } else if (string2.startsWith("0")) {
                n = 8;
                string2 = string2.substring(1);
            }
            try {
                return new Long(Long.parseUnsignedLong(string2, n, l2));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return l;
    }

    public static Long getLong(String string, long l) {
        return Long.getLong(string, new Long(l));
    }

    public int hashCode() {
        return (int)(this ^ this >>> 32);
    }

    @Override
    public int intValue() {
        return (int)this.value;
    }

    @Override
    public long longValue() {
        return this.value;
    }

    public static long parseLong(String string) throws NumberFormatException {
        return Long.parseLong(string, 10);
    }

    public static long parseLong(String string, int n) throws NumberFormatException {
        if (string == null || string.length() <= 0) {
            throw new NumberFormatException();
        }
        if (string.charAt(0) == '-') {
            return Long.parseUnsignedLong(string.substring(1), n, -1L);
        }
        return Long.parseUnsignedLong(string, n, 1L);
    }

    private static long parseUnsignedLong(String string, int n, long l) throws NumberFormatException {
        if (string == null || string.length() <= 0) {
            throw new NumberFormatException();
        }
        long l2 = 0L;
        int n2 = 0;
        while (n2 < string.length()) {
            int n3 = Character.digit(string.charAt(n2), n);
            if (n3 == -1) {
                throw new NumberFormatException();
            }
            long l3 = l2 * (long)n + l * (long)n3;
            if (l == 1L && l2 > l3 || l == -1L && l2 < l3) {
                throw new NumberFormatException();
            }
            l2 = l3;
            ++n2;
        }
        return l2;
    }

    public static String toBinaryString(long l) {
        return Long.toUnsignedString(l, 1);
    }

    public static String toHexString(long l) {
        return Long.toUnsignedString(l, 4);
    }

    public static String toOctalString(long l) {
        return Long.toUnsignedString(l, 3);
    }

    public String toString() {
        return Long.toString(this.value);
    }

    public static String toString(long l) {
        return Long.toString(l, 10);
    }

    public static String toString(long l, int n) {
        if (l == 0L) {
            return "0";
        }
        if (n < 2 || n > 36) {
            n = 10;
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = l < 0L ? -1 : 1;
        while (l != 0L) {
            char c = Character.forDigit(Math.abs((int)(l % (long)n)), n);
            l /= (long)n;
            stringBuffer.append(c);
        }
        if (n2 == -1) {
            stringBuffer.append('-');
        }
        stringBuffer.reverse();
        return stringBuffer.toString();
    }

    private static String toUnsignedString(long l, int n) {
        if (l == 0L) {
            return "0";
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 1 << n;
        int n3 = n2 - 1;
        while (l != 0L) {
            char c = Character.forDigit((int)l & n3, n2);
            l >>>= n;
            stringBuffer.append(c);
        }
        stringBuffer.reverse();
        return stringBuffer.toString();
    }

    public static Long valueOf(String string) throws NumberFormatException {
        return Long.valueOf(string, 10);
    }

    public static Long valueOf(String string, int n) throws NumberFormatException {
        return new Long(Long.parseLong(string, n));
    }
}

