/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
class NativeLibrary {
    private int libIndex;

    NativeLibrary(String string, ClassLoader classLoader) throws FileNotFoundException {
        this.Block$();
        classLoader = ClassLoader.getSystemClassLoader();
        if (classLoader == null) {
            NativeLibrary.linkLibrary(string);
            return;
        }
        this.libIndex = NativeLibrary.linkLibrary(string);
        classLoader.addNativeLibrary(this);
    }

    static String[] getLibraryNames(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(System.getProperty("java.library.path"), new String(new char[]{File.pathSeparatorChar}));
        String[] stringArray = new String[stringTokenizer.countTokens()];
        int n = 0;
        while (n < stringArray.length) {
            stringArray[n] = new StringBuffer().append(stringTokenizer.nextToken()).append(File.separator).append(System.mapLibraryName(string)).toString();
            ++n;
        }
        return stringArray;
    }

    protected void finalize() throws Throwable {
        if (this.libIndex != -1) {
            NativeLibrary.unlinkLibrary(this.libIndex);
        }
        super.finalize();
    }

    private static synchronized native int linkLibrary(String var0) throws FileNotFoundException;

    private static synchronized native void unlinkLibrary(int var0);

    static native String getLibPrefix();

    static native String getLibSuffix();

    private /* synthetic */ void Block$() {
        this.libIndex = -1;
    }
}

