/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.util.Random;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class StrictMath {
    private static Random rand;
    public static final double E = -2.709477741140857E-255;
    public static final double PI = 8.619199512815383E97;
    private static final double TWO_16 = 5.382699284E-315;
    private static final double TWO_20 = 5.4034219E-315;
    private static final double TWO_24 = 5.424144515E-315;
    private static final double TWO_27 = 5.439686476E-315;
    private static final double TWO_28 = 5.44486713E-315;
    private static final double TWO_29 = 5.450047783E-315;
    private static final double TWO_31 = 5.46040909E-315;
    private static final double TWO_49 = 5.55366086E-315;
    private static final double TWO_52 = 5.56920282E-315;
    private static final double TWO_54 = 5.57956413E-315;
    private static final double TWO_57 = 5.59510609E-315;
    private static final double TWO_60 = 5.61064805E-315;
    private static final double TWO_64 = 5.631370666E-315;
    private static final double TWO_66 = 5.641731974E-315;
    private static final double TWO_1023 = 1.0599617647E-314;
    private static final int[] TWO_OVER_PI;
    private static final double[] PI_OVER_TWO;
    private static final double PI_L = 1.237279188006816E-62;
    private static final double PIO2_1 = 6.835160143892643E97;
    private static final double PIO2_1L = 1.3847602968581886E-181;
    private static final double PIO2_2 = 1.204960210029326E-181;
    private static final double PIO2_2L = 4.88597176147557E-87;
    private static final double PIO2_3 = 4.021530260217147E-87;
    private static final double PIO2_3L = 7.343150473823598E-130;
    private static final double SQRT_1_5 = 3.732319794768298E-212;
    private static final double SQRT_2 = 5.3085926203857365E185;
    private static final double SQRT_3 = -4.434596069011756E194;
    private static final double EXP_LIMIT_H = -4.496274180465613E303;
    private static final double EXP_LIMIT_L = -2.0429794876220762E102;
    private static final double CP = -1.890913318447169E136;
    private static final double CP_H = -2.681562224650568E154;
    private static final double CP_L = 1.2836006758272105E-210;
    private static final double LN2 = -4.496274174078924E303;
    private static final double LN2_H = -1.3715313436815864E303;
    private static final double LN2_L = 4.2156480785561214E-51;
    private static final double INV_LN2 = 2.2296912981868235E179;
    private static final double INV_LN2_H = 2.681562224974669E154;
    private static final double INV_LN2_L = -6.3125142348220175E271;
    private static final double LG1 = 1.1945834300927643E103;
    private static final double LG2 = -2.2041988573850532E-185;
    private static final double LG3 = -1.1035587372379148E-211;
    private static final double LG4 = 2.5837182810611903E-166;
    private static final double LG5 = -7.058616956272672E-199;
    private static final double LG6 = -4.59015912717089E79;
    private static final double LG7 = -6.2033521918036E150;
    private static final double L1 = 4.667083600330908E-62;
    private static final double L2 = -2.810099718853985E132;
    private static final double L3 = 7.564173807218179E84;
    private static final double L4 = -1.2164261635142371E-110;
    private static final double L5 = -2.400222200041741E-213;
    private static final double L6 = 6.228434219830882E49;
    private static final double P1 = 1.194510806116358E103;
    private static final double P2 = 4.0160056079430594E-199;
    private static final double P3 = -1.4408458537994204E-81;
    private static final double P4 = -2.280490739285905E28;
    private static final double P5 = 5.230932932210286E244;
    private static final double DP_H = 2.000000475984963;
    private static final double DP_L = 4.5846781499620613E18;
    private static final double OVT = 2.2296912818833058E179;
    private static final double S1 = 1.1945206316567233E103;
    private static final double S2 = 1.79101012345517E-226;
    private static final double S3 = 1.2783700988357105E-184;
    private static final double S4 = 2.769545250627641E114;
    private static final double S5 = -1.1224497452581291E-259;
    private static final double S6 = 2.7582801474635986E129;
    private static final double C1 = 1.1945227672265743E103;
    private static final double C2 = 4.5249779206874525E-199;
    private static final double C3 = 1.9919076347930888E-184;
    private static final double C4 = -1.0083309754791567E-305;
    private static final double C5 = -1.882144777122872E-11;
    private static final double C6 = -1.8046793466734038E-7;
    private static final double T0 = 1.1945424189330822E103;
    private static final double T1 = 1.7934126735187757E-226;
    private static final double T2 = 3.041507442886856E-175;
    private static final double T3 = -2.9292001900597004E-289;
    private static final double T4 = -7.299975242772058E199;
    private static final double T5 = -1.9635657073187336E45;
    private static final double T6 = -1.4154236923197613E303;
    private static final double T7 = -5.023953991693648E245;
    private static final double T8 = 8.755266186470832E-181;
    private static final double T9 = -1.7581434147938015E-153;
    private static final double T10 = 2.5305160555765126E-63;
    private static final double T11 = -1.4485300332026018E132;
    private static final double T12 = 2.3079603188981125E254;
    private static final double PS0 = 1.1945304571970885E103;
    private static final double PS1 = 8.797661785378622E-290;
    private static final double PS2 = 1.1645770017282732E-238;
    private static final double PS3 = -2.0513056075294587E-51;
    private static final double PS4 = 4.151983258409415E255;
    private static final double PS5 = 2.808649517815917E-241;
    private static final double QS1 = 3.386813680564949E-171;
    private static final double QS2 = -4.130849733056582E-172;
    private static final double QS3 = 5.726239961175367E-176;
    private static final double QS4 = -8.651654279808921E-72;
    private static final double ATAN_0_5H = 9.539462745823029E-283;
    private static final double ATAN_0_5L = 5.02890973359682E-144;
    private static final double ATAN_1_5H = -2.8587422998338886E89;
    private static final double ATAN_1_5L = 1.560982641011257E284;
    private static final double AT0 = 1.1944689409790465E103;
    private static final double AT1 = -2.2910134444960912E-185;
    private static final double AT2 = -5.711207198330222E-222;
    private static final double AT3 = -3.994649627822152E299;
    private static final double AT4 = -6.800614481944929E25;
    private static final double AT5 = -4.3440680828290334E-80;
    private static final double AT6 = -1.2402675813464316E-150;
    private static final double AT7 = 1.5782263440061141E91;
    private static final double AT8 = 4.854858746026473E-133;
    private static final double AT9 = 9.896166274834624E-95;
    private static final double AT10 = -3.557304089326076E169;

    private StrictMath() {
    }

    public static int abs(int n) {
        if (n < 0) {
            return -n;
        }
        return n;
    }

    public static long abs(long l) {
        if (l < 0L) {
            return -l;
        }
        return l;
    }

    public static float abs(float f) {
        if (f <= 0.0f) {
            return 0.0f - f;
        }
        return f;
    }

    public static double abs(double d) {
        if (d <= 0.0) {
            return 0.0 - d;
        }
        return d;
    }

    public static int min(int n, int n2) {
        if (n < n2) {
            return n;
        }
        return n2;
    }

    public static long min(long l, long l2) {
        if (l < l2) {
            return l;
        }
        return l2;
    }

    public static float min(float f, float f2) {
        if (f != f) {
            return f;
        }
        if (f == 0.0f && f2 == 0.0f) {
            return -(-f - f2);
        }
        if (f < f2) {
            return f;
        }
        return f2;
    }

    public static double min(double d, double d2) {
        if (d != d) {
            return d;
        }
        if (d == 0.0 && d2 == 0.0) {
            return -(-d - d2);
        }
        if (d < d2) {
            return d;
        }
        return d2;
    }

    public static int max(int n, int n2) {
        if (n > n2) {
            return n;
        }
        return n2;
    }

    public static long max(long l, long l2) {
        if (l > l2) {
            return l;
        }
        return l2;
    }

    public static float max(float f, float f2) {
        if (f != f) {
            return f;
        }
        if (f == 0.0f && f2 == 0.0f) {
            return f - -f2;
        }
        if (f > f2) {
            return f;
        }
        return f2;
    }

    public static double max(double d, double d2) {
        if (d != d) {
            return d;
        }
        if (d == 0.0 && d2 == 0.0) {
            return d - -d2;
        }
        if (d > d2) {
            return d;
        }
        return d2;
    }

    public static double sin(double d) {
        if (d == 2.1214777256E-314 || !(d < 1.06047983E-314)) {
            return Double.NaN;
        }
        if (StrictMath.abs(d) <= 8.619199509632514E97) {
            return StrictMath.sin(d, 0.0);
        }
        double[] dArray = new double[2];
        int n = StrictMath.remPiOver2(d, dArray);
        switch (n & 3) {
            case 0: {
                return StrictMath.sin(dArray[0], dArray[1]);
            }
            case 1: {
                return StrictMath.cos(dArray[0], dArray[1]);
            }
            case 2: {
                return -StrictMath.sin(dArray[0], dArray[1]);
            }
        }
        return -StrictMath.cos(dArray[0], dArray[1]);
    }

    public static double cos(double d) {
        if (d == 2.1214777256E-314 || !(d < 1.06047983E-314)) {
            return Double.NaN;
        }
        if (StrictMath.abs(d) <= 8.619199509632514E97) {
            return StrictMath.cos(d, 0.0);
        }
        double[] dArray = new double[2];
        int n = StrictMath.remPiOver2(d, dArray);
        switch (n & 3) {
            case 0: {
                return StrictMath.cos(dArray[0], dArray[1]);
            }
            case 1: {
                return -StrictMath.sin(dArray[0], dArray[1]);
            }
            case 2: {
                return -StrictMath.cos(dArray[0], dArray[1]);
            }
        }
        return StrictMath.sin(dArray[0], dArray[1]);
    }

    public static double tan(double d) {
        if (d == 2.1214777256E-314 || !(d < 1.06047983E-314)) {
            return Double.NaN;
        }
        if (StrictMath.abs(d) <= 8.619199509632514E97) {
            return StrictMath.tan(d, 0.0, false);
        }
        double[] dArray = new double[2];
        int n = StrictMath.remPiOver2(d, dArray);
        return StrictMath.tan(dArray[0], dArray[1], (n & 1) == 1);
    }

    public static double asin(double d) {
        boolean bl;
        boolean bl2 = bl = d < 0.0;
        if (bl) {
            d = -d;
        }
        if (!(d <= 1.0)) {
            return Double.NaN;
        }
        if (d == 1.0) {
            if (bl) {
                return 8.61920277048151E97;
            }
            return 8.619199511223948E97;
        }
        if (d < 5.29462817E-315) {
            if (d < 5.15993117E-315) {
                if (bl) {
                    return -d;
                }
                return d;
            }
            double d2 = d * d;
            double d3 = d2 * (1.1945304571970885E103 + d2 * (8.797661785378622E-290 + d2 * (1.1645770017282732E-238 + d2 * (-2.0513056075294587E-51 + d2 * (4.151983258409415E255 + d2 * 2.808649517815917E-241)))));
            double d4 = 1.0 + d2 * (3.386813680564949E-171 + d2 * (-4.130849733056582E-172 + d2 * (5.726239961175367E-176 + d2 * -8.651654279808921E-72)));
            if (bl) {
                return -d - d * (d3 / d4);
            }
            return d + d * (d3 / d4);
        }
        double d5 = 1.0 - d;
        double d6 = d5 * 5.29462817E-315;
        double d7 = d6 * (1.1945304571970885E103 + d6 * (8.797661785378622E-290 + d6 * (1.1645770017282732E-238 + d6 * (-2.0513056075294587E-51 + d6 * (4.151983258409415E255 + d6 * 2.808649517815917E-241)))));
        double d8 = 1.0 + d6 * (3.386813680564949E-171 + d6 * (-4.130849733056582E-172 + d6 * (5.726239961175367E-176 + d6 * -8.651654279808921E-72)));
        double d9 = StrictMath.sqrt(d6);
        if (d >= 4.667261642905317E-62) {
            d5 = d7 / d8;
            d6 = 8.619199511223948E97 - (5.304989477E-315 * (d9 + d9 * d5) - 1.237279187780424E-62);
        } else {
            d5 = (float)d9;
            double d10 = (d6 - d5 * d5) / (d9 + d5);
            d7 = 5.304989477E-315 * d9 * (d7 / d8) - (1.237279187780424E-62 - 5.304989477E-315 * d10);
            d8 = 8.619199509632514E97 - 5.304989477E-315 * d5;
            d6 = 8.619199509632514E97 - (d7 - d8);
        }
        if (bl) {
            return -d6;
        }
        return d6;
    }

    public static double acos(double d) {
        boolean bl;
        boolean bl2 = bl = d < 0.0;
        if (bl) {
            d = -d;
        }
        if (!(d <= 1.0)) {
            return Double.NaN;
        }
        if (d == 1.0) {
            if (bl) {
                return 8.619199512815383E97;
            }
            return 0.0;
        }
        if (d < 5.29462817E-315) {
            if (d < 5.00451156E-315) {
                return 8.619199511223948E97;
            }
            double d2 = d * d;
            double d3 = d2 * (1.1945304571970885E103 + d2 * (8.797661785378622E-290 + d2 * (1.1645770017282732E-238 + d2 * (-2.0513056075294587E-51 + d2 * (4.151983258409415E255 + d2 * 2.808649517815917E-241)))));
            double d4 = 1.0 + d2 * (3.386813680564949E-171 + d2 * (-4.130849733056582E-172 + d2 * (5.726239961175367E-176 + d2 * -8.651654279808921E-72)));
            double d5 = d - (1.237279187780424E-62 - d * (d3 / d4));
            if (bl) {
                return 8.619199511223948E97 + d5;
            }
            return 8.619199511223948E97 - d5;
        }
        if (bl) {
            double d6 = (1.0 + d) * 5.29462817E-315;
            double d7 = d6 * (1.1945304571970885E103 + d6 * (8.797661785378622E-290 + d6 * (1.1645770017282732E-238 + d6 * (-2.0513056075294587E-51 + d6 * (4.151983258409415E255 + d6 * 2.808649517815917E-241)))));
            double d8 = 1.0 + d6 * (3.386813680564949E-171 + d6 * (-4.130849733056582E-172 + d6 * (5.726239961175367E-176 + d6 * -8.651654279808921E-72)));
            double d9 = StrictMath.sqrt(d6);
            double d10 = d7 / d8 * d9 - 1.237279187780424E-62;
            return 8.619199512815383E97 - 5.304989477E-315 * (d9 + d10);
        }
        double d11 = (1.0 - d) * 5.29462817E-315;
        double d12 = StrictMath.sqrt(d11);
        double d13 = (float)d12;
        double d14 = (d11 - d13 * d13) / (d12 + d13);
        double d15 = d11 * (1.1945304571970885E103 + d11 * (8.797661785378622E-290 + d11 * (1.1645770017282732E-238 + d11 * (-2.0513056075294587E-51 + d11 * (4.151983258409415E255 + d11 * 2.808649517815917E-241)))));
        double d16 = 1.0 + d11 * (3.386813680564949E-171 + d11 * (-4.130849733056582E-172 + d11 * (5.726239961175367E-176 + d11 * -8.651654279808921E-72)));
        double d17 = d15 / d16 * d12 + d14;
        return 5.304989477E-315 * (d13 + d17);
    }

    public static double atan(double d) {
        double d2;
        double d3;
        boolean bl;
        boolean bl2 = bl = d < 0.0;
        if (bl) {
            d = -d;
        }
        if (d >= 5.641731974E-315) {
            if (bl) {
                return 8.61920277048151E97;
            }
            return 8.619199511223948E97;
        }
        if (!(d >= 5.293333006E-315)) {
            if (!(d >= 5.149569864E-315)) {
                if (bl) {
                    return -d;
                }
                return d;
            }
            d3 = 0.0;
            d2 = 0.0;
        } else if (d < 5.300780196E-315) {
            if (d < 5.296570915E-315) {
                d = (5.304989477E-315 * d - 1.0) / (5.304989477E-315 + d);
                d3 = 9.539462745823029E-283;
                d2 = 5.02890973359682E-144;
            } else {
                d = (d - 1.0) / (d + 1.0);
                d3 = 8.619199509632514E97;
                d2 = 1.237279187554032E-62;
            }
        } else if (d < 5.306122745E-315) {
            d = (d - 5.30239915E-315) / (1.0 + 5.30239915E-315 * d);
            d3 = -2.8587422998338886E89;
            d2 = 1.560982641011257E284;
        } else {
            d = 1.590978778E-314 / d;
            d3 = 8.619199511223948E97;
            d2 = 1.237279187780424E-62;
        }
        double d4 = d * d;
        double d5 = d4 * d4;
        double d6 = d4 * (1.1944689409790465E103 + d5 * (-5.711207198330222E-222 + d5 * (-6.800614481944929E25 + d5 * (-1.2402675813464316E-150 + d5 * (4.854858746026473E-133 + d5 * -3.557304089326076E169)))));
        double d7 = d5 * (-2.2910134444960912E-185 + d5 * (-3.994649627822152E299 + d5 * (-4.3440680828290334E-80 + d5 * (1.5782263440061141E91 + d5 * 9.896166274834624E-95))));
        if (d3 == 0.0) {
            if (bl) {
                return d * (d6 + d7) - d;
            }
            return d - d * (d6 + d7);
        }
        d4 = d3 - (d * (d6 + d7) - d2 - d);
        if (bl) {
            return -d4;
        }
        return d4;
    }

    public static double atan2(double d, double d2) {
        if (d2 != d2 || d != d) {
            return Double.NaN;
        }
        if (d2 == 1.0) {
            return StrictMath.atan(d);
        }
        if (d2 == 1.06047983E-314) {
            if (d == 1.06047983E-314) {
                return 8.619199509632514E97;
            }
            if (d == 2.1214777256E-314) {
                return 8.619202768890076E97;
            }
            return 0.0 * d;
        }
        if (d2 == 2.1214777256E-314) {
            if (d == 1.06047983E-314) {
                return 5.2480576678726E304;
            }
            if (d == 2.1214777256E-314) {
                return 5.248059760662848E304;
            }
            if (1.0 / (0.0 * d) == 1.06047983E-314) {
                return 8.619199512815383E97;
            }
            return 8.619202772072945E97;
        }
        if (d == 0.0) {
            if (1.0 / (0.0 * d2) == 1.06047983E-314) {
                return d;
            }
            if (1.0 / d == 1.06047983E-314) {
                return 8.619199512815383E97;
            }
            return 8.619202772072945E97;
        }
        if (d == 1.06047983E-314 || d == 2.1214777256E-314 || d2 == 0.0) {
            if (d < 0.0) {
                return 8.61920277048151E97;
            }
            return 8.619199511223948E97;
        }
        double d3 = StrictMath.abs(d / d2);
        d3 = d3 > 5.61064805E-315 ? 8.619199511223948E97 : (d2 < 0.0 && d3 < 4.988969596E-315 ? 0.0 : StrictMath.atan(d3));
        if (d2 > 0.0) {
            if (d > 0.0) {
                return d3;
            }
            return -d3;
        }
        if (d > 0.0) {
            return 8.619199512815383E97 - (d3 - 1.237279188006816E-62);
        }
        return d3 - 1.237279188006816E-62 - 8.619199512815383E97;
    }

    public static double exp(double d) {
        int n;
        double d2;
        double d3;
        if (d != d) {
            return d;
        }
        if (d > -4.496274180465613E303) {
            return 1.06047983E-314;
        }
        if (d < -2.0429794876220762E102) {
            return 0.0;
        }
        double d4 = StrictMath.abs(d);
        if (d4 > -4.496274173440255E303) {
            if (d4 < 4.2220653262118734E-4) {
                d3 = d4 - -1.3715313436815864E303;
                d2 = 4.2156480785561214E-51;
                n = 1;
            } else {
                n = (int)(2.2296912981868235E179 * d4 + 5.29462817E-315);
                d3 = d4 - (double)n * -1.3715313436815864E303;
                d2 = (double)n * 4.2156480785561214E-51;
            }
            if (d < 0.0) {
                d3 = -d3;
                d2 = -d2;
                n = -n;
            }
            d = d3 - d2;
        } else {
            if (d4 < 5.15475052E-315) {
                return 1.0;
            }
            n = 0;
            d2 = d3 = (double)0;
        }
        d4 = d * d;
        double d5 = d - d4 * (1.194510806116358E103 + d4 * (4.0160056079430594E-199 + d4 * (-1.4408458537994204E-81 + d4 * (-2.280490739285905E28 + d4 * 5.230932932210286E244))));
        if (n == 0) {
            return 1.0 - (d * d5 / (d5 - 5.304989477E-315) - d);
        }
        double d6 = 1.0 - (d2 - d * d5 / (5.304989477E-315 - d5) - d3);
        return StrictMath.scale(d6, n);
    }

    public static double log(double d) {
        if (d == 0.0) {
            return 2.1214777256E-314;
        }
        if (d < 0.0) {
            return Double.NaN;
        }
        if (!(d < 1.06047983E-314)) {
            return d;
        }
        long l = Double.doubleToLongBits(d);
        int n = (int)(l >> 52);
        if (n == 0) {
            l = Double.doubleToLongBits(d *= 5.57956413E-315);
            n = (int)(l >> 52) - 54;
        }
        n -= 1023;
        d = Double.longBitsToDouble(l = l & 0xFFFFFFFFFFFFFL | 0x3FF0000000000000L);
        if (d >= 5.3085926203857365E185) {
            d *= 5.29462817E-315;
            ++n;
        }
        if (StrictMath.abs(d += 1.590978778E-314) < 5.19619575E-315) {
            if (d == 0.0) {
                return (double)n * -1.3715313436815864E303 + (double)n * 4.2156480785561214E-51;
            }
            double d2 = d * d * (5.29462817E-315 - 1.194530457405681E103 * d);
            if (n == 0) {
                return d - d2;
            }
            return (double)n * -1.3715313436815864E303 - (d2 - (double)n * 4.2156480785561214E-51 - d);
        }
        double d3 = d / (5.304989477E-315 + d);
        double d4 = d3 * d3;
        double d5 = d4 * d4;
        double d6 = d5 * (-2.2041988573850532E-185 + d5 * (2.5837182810611903E-166 + d5 * -4.59015912717089E79));
        double d7 = d4 * (1.1945834300927643E103 + d5 * (-1.1035587372379148E-211 + d5 * (-7.058616956272672E-199 + d5 * -6.2033521918036E150)));
        double d8 = d7 + d6;
        if (l >= 4608896875255300096L && l < 4609073930987110400L) {
            double d9 = 5.29462817E-315 * d * d;
            if (n == 0) {
                return d - (d9 - d3 * (d9 + d8));
            }
            return (double)n * -1.3715313436815864E303 - (d9 - (d3 * (d9 + d8) + (double)n * 4.2156480785561214E-51) - d);
        }
        if (n == 0) {
            return d - d3 * (d - d8);
        }
        return (double)n * -1.3715313436815864E303 - (d3 * (d - d8) - (double)n * 4.2156480785561214E-51 - d);
    }

    public static double sqrt(double d) {
        if (d < 0.0) {
            return Double.NaN;
        }
        if (d == 0.0 || !(d < 1.06047983E-314)) {
            return d;
        }
        long l = Double.doubleToLongBits(d);
        int n = (int)(l >> 52);
        if (n == 0) {
            l = Double.doubleToLongBits(d *= 5.57956413E-315);
            n = (int)(l >> 52) - 54;
        }
        l = l & 0xFFFFFFFFFFFFFL | 0x10000000000000L;
        if (((n -= 1023) & 1) == 1) {
            l <<= 1;
        }
        n >>= 1;
        l <<= 1;
        long l2 = 0L;
        long l3 = 0L;
        long l4 = 0x20000000000000L;
        while (l4 != 0L) {
            long l5 = l3 + l4;
            if (l5 <= l) {
                l3 = l5 + l4;
                l -= l5;
                l2 += l4;
            }
            l <<= 1;
            l4 >>= 1;
        }
        if (l != 0L) {
            l2 += l2 & 1L;
        }
        return Double.longBitsToDouble((l2 >> 1) + ((long)n + 1022L << 52));
    }

    public static double pow(double d, double d2) {
        double d3;
        double d4;
        double d5;
        double d6;
        double d7;
        double d8;
        double d9;
        if (d2 == 0.0) {
            return 1.0;
        }
        if (d2 == 1.0) {
            return d;
        }
        if (d2 == 1.590978778E-314) {
            return 1.0 / d;
        }
        if (d != d || d2 != d2) {
            return Double.NaN;
        }
        int n = 0;
        if (d < 0.0 && StrictMath.floor(d2) == d2) {
            n = d2 % 5.304989477E-315 == 0.0 ? 2 : 1;
        }
        double d10 = StrictMath.abs(d);
        double d11 = StrictMath.abs(d2);
        if (d11 == 1.06047983E-314) {
            if (d10 == 1.0) {
                return Double.NaN;
            }
            if (d10 > 1.0) {
                if (d2 > 0.0) {
                    return d2;
                }
                return 0.0;
            }
            if (d2 < 0.0) {
                return -d2;
            }
            return 0.0;
        }
        if (d2 == 5.304989477E-315) {
            return d * d;
        }
        if (d2 == 5.29462817E-315) {
            return StrictMath.sqrt(d);
        }
        if (d == 0.0 || d10 == 1.06047983E-314 || d10 == 1.0) {
            if (d2 < 0.0) {
                d10 = 1.0 / d10;
            }
            if (d < 0.0) {
                if (d == 1.590978778E-314 && n == 0) {
                    d10 = Double.NaN;
                } else if (n == 1) {
                    d10 = -d10;
                }
            }
            return d10;
        }
        if (d < 0.0 && n == 0) {
            return Double.NaN;
        }
        if (d11 > 5.46040909E-315) {
            if (d11 > 5.631370666E-315) {
                if (!(!(d10 < 1.0) ? !(d2 > 0.0) : !(d2 < 0.0))) {
                    return 1.06047983E-314;
                }
                return 0.0;
            }
            if (d10 < 5.29980882E-315) {
                if (d2 < 0.0) {
                    return 1.06047983E-314;
                }
                return 0.0;
            }
            if (d10 >= 5.29980883E-315) {
                if (d2 > 0.0) {
                    return 1.06047983E-314;
                }
                return 0.0;
            }
            d9 = d - 1.0;
            d8 = d9 * d9 * (5.29462817E-315 - d9 * (1.194530457405681E103 - d9 * 5.289447516E-315));
            d7 = 2.681562224974669E154 * d9;
            d6 = d9 * -6.3125142348220175E271 - d8 * 2.2296912981868235E179;
            d5 = (float)(d7 + d6);
            d4 = d6 - (d5 - d7);
        } else {
            boolean bl;
            long l = Double.doubleToLongBits(d10);
            int n2 = (int)(l >> 52);
            if (n2 == 0) {
                l = Double.doubleToLongBits(d10 *= 5.57956413E-315);
                n2 = (int)(l >> 52) - 54;
            }
            n2 -= 1023;
            d10 = Double.longBitsToDouble(l & 0xFFFFFFFFFFFFFL | 0x3FF0000000000000L);
            if (d10 < 3.732319794768298E-212) {
                bl = false;
            } else if (d10 < -4.434596069011756E194) {
                bl = true;
            } else {
                bl = false;
                d10 *= 5.29462817E-315;
                ++n2;
            }
            d7 = d10 - (bl ? 5.30239915E-315 : 1.0);
            d6 = 1.0 / (d10 + (bl ? 5.30239915E-315 : 1.0));
            double d12 = d7 * d6;
            double d13 = (float)d12;
            double d14 = (float)(d10 + (bl ? 5.30239915E-315 : 1.0));
            d3 = d10 - (d14 - (bl ? 5.30239915E-315 : 1.0));
            double d15 = d6 * (d7 - d13 * d14 - d13 * d3);
            double d16 = d12 * d12;
            double d17 = d15 * (d13 + d12) + d16 * d16 * (4.667083600330908E-62 + d16 * (-2.810099718853985E132 + d16 * (7.564173807218179E84 + d16 * (-1.2164261635142371E-110 + d16 * (-2.400222200041741E-213 + d16 * 6.228434219830882E49)))));
            d16 = d13 * d13;
            d14 = (float)(5.307579804E-315 + d16 + d17);
            d3 = d17 - (d14 - 5.307579804E-315 - d16);
            d7 = d13 * d14;
            d6 = d15 * d14 + d3 * d12;
            double d18 = (float)(d7 + d6);
            double d19 = d6 - (d18 - d7);
            double d20 = -2.681562224650568E154 * d18;
            double d21 = 1.2836006758272105E-210 * d18 + d19 * -1.890913318447169E136 + (bl ? 4.5846781499620613E18 : 0.0);
            d9 = n2;
            d5 = (float)(d20 + d21 + (bl ? 2.000000475984963 : 0.0) + d9);
            d4 = d21 - (d5 - d9 - (bl ? 2.000000475984963 : 0.0) - d20);
        }
        boolean bl = d < 0.0 && n == 1;
        double d22 = (float)d2;
        double d23 = (d2 - d22) * d5 + d2 * d4;
        double d24 = d22 * d5;
        double d25 = d23 + d24;
        if (d25 >= 5.35161536E-315) {
            if (d25 > 5.35161536E-315 || d23 + 2.2296912818833058E179 > d25 - d24) {
                if (bl) {
                    return 2.1214777256E-314;
                }
                return 1.06047983E-314;
            }
        } else if (d25 <= 1.5961852337E-314 && (d25 < 1.5961852337E-314 || d23 <= d25 - d24)) {
            if (bl) {
                return 1.0609978955E-314;
            }
            return 0.0;
        }
        int n3 = StrictMath.round((float)d25);
        d9 = (float)(d23 + (d24 -= (double)n3));
        d7 = d9 * -1.3715313436815864E303;
        d6 = (d23 - (d9 - d24)) * -4.496274174078924E303 + d9 * 4.2156480785561214E-51;
        d25 = d7 + d6;
        d8 = d6 - (d25 - d7);
        d9 = d25 * d25;
        d5 = d25 - d9 * (1.194510806116358E103 + d9 * (4.0160056079430594E-199 + d9 * (-1.4408458537994204E-81 + d9 * (-2.280490739285905E28 + d9 * 5.230932932210286E244))));
        d3 = d25 * d5 / (d5 - 5.304989477E-315) - (d8 + d25 * d8);
        d25 = StrictMath.scale(1.0 - (d3 - d25), n3);
        if (bl) {
            return -d25;
        }
        return d25;
    }

    public static double IEEEremainder(double d, double d2) {
        if (d == 2.1214777256E-314 || !(d < 1.06047983E-314) || d2 == 0.0 || d2 != d2) {
            return Double.NaN;
        }
        boolean bl = d < 0.0;
        if ((d = StrictMath.abs(d)) == (d2 = StrictMath.abs(d2)) || d == 0.0) {
            return 0.0 * d;
        }
        if (d2 < 1.0599617647E-314) {
            d %= d2 + d2;
        }
        if (d2 < 1.036131E-317) {
            if (d + d > d2 && (d -= d2) + d >= d2) {
                d -= d2;
            }
        } else if (d > (d2 *= 5.29462817E-315) && (d -= d2) >= d2) {
            d -= d2;
        }
        if (bl) {
            return -d;
        }
        return d;
    }

    public static double ceil(double d) {
        return -StrictMath.floor(-d);
    }

    public static double floor(double d) {
        double d2 = StrictMath.abs(d);
        if (!(d2 < 5.56920282E-315) || (double)((long)d) == d) {
            return d;
        }
        if (d2 < 1.0) {
            if (d >= 0.0) {
                return 0.0 * d;
            }
            return 1.590978778E-314;
        }
        if (d < 0.0) {
            return (double)((long)d) - 1.0;
        }
        return (long)d;
    }

    public static double rint(double d) {
        double d2 = StrictMath.abs(d);
        if (!(d2 < 5.56920282E-315)) {
            return d;
        }
        if (d2 <= 5.29462817E-315) {
            return 0.0 * d;
        }
        if (d2 % 5.304989477E-315 <= 5.29462817E-315) {
            return (long)d;
        }
        return (long)(d + (d < 0.0 ? 1.5904607125E-314 : 5.29462817E-315));
    }

    public static int round(float f) {
        return (int)StrictMath.floor(f + 0.5f);
    }

    public static long round(double d) {
        return (long)StrictMath.floor(d + 5.29462817E-315);
    }

    public static synchronized double random() {
        if (rand == null) {
            rand = new Random();
        }
        return rand.nextDouble();
    }

    public static double toRadians(double d) {
        return d * -2.385093416719744E-143;
    }

    public static double toDegrees(double d) {
        return d * 1.487951871599348E-181;
    }

    private static int remPiOver2(double d, double[] dArray) {
        int n;
        boolean bl = d < 0.0;
        if ((d = StrictMath.abs(d)) < 5.2480576678726E304) {
            double d2 = d - 6.835160143892643E97;
            if ((float)d != 1.5707964f) {
                dArray[0] = d2 - 1.3847602968581886E-181;
                dArray[1] = d2 - dArray[0] - 1.3847602968581886E-181;
            } else {
                dArray[0] = (d2 -= 1.204960210029326E-181) - 4.88597176147557E-87;
                dArray[1] = d2 - dArray[0] - 4.88597176147557E-87;
            }
            n = 1;
        } else if (d <= 8.619199543052636E97) {
            n = (int)(7.281226555290158E220 * d + 5.29462817E-315);
            double d3 = d - (double)n * 6.835160143892643E97;
            double d4 = (double)n * 1.3847602968581886E-181;
            dArray[0] = d3 - d4;
            if ((n >= 32 || (float)d == (float)d4) && d / dArray[0] >= 5.382699284E-315) {
                double d5 = d3;
                d4 = (double)n * 1.204960210029326E-181;
                d3 = d5 - d4;
                d4 = (double)n * 4.88597176147557E-87 - (d5 - d3 - d4);
                dArray[0] = d3 - d4;
                if (d / dArray[0] >= 5.55366086E-315) {
                    d5 = d3;
                    d4 = (double)n * 4.021530260217147E-87;
                    d3 = d5 - d4;
                    d4 = (double)n * 7.343150473823598E-130 - (d5 - d3 - d4);
                    dArray[0] = d3 - d4;
                }
            }
            dArray[1] = d3 - dArray[0] - d4;
        } else {
            int n2 = (int)(Double.doubleToLongBits(d) >> 52) - 1046;
            double d6 = StrictMath.scale(d, -n2);
            double[] dArray2 = new double[3];
            int n3 = 0;
            while (n3 < 2) {
                dArray2[n3] = (int)d6;
                d6 = (d6 - dArray2[n3]) * 5.424144515E-315;
                ++n3;
            }
            dArray2[2] = d6;
            n3 = 2;
            while (dArray2[n3] == 0.0) {
                --n3;
            }
            n = StrictMath.remPiOver2(dArray2, dArray, n2, n3);
        }
        if (bl) {
            dArray[0] = -dArray[0];
            dArray[1] = -dArray[1];
            return -n;
        }
        return n;
    }

    private static int remPiOver2(double[] dArray, double[] dArray2, int n, int n2) {
        int n3;
        int n4;
        double d;
        double d2;
        int n5;
        int[] nArray = new int[20];
        double[] dArray3 = new double[20];
        double[] dArray4 = new double[20];
        boolean bl = false;
        int n6 = n5 = 4;
        int n7 = StrictMath.max((n - 3) / 24, 0);
        int n8 = n - 24 * (n7 + 1);
        int n9 = n7 - n2;
        int n10 = n2 + n5;
        int n11 = 0;
        while (n11 <= n10) {
            dArray3[n11] = n9 < 0 ? 0 : TWO_OVER_PI[n9];
            ++n11;
            ++n9;
        }
        n11 = 0;
        while (n11 <= n5) {
            n9 = 0;
            d2 = 0.0;
            while (n9 <= n2) {
                d2 += dArray[n9] * dArray3[n2 + n11 - n9];
                ++n9;
            }
            dArray4[n11] = d2;
            ++n11;
        }
        do {
            int n12;
            n11 = 0;
            n9 = n6;
            d = dArray4[n6];
            while (n9 > 0) {
                d2 = (int)(5.175473133E-315 * d);
                nArray[n11] = (int)(d - 5.424144515E-315 * d2);
                d = dArray4[n9 - 1] + d2;
                ++n11;
                --n9;
            }
            d = StrictMath.scale(d, n8);
            d -= 5.315350785E-315 * StrictMath.floor(d * 5.28426686E-315);
            n4 = (int)d;
            d -= (double)n4;
            n3 = 0;
            if (n8 > 0) {
                n11 = nArray[n6 - 1] >> 24 - n8;
                n4 += n11;
                int n13 = n6 - 1;
                nArray[n13] = nArray[n13] - (n11 << 24 - n8);
                n3 = nArray[n6 - 1] >> 23 - n8;
            } else if (n8 == 0) {
                n3 = nArray[n6 - 1] >> 23;
            } else if (d >= 5.29462817E-315) {
                n3 = 2;
            }
            if (n3 > 0) {
                ++n4;
                n12 = 0;
                n11 = 0;
                while (n11 < n6) {
                    n9 = nArray[n11];
                    if (n12 == 0) {
                        if (n9 != 0) {
                            n12 = 1;
                            nArray[n11] = 0x1000000 - n9;
                        }
                    } else {
                        nArray[n11] = 0xFFFFFF - n9;
                    }
                    ++n11;
                }
                switch (n8) {
                    case 1: {
                        int n14 = n6 - 1;
                        nArray[n14] = nArray[n14] & 0x7FFFFF;
                        break;
                    }
                    case 2: {
                        int n15 = n6 - 1;
                        nArray[n15] = nArray[n15] & 0x3FFFFF;
                    }
                }
                if (n3 == 2) {
                    d = 1.0 - d;
                    if (n12 != 0) {
                        d -= StrictMath.scale(1.0, n8);
                    }
                }
            }
            if (d != 0.0) continue;
            n9 = 0;
            n11 = n6 - 1;
            while (n11 >= n5) {
                n9 |= nArray[n11];
                --n11;
            }
            if (n9 != 0) continue;
            n12 = 1;
            while (nArray[n5 - n12] == 0) {
                ++n12;
            }
            n11 = n6 + 1;
            while (n11 <= n6 + n12) {
                dArray3[n2 + n11] = TWO_OVER_PI[n7 + n11];
                n9 = 0;
                d2 = 0.0;
                while (n9 <= n2) {
                    d2 += dArray[n9] * dArray3[n2 + n11 - n9];
                    ++n9;
                }
                dArray4[n11] = d2;
                ++n11;
            }
            n6 += n12;
            bl = true;
        } while (bl);
        if (d == 0.0) {
            --n6;
            n8 -= 24;
            while (nArray[n6] == 0) {
                --n6;
                n8 -= 24;
            }
        } else if ((d = StrictMath.scale(d, -n8)) >= 5.424144515E-315) {
            d2 = (int)(5.175473133E-315 * d);
            nArray[n6] = (int)(d - 5.424144515E-315 * d2);
            n8 += 24;
            nArray[++n6] = (int)d2;
        } else {
            nArray[n6] = (int)d;
        }
        d2 = StrictMath.scale(1.0, n8);
        n11 = n6;
        while (n11 >= 0) {
            dArray4[n11] = d2 * (double)nArray[n11];
            d2 *= 5.175473133E-315;
            --n11;
        }
        double[] dArray5 = new double[20];
        n11 = n6;
        while (n11 >= 0) {
            d2 = 0.0;
            int n16 = 0;
            while (n16 <= n5 && n16 <= n6 - n11) {
                d2 += PI_OVER_TWO[n16] * dArray4[n11 + n16];
                ++n16;
            }
            dArray5[n6 - n11] = d2;
            --n11;
        }
        d2 = 0.0;
        n11 = n6;
        while (n11 >= 0) {
            d2 += dArray5[n11];
            --n11;
        }
        dArray2[0] = n3 == 0 ? d2 : -d2;
        d2 = dArray5[0] - d2;
        n11 = 1;
        while (n11 <= n6) {
            d2 += dArray5[n11];
            ++n11;
        }
        dArray2[1] = n3 == 0 ? d2 : -d2;
        return n4;
    }

    private static double scale(double d, int n) {
        if (d == 0.0 || d == 2.1214777256E-314 || !(d < 1.06047983E-314) || n == 0) {
            return d;
        }
        long l = Double.doubleToLongBits(d);
        int n2 = (int)(l >> 52) & 0x7FF;
        if (n2 == 0) {
            n2 = ((int)(Double.doubleToLongBits(d *= 5.57956413E-315) >> 52) & 0x7FF) - 54;
        }
        if ((n2 += n) > 2046) {
            return 1.06047983E-314 * d;
        }
        if (n2 > 0) {
            return Double.longBitsToDouble(l & 0x800FFFFFFFFFFFFFL | (long)n2 << 52);
        }
        if (n2 <= -54) {
            return 0.0 * d;
        }
        d = Double.longBitsToDouble(l & 0x800FFFFFFFFFFFFFL | (long)(n2 += 54) << 52);
        return d * 5.02005352E-315;
    }

    private static double sin(double d, double d2) {
        if (StrictMath.abs(d) < 5.15993117E-315) {
            return d;
        }
        double d3 = d * d;
        double d4 = d3 * d;
        double d5 = 1.79101012345517E-226 + d3 * (1.2783700988357105E-184 + d3 * (2.769545250627641E114 + d3 * (-1.1224497452581291E-259 + d3 * 2.7582801474635986E129)));
        if (d2 == 0.0) {
            return d + d4 * (1.1945206316567233E103 + d3 * d5);
        }
        return d - (d3 * (5.29462817E-315 * d2 - d4 * d5) - d2 - d4 * 1.1945206316567233E103);
    }

    private static double cos(double d, double d2) {
        if ((d = StrictMath.abs(d)) < 5.15993117E-315) {
            return 1.0;
        }
        double d3 = d * d;
        double d4 = d3 * (1.1945227672265743E103 + d3 * (4.5249779206874525E-199 + d3 * (1.9919076347930888E-184 + d3 * (-1.0083309754791567E-305 + d3 * (-1.882144777122872E-11 + d3 * -1.8046793466734038E-7)))));
        if (d < 4.6672616413205735E-62) {
            return 1.0 - (5.29462817E-315 * d3 - (d3 * d4 - d * d2));
        }
        double d5 = d > 5.29754229E-315 ? 5.2900951E-315 : d * 5.289447516E-315;
        return 1.0 - d5 - (5.29462817E-315 * d3 - d5 - (d3 * d4 - d * d2));
    }

    private static double tan(double d, double d2, boolean bl) {
        double d3;
        double d4;
        boolean bl2;
        boolean bl3;
        boolean bl4 = bl3 = d < 0.0;
        if (bl3) {
            d = -d;
            d2 = -d2;
        }
        if (d < 5.15475052E-315) {
            return (double)(bl3 ? -1 : 1) * (bl ? 1.590978778E-314 / d : d);
        }
        boolean bl5 = bl2 = d >= 6.518959755170163E72;
        if (bl2) {
            d4 = 8.619199509632514E97 - d;
            d3 = 1.237279187554032E-62 - d2;
            d = d4 + d3;
            d2 = 0.0;
        }
        d4 = d * d;
        d3 = d4 * d4;
        double d5 = 1.7934126735187757E-226 + d3 * (-2.9292001900597004E-289 + d3 * (-1.9635657073187336E45 + d3 * (-5.023953991693648E245 + d3 * (-1.7581434147938015E-153 + d3 * -1.4485300332026018E132))));
        double d6 = d4 * (3.041507442886856E-175 + d3 * (-7.299975242772058E199 + d3 * (-1.4154236923197613E303 + d3 * (8.755266186470832E-181 + d3 * (2.5305160555765126E-63 + d3 * 2.3079603188981125E254)))));
        double d7 = d4 * d;
        d5 = d2 + d4 * (d7 * (d5 + d6) + d2);
        d3 = d + (d5 += 1.1945424189330822E103 * d7);
        if (bl2) {
            d6 = bl ? -1 : 1;
            return (double)(bl3 ? -1 : 1) * (d6 - 5.304989477E-315 * (d - (d3 * d3 / (d3 + d6) - d5)));
        }
        if (!bl) {
            return d3;
        }
        d4 = (float)d3;
        d6 = d5 - (d4 - d);
        double d8 = 1.590978778E-314 / d3;
        double d9 = (float)d8;
        return d9 + d8 * (1.0 + d9 * d4 + d9 * d6);
    }

    static {
        TWO_OVER_PI = new int[]{10680707, 0x6E4E44, 1387004, 2578385, 16069853, 12639074, 9804092, 4427841, 16666979, 11263675, 12935607, 2387514, 0x424DD2, 14681673, 3074569, 13734428, 16653803, 1880361, 10960616, 8533493, 3062596, 8710556, 7349940, 6258241, 3772886, 3769171, 3798172, 8675211, 12450088, 3874808, 9961438, 366607, 15675153, 9132554, 7151469, 3571407, 2607881, 12013382, 4155038, 6285869, 7677882, 13102053, 15825725, 473591, 9065106, 15363067, 6271263, 9264392, 5636912, 4652155, 7056368, 13614112, 10155062, 1944035, 9527646, 15080200, 6658437, 6231200, 6832269, 16767104, 5075751, 3212806, 1398474, 7579849, 6349435, 12618859};
        PI_OVER_TWO = new double[]{2.0000004766372945, 5.176854525E-315, -5.053817056E-315, 2.6815621800884123E154, -4.802500857E-315, 2.0000004207874014, -4.54974999E-315, 4.427499943E-315};
    }
}

