/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.io.ByteArrayOutputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.Comparator;
import java.util.Locale;
import kaffe.io.ByteToCharConverter;
import kaffe.io.CharToByteConverter;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class String
implements Serializable,
Comparable,
CharSequence {
    static final int STRINGBUFFER_SLOP = 32;
    final char[] value;
    final int offset;
    final int count;
    private boolean interned;
    private int hash;
    private static final long serialVersionUID = -6849794470754667710L;
    public static final Comparator CASE_INSENSITIVE_ORDER = new ICComp();

    public String() {
        this.value = new char[0];
        this.offset = 0;
        this.count = 0;
    }

    public String(String string) {
        this.value = string.value;
        this.offset = string.offset;
        this.count = string.count;
        this.hash = string.hash;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String(StringBuffer stringBuffer) {
        StringBuffer stringBuffer2 = stringBuffer;
        synchronized (stringBuffer2) {
            if (stringBuffer.buffer.length > stringBuffer.used + 32) {
                this.value = new char[stringBuffer.used];
                this.offset = 0;
                this.count = stringBuffer.used;
                System.arraycopy(stringBuffer.buffer, 0, this.value, 0, this.count);
            } else {
                this.value = stringBuffer.buffer;
                this.offset = 0;
                this.count = stringBuffer.used;
                stringBuffer.isStringized = true;
            }
            return;
        }
    }

    public String(byte[] byArray) {
        this(String.decodeBytes(byArray, 0, byArray.length, ByteToCharConverter.getDefault()));
    }

    public String(byte[] byArray, String string) throws UnsupportedEncodingException {
        this(String.decodeBytes(byArray, 0, byArray.length, ByteToCharConverter.getConverter(string)));
    }

    public String(byte[] byArray, int n) {
        this(byArray, n, 0, byArray.length);
    }

    public String(byte[] byArray, int n, int n2) {
        this(String.decodeBytes(byArray, n, n2, ByteToCharConverter.getDefault()));
    }

    public String(byte[] byArray, int n, int n2, String string) throws UnsupportedEncodingException {
        this(String.decodeBytes(byArray, n, n2, ByteToCharConverter.getConverter(string)));
    }

    public String(byte[] byArray, int n, int n2, int n3) {
        if (byArray == null) {
            throw new NullPointerException();
        }
        this.value = new char[n3];
        this.offset = 0;
        this.count = n3;
        n = (n & 0xFF) << 8;
        int n4 = 0;
        while (n4 < n3) {
            this.value[n4] = (char)(n | byArray[n4 + n2] & 0xFF);
            ++n4;
        }
    }

    public String(char[] cArray) {
        this(cArray, 0, cArray.length);
    }

    public String(char[] cArray, int n, int n2) {
        if (n2 < 0) {
            throw new StringIndexOutOfBoundsException();
        }
        this.value = new char[n2];
        this.offset = 0;
        this.count = n2;
        System.arraycopy(cArray, n, this.value, 0, n2);
    }

    String(int n, int n2, char[] cArray) {
        this.value = cArray;
        this.offset = n;
        this.count = n2 - n;
    }

    @Override
    public char charAt(int n) {
        if (n < 0 || n >= this.count) {
            throw new StringIndexOutOfBoundsException(new StringBuffer().append("index = ").append(n).append(", length=").append(this.count).toString());
        }
        return this.value[this.offset + n];
    }

    @Override
    public int compareTo(Object object) {
        return this.compareTo((String)object);
    }

    public int compareTo(String string) {
        int n = Math.min(this.count, string.count);
        int n2 = 0;
        while (n2 < n) {
            char c = this.value[this.offset + n2];
            char c2 = string.value[string.offset + n2];
            if (c != c2) {
                return c - c2;
            }
            ++n2;
        }
        return this.count - string.count;
    }

    public int compareToIgnoreCase(String string) {
        return this.toUpperCase().toLowerCase().compareTo(string.toUpperCase().toLowerCase());
    }

    public String concat(String string) {
        if (string.count == 0) {
            return this;
        }
        char[] cArray = new char[this.count + string.count];
        this.getChars(0, this.count, cArray, 0);
        string.getChars(0, string.count, cArray, this.count);
        return new String(0, cArray.length, cArray);
    }

    public static String copyValueOf(char[] cArray) {
        return String.copyValueOf(cArray, 0, cArray.length);
    }

    public static String copyValueOf(char[] cArray, int n, int n2) {
        if (n < 0 || n2 < 0 || n + n2 > cArray.length) {
            throw new IndexOutOfBoundsException();
        }
        char[] cArray2 = new char[n2];
        if (n2 > 0) {
            System.arraycopy(cArray, n, cArray2, 0, n2);
        }
        return new String(0, n2, cArray2);
    }

    public boolean endsWith(String string) {
        return this.regionMatches(false, this.count - string.count, string, 0, string.count);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof String)) {
            return false;
        }
        String string = (String)object;
        if (this.count != string.count) {
            return false;
        }
        int n = this.offset;
        int n2 = string.offset;
        int n3 = n + this.count;
        char[] cArray = this.value;
        char[] cArray2 = string.value;
        while (n < n3) {
            if (cArray[n] != cArray2[n2]) {
                return false;
            }
            ++n;
            ++n2;
        }
        return true;
    }

    public boolean equalsIgnoreCase(String string) {
        if (string == null || this.count != string.count) {
            return false;
        }
        int n = this.offset;
        int n2 = string.offset;
        int n3 = n + this.count;
        char[] cArray = this.value;
        char[] cArray2 = string.value;
        while (n < n3) {
            if (cArray[n] != cArray2[n2] && Character.toUpperCase(cArray[n]) != Character.toUpperCase(cArray2[n2])) {
                return false;
            }
            ++n;
            ++n2;
        }
        return true;
    }

    public byte[] getBytes() {
        return this.getBytes(CharToByteConverter.getDefault());
    }

    private byte[] getBytes(CharToByteConverter charToByteConverter) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(this.value.length);
        byte[] byArray = new byte[this.value.length * 7];
        int n = charToByteConverter.convert(this.value, this.offset, this.count, byArray, 0, byArray.length);
        while (n > 0) {
            byteArrayOutputStream.write(byArray, 0, n);
            n = charToByteConverter.flush(byArray, 0, byArray.length);
        }
        return byteArrayOutputStream.toByteArray();
    }

    public byte[] getBytes(String string) throws UnsupportedEncodingException {
        return this.getBytes(CharToByteConverter.getConverter(string));
    }

    public void getBytes(int n, int n2, byte[] byArray, int n3) {
        if (n < 0 || n > n2 || n3 < 0 || n3 + (n2 - n) > byArray.length || n2 > this.offset + this.count) {
            throw new IndexOutOfBoundsException("");
        }
        int n4 = n2 - n;
        int n5 = 0;
        while (n5 < n4) {
            byArray[n3 + n5] = (byte)this.value[this.offset + n + n5];
            ++n5;
        }
    }

    public void getChars(int n, int n2, char[] cArray, int n3) {
        System.arraycopy(this.value, this.offset + n, cArray, n3, n2 - n);
    }

    public int hashCode() {
        if (this.hash == 0 && this.count > 0) {
            int n = 0;
            int n2 = this.offset + this.count;
            int n3 = this.offset;
            while (n3 < n2) {
                n = 31 * n + this.value[n3];
                ++n3;
            }
            this.hash = n;
        }
        return this.hash;
    }

    public int indexOf(String string) {
        return this.indexOf(string, 0);
    }

    public native int indexOf(String var1, int var2);

    public int indexOf(int n) {
        return this.indexOf(n, 0);
    }

    public int indexOf(int n, int n2) {
        char c = (char)n;
        if (n2 < 0) {
            n2 = 0;
        }
        int n3 = n2;
        while (n3 < this.count) {
            if (this.value[this.offset + n3] == c) {
                return n3;
            }
            ++n3;
        }
        return -1;
    }

    private static StringBuffer decodeBytes(byte[] byArray, int n, int n2, ByteToCharConverter byteToCharConverter) {
        StringBuffer stringBuffer = new StringBuffer(n2);
        char[] cArray = new char[512];
        int n3 = byteToCharConverter.convert(byArray, n, n2, cArray, 0, cArray.length);
        while (n3 > 0) {
            stringBuffer.append(cArray, 0, n3);
            n3 = byteToCharConverter.flush(cArray, 0, cArray.length);
        }
        return stringBuffer;
    }

    public int lastIndexOf(String string) {
        return this.lastIndexOf(string, this.count);
    }

    /*
     * Unable to fully structure code
     */
    public int lastIndexOf(String var1_1, int var2_2) {
        var3_3 = var1_1.offset + var1_1.count - 1;
        var4_4 = this.offset + var2_2 + var1_1.count - 1;
        var5_5 = 0;
        if (var4_4 >= this.offset + this.count) {
            var4_4 = this.offset + this.count - 1;
        }
        if (var1_1.count != 0) ** GOTO lbl22
        if (var2_2 < 0) {
            return -1;
        }
        if (var2_2 < this.count) {
            return var2_2;
        }
        return this.count;
lbl-1000:
        // 1 sources

        {
            if (this.value[var4_4] == var1_1.value[var3_3]) {
                --var3_3;
                if (++var5_5 == var1_1.count) {
                    return var4_4 - this.offset;
                }
            } else if (var5_5 > 0) {
                ++var4_4;
                var5_5 = 0;
                var3_3 = var1_1.offset + var1_1.count - 1;
            }
            --var4_4;
lbl22:
            // 2 sources

            ** while (var4_4 >= this.offset)
        }
lbl23:
        // 1 sources

        return -1;
    }

    public int lastIndexOf(int n) {
        return this.lastIndexOf(n, this.count - 1);
    }

    public int lastIndexOf(int n, int n2) {
        char c = (char)n;
        if (c != n) {
            return -1;
        }
        if (n2 >= this.count) {
            n2 = this.count - 1;
        }
        if (n2 < 0) {
            return -1;
        }
        int n3 = n2;
        while (n3 >= 0) {
            if (this.value[this.offset + n3] == c) {
                return n3;
            }
            --n3;
        }
        return -1;
    }

    @Override
    public int length() {
        return this.count;
    }

    /*
     * Unable to fully structure code
     */
    public boolean regionMatches(boolean var1_1, int var2_2, String var3_3, int var4_4, int var5_5) {
        block5: {
            if (var2_2 < 0 || var2_2 + var5_5 > this.count || var4_4 < 0 || var4_4 + var5_5 > var3_3.count) {
                return false;
            }
            var6_6 = this.offset + var2_2;
            var7_7 = var3_3.offset + var4_4;
            if (var1_1) ** GOTO lbl17
            while (var5_5-- > 0) {
                if (this.value[var6_6] != var3_3.value[var7_7]) {
                    return false;
                }
                ++var6_6;
                ++var7_7;
            }
            break block5;
lbl-1000:
            // 1 sources

            {
                if (Character.toLowerCase(this.value[var6_6]) != Character.toLowerCase(var3_3.value[var7_7]) && Character.toUpperCase(this.value[var6_6]) != Character.toUpperCase(var3_3.value[var7_7])) {
                    return false;
                }
                ++var6_6;
                ++var7_7;
lbl17:
                // 2 sources

                ** while (var5_5-- > 0)
            }
        }
        return true;
    }

    public boolean regionMatches(int n, String string, int n2, int n3) {
        return this.regionMatches(false, n, string, n2, n3);
    }

    public String replace(char c, char c2) {
        if (c == c2) {
            return this;
        }
        char[] cArray = new char[this.count];
        boolean bl = false;
        int n = 0;
        while (n < this.count) {
            char c3 = this.value[this.offset + n];
            if (c3 == c) {
                bl = true;
                cArray[n] = c2;
            } else {
                cArray[n] = c3;
            }
            ++n;
        }
        if (!bl) {
            return this;
        }
        return new String(0, this.count, cArray);
    }

    public boolean startsWith(String string) {
        return this.regionMatches(false, 0, string, 0, string.count);
    }

    public boolean startsWith(String string, int n) {
        return this.regionMatches(false, n, string, 0, string.count);
    }

    public String substring(int n) {
        return this.substring(n, this.count);
    }

    public String substring(int n, int n2) {
        if (n < 0) {
            throw new StringIndexOutOfBoundsException(n);
        }
        if (n2 > this.count) {
            throw new StringIndexOutOfBoundsException(n2);
        }
        if (n > n2) {
            throw new StringIndexOutOfBoundsException(n2 - n);
        }
        if (n == 0 && n2 == this.count) {
            return this;
        }
        return new String(this.offset + n, this.offset + n2, this.value);
    }

    @Override
    public CharSequence subSequence(int n, int n2) {
        return this.substring(n, n2);
    }

    public char[] toCharArray() {
        char[] cArray = new char[this.count];
        if (this.count > 0) {
            this.getChars(0, this.count, cArray, 0);
        }
        return cArray;
    }

    public String toLowerCase() {
        return this.toLowerCase(Locale.getDefault());
    }

    public String toLowerCase(Locale locale2) {
        char[] cArray = new char[this.count];
        int n = 0;
        while (n < this.count) {
            cArray[n] = Character.toLowerCase(this.value[this.offset + n]);
            ++n;
        }
        return new String(0, this.count, cArray);
    }

    @Override
    public String toString() {
        return this;
    }

    public String toUpperCase() {
        return this.toUpperCase(Locale.getDefault());
    }

    public String toUpperCase(Locale locale2) {
        char[] cArray = new char[this.count];
        int n = 0;
        while (n < this.count) {
            cArray[n] = Character.toUpperCase(this.value[this.offset + n]);
            ++n;
        }
        return new String(0, this.count, cArray);
    }

    /*
     * Unable to fully structure code
     */
    public String trim() {
        var1_1 = this.offset;
        var2_2 = this.offset + this.count - 1;
        while (var1_1 <= var2_2 && this.value[var1_1] <= ' ') {
            ++var1_1;
        }
        if (var1_1 <= var2_2) ** GOTO lbl9
        return "";
lbl-1000:
        // 1 sources

        {
            --var2_2;
lbl9:
            // 2 sources

            ** while (var2_2 > var1_1 && this.value[var2_2] <= ' ')
        }
lbl10:
        // 1 sources

        return this.substring(var1_1 - this.offset, var2_2 + 1 - this.offset);
    }

    public static String valueOf(Object object) {
        if (object == null) {
            return "null";
        }
        return object.toString();
    }

    public static String valueOf(boolean bl) {
        return new Boolean(bl).toString();
    }

    public static String valueOf(char c) {
        return new String(new char[]{c});
    }

    public static String valueOf(char[] cArray) {
        return new String(cArray);
    }

    public static String valueOf(char[] cArray, int n, int n2) {
        return new String(cArray, n, n2);
    }

    public static String valueOf(double d) {
        return Double.toString(d);
    }

    public static String valueOf(float f) {
        return Float.toString(f);
    }

    public static String valueOf(int n) {
        return Integer.toString(n);
    }

    public static String valueOf(long l) {
        return Long.toString(l);
    }

    public String intern() {
        if (this.interned) {
            return this;
        }
        return String.intern0(this);
    }

    private static synchronized native String intern0(String var0);

    /*
     * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ICComp
    implements Comparator,
    Serializable {
        @Override
        public int compare(Object object, Object object2) {
            return ((String)object).compareToIgnoreCase((String)object2);
        }

        private ICComp() {
        }
    }
}

